/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.service.TppStopListService;
import de.adorsys.psd2.consent.domain.TppStopListEntity;
import de.adorsys.psd2.consent.repository.TppStopListRepository;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class TppStopListServiceInternal
implements TppStopListService {
    private static final Logger log = LoggerFactory.getLogger(TppStopListServiceInternal.class);
    private final TppStopListRepository tppStopListRepository;
    @Value(value="${cms.service.instance-id:UNDEFINED}")
    private String serviceInstanceId;

    public CmsResponse<Boolean> checkIfTppBlocked(String tppAuthorisationNumber) {
        Optional<TppStopListEntity> stopListEntityOptional = this.tppStopListRepository.findByTppAuthorisationNumberAndInstanceId(tppAuthorisationNumber, this.serviceInstanceId);
        Boolean blocked = stopListEntityOptional.filter(TppStopListEntity::isBlocked).map(sl -> {
            log.info("TPP ID: [{}]. TPP has been blocked, because it's in stop list", (Object)tppAuthorisationNumber);
            return true;
        }).orElse(false);
        return CmsResponse.builder().payload((Object)blocked).build();
    }

    @ConstructorProperties(value={"tppStopListRepository"})
    public TppStopListServiceInternal(TppStopListRepository tppStopListRepository) {
        this.tppStopListRepository = tppStopListRepository;
    }
}

