/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.api.TypeAccess;
import de.adorsys.psd2.consent.domain.account.AisConsent;
import de.adorsys.psd2.consent.domain.account.AisConsentTransaction;
import de.adorsys.psd2.consent.domain.account.AspspAccountAccess;
import de.adorsys.psd2.consent.repository.AisConsentTransactionRepository;
import de.adorsys.psd2.consent.repository.AisConsentUsageRepository;
import de.adorsys.psd2.xs2a.core.consent.AisConsentRequestType;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class OneOffConsentExpirationService {
    private final AisConsentUsageRepository aisConsentUsageRepository;
    private final AisConsentTransactionRepository aisConsentTransactionRepository;

    public boolean isConsentExpired(AisConsent consent) {
        if (consent.getAisConsentRequestType() == AisConsentRequestType.BANK_OFFERED) {
            return false;
        }
        if (consent.getAisConsentRequestType() == AisConsentRequestType.ALL_AVAILABLE_ACCOUNTS) {
            return true;
        }
        List consentResourceIds = consent.getAspspAccountAccesses().stream().map(AspspAccountAccess::getResourceId).distinct().collect(Collectors.toList());
        boolean isExpired = true;
        for (String resourceId : consentResourceIds) {
            Optional<AisConsentTransaction> transactionOptional = this.aisConsentTransactionRepository.findByConsentIdAndResourceId(consent, resourceId);
            int transactions = transactionOptional.map(AisConsentTransaction::getNumberOfTransactions).orElse(0);
            int maximumNumberOfGetRequestsForConsent = this.getMaximumNumberOfGetRequestsForConsentsAccount(consent.getAspspAccountAccesses(), resourceId, transactions);
            int numberOfUsedGetRequestsForConsent = this.aisConsentUsageRepository.countByConsentIdAndResourceId(consent.getId(), resourceId);
            if (numberOfUsedGetRequestsForConsent >= maximumNumberOfGetRequestsForConsent) continue;
            isExpired = false;
            break;
        }
        return isExpired;
    }

    private int getMaximumNumberOfGetRequestsForConsentsAccount(List<AspspAccountAccess> aspspAccountAccesses, String resourceId, int numberOfTransactions) {
        List filteredByResourceId = aspspAccountAccesses.stream().filter(access -> access.getResourceId().equals(resourceId)).collect(Collectors.toList());
        if (filteredByResourceId.stream().allMatch(access -> access.getTypeAccess() == TypeAccess.ACCOUNT)) {
            return 1;
        }
        if (filteredByResourceId.stream().noneMatch(access -> access.getTypeAccess() == TypeAccess.TRANSACTION)) {
            return 2;
        }
        if (filteredByResourceId.stream().noneMatch(access -> access.getTypeAccess() == TypeAccess.BALANCE)) {
            return 2 + numberOfTransactions;
        }
        return 3 + numberOfTransactions;
    }

    @ConstructorProperties(value={"aisConsentUsageRepository", "aisConsentTransactionRepository"})
    public OneOffConsentExpirationService(AisConsentUsageRepository aisConsentUsageRepository, AisConsentTransactionRepository aisConsentTransactionRepository) {
        this.aisConsentUsageRepository = aisConsentUsageRepository;
        this.aisConsentTransactionRepository = aisConsentTransactionRepository;
    }
}

