/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.service.security.SecurityDataService;
import de.adorsys.psd2.event.service.Xs2aEventService;
import de.adorsys.psd2.event.service.Xs2aEventServiceEncrypted;
import de.adorsys.psd2.event.service.model.EventBO;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EventServiceEncryptedImpl
implements Xs2aEventServiceEncrypted {
    private final SecurityDataService securityDataService;
    private final Xs2aEventService eventService;

    @Transactional
    public boolean recordEvent(@NotNull EventBO event) {
        String decryptedConsentId = this.decryptId(event.getConsentId());
        String decryptedPaymentId = this.decryptId(event.getPaymentId());
        EventBO decryptedEvent = EventBO.builder().timestamp(event.getTimestamp()).consentId(decryptedConsentId).paymentId(decryptedPaymentId).payload(event.getPayload()).eventOrigin(event.getEventOrigin()).eventType(event.getEventType()).psuIdData(event.getPsuIdData()).tppAuthorisationNumber(event.getTppAuthorisationNumber()).xRequestId(event.getXRequestId()).internalRequestId(event.getInternalRequestId()).build();
        return this.eventService.recordEvent(decryptedEvent);
    }

    private String decryptId(String id) {
        return Optional.ofNullable(id).flatMap(this.securityDataService::decryptId).orElse(null);
    }

    @ConstructorProperties(value={"securityDataService", "eventService"})
    public EventServiceEncryptedImpl(SecurityDataService securityDataService, Xs2aEventService eventService) {
        this.securityDataService = securityDataService;
        this.eventService = eventService;
    }
}

