/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.api.CmsError;
import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.WrongChecksumException;
import de.adorsys.psd2.consent.api.ais.AisAccountAccessInfo;
import de.adorsys.psd2.consent.api.ais.AisAccountConsent;
import de.adorsys.psd2.consent.api.ais.AisConsentActionRequest;
import de.adorsys.psd2.consent.api.ais.CreateAisConsentRequest;
import de.adorsys.psd2.consent.api.ais.CreateAisConsentResponse;
import de.adorsys.psd2.consent.api.service.AisConsentService;
import de.adorsys.psd2.consent.api.service.AisConsentServiceEncrypted;
import de.adorsys.psd2.consent.service.security.SecurityDataService;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class AisConsentServiceInternalEncrypted
implements AisConsentServiceEncrypted {
    private static final Logger log = LoggerFactory.getLogger(AisConsentServiceInternalEncrypted.class);
    private final SecurityDataService securityDataService;
    private final AisConsentService aisConsentService;

    @Transactional(rollbackFor={WrongChecksumException.class})
    public CmsResponse<CreateAisConsentResponse> createConsent(CreateAisConsentRequest request) throws WrongChecksumException {
        CmsResponse serviceResponse = this.aisConsentService.createConsent(request);
        if (serviceResponse.hasError()) {
            return serviceResponse;
        }
        CreateAisConsentResponse createAisConsentResponse = (CreateAisConsentResponse)serviceResponse.getPayload();
        Optional<String> encryptIdOptional = this.securityDataService.encryptId(createAisConsentResponse.getConsentId());
        if (!encryptIdOptional.isPresent()) {
            log.info("Consent ID: [{}]. Create consent failed, couldn't encrypt consent id", (Object)createAisConsentResponse.getConsentId());
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
        return CmsResponse.builder().payload((Object)new CreateAisConsentResponse(encryptIdOptional.get(), createAisConsentResponse.getAisAccountConsent(), createAisConsentResponse.getTppNotificationContentPreferred())).build();
    }

    @Transactional
    public CmsResponse<ConsentStatus> getConsentStatusById(String encryptedConsentId) {
        Optional<String> decryptIdOptional = this.securityDataService.decryptId(encryptedConsentId);
        if (!decryptIdOptional.isPresent()) {
            log.info("Encrypted Consent ID: [{}]. Get consent status by id failed, couldn't decrypt consent id", (Object)encryptedConsentId);
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
        return this.aisConsentService.getConsentStatusById(decryptIdOptional.get());
    }

    @Transactional(rollbackFor={WrongChecksumException.class})
    public CmsResponse<Boolean> updateConsentStatusById(String encryptedConsentId, ConsentStatus status) throws WrongChecksumException {
        Optional<String> decryptIdOptional = this.securityDataService.decryptId(encryptedConsentId);
        if (!decryptIdOptional.isPresent()) {
            log.info("Encrypted Consent ID: [{}]. Update consent by id failed, couldn't decrypt consent id", (Object)encryptedConsentId);
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
        return this.aisConsentService.updateConsentStatusById(decryptIdOptional.get(), status);
    }

    @Transactional
    public CmsResponse<AisAccountConsent> getAisAccountConsentById(String encryptedConsentId) {
        Optional<String> decryptIdOptional = this.securityDataService.decryptId(encryptedConsentId);
        if (!decryptIdOptional.isPresent()) {
            log.info("Encrypted Consent ID: [{}]. Get consent by id failed, couldn't decrypt consent id", (Object)encryptedConsentId);
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
        return this.aisConsentService.getAisAccountConsentById(decryptIdOptional.get());
    }

    @Transactional
    public CmsResponse<Boolean> findAndTerminateOldConsentsByNewConsentId(String encryptedNewConsentId) {
        Optional<String> decryptIdOptional = this.securityDataService.decryptId(encryptedNewConsentId);
        if (!decryptIdOptional.isPresent()) {
            log.info("Encrypted Consent ID: [{}]. Terminate consent by id failed, couldn't decrypt consent id", (Object)encryptedNewConsentId);
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
        return this.aisConsentService.findAndTerminateOldConsentsByNewConsentId(decryptIdOptional.get());
    }

    @Transactional(rollbackFor={WrongChecksumException.class})
    public CmsResponse<CmsResponse.VoidResponse> checkConsentAndSaveActionLog(AisConsentActionRequest encryptedRequest) throws WrongChecksumException {
        String consentId = encryptedRequest.getConsentId();
        Optional<String> decryptedConsentId = this.securityDataService.decryptId(consentId);
        if (!decryptedConsentId.isPresent()) {
            log.info("Encrypted Consent ID: [{}]. Check consent and save action log failed, couldn't decrypt consent id", (Object)consentId);
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
        AisConsentActionRequest decryptedRequest = new AisConsentActionRequest(encryptedRequest.getTppId(), decryptedConsentId.get(), encryptedRequest.getActionStatus(), encryptedRequest.getRequestUri(), encryptedRequest.isUpdateUsage(), encryptedRequest.getResourceId(), encryptedRequest.getTransactionId());
        return this.aisConsentService.checkConsentAndSaveActionLog(decryptedRequest);
    }

    @Transactional(rollbackFor={WrongChecksumException.class})
    public CmsResponse<String> updateAspspAccountAccess(String encryptedConsentId, AisAccountAccessInfo request) throws WrongChecksumException {
        Optional<String> decryptIdOptional = this.securityDataService.decryptId(encryptedConsentId);
        if (!decryptIdOptional.isPresent()) {
            log.info("Encrypted Consent ID: [{}]. Update aspsp account access failed, couldn't decrypt consent id", (Object)encryptedConsentId);
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
        CmsResponse cmsResponse = this.aisConsentService.updateAspspAccountAccess(decryptIdOptional.get(), request);
        if (cmsResponse.hasError()) {
            return cmsResponse;
        }
        Optional<String> encryptIdOptional = this.securityDataService.encryptId((String)cmsResponse.getPayload());
        if (!encryptIdOptional.isPresent()) {
            log.info("Encrypted Consent ID: [{}]. Update aspsp account access failed, couldn't decrypt consent id", (Object)encryptedConsentId);
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
        return CmsResponse.builder().payload((Object)encryptIdOptional.get()).build();
    }

    @Transactional(rollbackFor={WrongChecksumException.class})
    public CmsResponse<AisAccountConsent> updateAspspAccountAccessWithResponse(String encryptedConsentId, AisAccountAccessInfo request) throws WrongChecksumException {
        Optional<String> decryptIdOptional = this.securityDataService.decryptId(encryptedConsentId);
        if (!decryptIdOptional.isPresent()) {
            log.info("Encrypted Consent ID: [{}]. Update aspsp account access with response failed, couldn't decrypt consent id", (Object)encryptedConsentId);
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
        return this.aisConsentService.updateAspspAccountAccessWithResponse(decryptIdOptional.get(), request);
    }

    public CmsResponse<List<PsuIdData>> getPsuDataByConsentId(String encryptedConsentId) {
        Optional<String> decryptIdOptional = this.securityDataService.decryptId(encryptedConsentId);
        if (!decryptIdOptional.isPresent()) {
            log.info("Encrypted Consent ID: [{}]. Get psu data by consent id failed, couldn't decrypt consent id", (Object)encryptedConsentId);
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
        return this.aisConsentService.getPsuDataByConsentId(decryptIdOptional.get());
    }

    @Transactional(rollbackFor={WrongChecksumException.class})
    public CmsResponse<Boolean> updateMultilevelScaRequired(String encryptedConsentId, boolean multilevelScaRequired) throws WrongChecksumException {
        Optional<String> decryptIdOptional = this.securityDataService.decryptId(encryptedConsentId);
        if (!decryptIdOptional.isPresent()) {
            log.info("Encrypted Consent ID: [{}]. Update MultilevelScaRequired failed, couldn't decrypt consent id", (Object)encryptedConsentId);
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
        return this.aisConsentService.updateMultilevelScaRequired(decryptIdOptional.get(), multilevelScaRequired);
    }

    @ConstructorProperties(value={"securityDataService", "aisConsentService"})
    public AisConsentServiceInternalEncrypted(SecurityDataService securityDataService, AisConsentService aisConsentService) {
        this.securityDataService = securityDataService;
        this.aisConsentService = aisConsentService;
    }
}

