/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.domain.account;

import de.adorsys.psd2.consent.api.AccountInfo;
import de.adorsys.psd2.consent.api.TypeAccess;
import de.adorsys.psd2.consent.api.ais.AisAccountAccessInfo;
import de.adorsys.psd2.consent.domain.account.AccountAccessHolder;
import de.adorsys.psd2.consent.domain.account.TppAccountAccess;
import de.adorsys.psd2.xs2a.core.profile.AccountReferenceType;
import java.util.Currency;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public final class TppAccountAccessHolder
extends AccountAccessHolder<TppAccountAccess> {
    public TppAccountAccessHolder(AisAccountAccessInfo accountAccessInfo) {
        super(accountAccessInfo);
    }

    @Override
    public void doFillAccess(List<AccountInfo> info, TypeAccess typeAccess) {
        if (CollectionUtils.isNotEmpty(info)) {
            info.forEach(a -> this.addAccountAccess(a.getAccountIdentifier(), typeAccess, a.getAccountType(), this.getCurrencyByString(a.getCurrency())));
        }
    }

    private void addAccountAccess(String accountIdentifier, TypeAccess typeAccess, AccountReferenceType accountReferenceType, Currency currency) {
        this.accountAccesses.add(new TppAccountAccess(accountIdentifier, typeAccess, accountReferenceType, currency));
        if (EnumSet.of(TypeAccess.BALANCE, TypeAccess.TRANSACTION).contains(typeAccess)) {
            this.accountAccesses.add(new TppAccountAccess(accountIdentifier, TypeAccess.ACCOUNT, accountReferenceType, currency));
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TppAccountAccessHolder)) {
            return false;
        }
        TppAccountAccessHolder other = (TppAccountAccessHolder)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof TppAccountAccessHolder;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "TppAccountAccessHolder()";
    }
}

