/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.mapper;

import de.adorsys.psd2.consent.api.TypeAccess;
import de.adorsys.psd2.consent.api.ais.AdditionalAccountInformationType;
import de.adorsys.psd2.consent.api.ais.AisAccountAccess;
import de.adorsys.psd2.consent.api.ais.AisAccountConsent;
import de.adorsys.psd2.consent.api.ais.AisAccountConsentAuthorisation;
import de.adorsys.psd2.consent.api.ais.CmsAisAccountConsent;
import de.adorsys.psd2.consent.domain.AuthorisationEntity;
import de.adorsys.psd2.consent.domain.account.AisConsent;
import de.adorsys.psd2.consent.domain.account.AspspAccountAccess;
import de.adorsys.psd2.consent.domain.account.TppAccountAccess;
import de.adorsys.psd2.consent.service.AisConsentUsageService;
import de.adorsys.psd2.consent.service.mapper.AuthorisationTemplateMapper;
import de.adorsys.psd2.consent.service.mapper.PsuDataMapper;
import de.adorsys.psd2.consent.service.mapper.TppInfoMapper;
import de.adorsys.psd2.xs2a.core.ais.AccountAccessType;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.core.profile.AccountReferenceSelector;
import de.adorsys.psd2.xs2a.core.profile.AdditionalInformationAccess;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class AisConsentMapper {
    private final PsuDataMapper psuDataMapper;
    private final TppInfoMapper tppInfoMapper;
    private final AisConsentUsageService aisConsentUsageService;
    private final AuthorisationTemplateMapper authorisationTemplateMapper;

    private AisAccountAccess getAvailableAccess(AisConsent consent) {
        AisAccountAccess tppAccountAccess = this.mapToAisAccountAccess(consent);
        AisAccountAccess aspspAccountAccess = this.mapToAspspAisAccountAccess(consent);
        return tppAccountAccess.getAllPsd2() != null ? tppAccountAccess : (aspspAccountAccess.isNotEmpty() ? aspspAccountAccess : tppAccountAccess);
    }

    public AisAccountConsent mapToAisAccountConsent(AisConsent consent, List<AuthorisationEntity> authorisations) {
        AisAccountAccess chosenAccess = this.getAvailableAccess(consent);
        Map<String, Integer> usageCounterMap = this.aisConsentUsageService.getUsageCounterMap(consent);
        return new AisAccountConsent(consent.getExternalId(), chosenAccess, this.mapToAspspAisAccountAccess(consent), consent.isRecurringIndicator(), consent.getValidUntil(), consent.getExpireDate(), consent.getAllowedFrequencyPerDay(), consent.getLastActionDate(), consent.getConsentStatus(), consent.getAccesses().stream().anyMatch(a -> a.getTypeAccess() == TypeAccess.BALANCE), consent.isTppRedirectPreferred(), consent.getAisConsentRequestType(), this.psuDataMapper.mapToPsuIdDataList(consent.getPsuDataList()), this.tppInfoMapper.mapToTppInfo(consent.getTppInfo()), this.authorisationTemplateMapper.mapToAuthorisationTemplate(consent.getAuthorisationTemplate()), consent.isMultilevelScaRequired(), this.mapToAisAccountConsentAuthorisation(authorisations), usageCounterMap, consent.getCreationTimestamp(), consent.getStatusChangeTimestamp());
    }

    public CmsAisAccountConsent mapToCmsAisAccountConsent(AisConsent consent, List<AuthorisationEntity> authorisations) {
        AisAccountAccess chosenAccess = this.getAvailableAccess(consent);
        Map<String, Integer> usageCounterMap = this.aisConsentUsageService.getUsageCounterMap(consent);
        return new CmsAisAccountConsent(consent.getExternalId(), chosenAccess, consent.isRecurringIndicator(), consent.getValidUntil(), consent.getExpireDate(), consent.getAllowedFrequencyPerDay(), consent.getLastActionDate(), consent.getConsentStatus(), consent.getAccesses().stream().anyMatch(a -> a.getTypeAccess() == TypeAccess.BALANCE), consent.isTppRedirectPreferred(), consent.getAisConsentRequestType(), this.psuDataMapper.mapToPsuIdDataList(consent.getPsuDataList()), this.tppInfoMapper.mapToTppInfo(consent.getTppInfo()), this.authorisationTemplateMapper.mapToAuthorisationTemplate(consent.getAuthorisationTemplate()), consent.isMultilevelScaRequired(), this.mapToAisAccountConsentAuthorisation(authorisations), usageCounterMap, consent.getCreationTimestamp(), consent.getStatusChangeTimestamp());
    }

    public Set<AspspAccountAccess> mapAspspAccountAccesses(AisAccountAccess aisAccountAccess) {
        HashSet<AspspAccountAccess> accesses = new HashSet<AspspAccountAccess>();
        accesses.addAll(this.getAspspAccountAccesses(TypeAccess.ACCOUNT, aisAccountAccess.getAccounts()));
        accesses.addAll(this.getAspspAccountAccesses(TypeAccess.BALANCE, aisAccountAccess.getBalances()));
        accesses.addAll(this.getAspspAccountAccesses(TypeAccess.TRANSACTION, aisAccountAccess.getTransactions()));
        AdditionalInformationAccess info = aisAccountAccess.getAccountAdditionalInformationAccess();
        if (info != null) {
            BiConsumer<List, TypeAccess> updateAccesses = (list, type) -> {
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    accesses.addAll(this.getAspspAccountAccesses((TypeAccess)type, (List<AccountReference>)list));
                }
            };
            updateAccesses.accept(info.getOwnerName(), TypeAccess.OWNER_NAME);
        }
        return accesses;
    }

    private AisAccountAccess mapToAisAccountAccess(AisConsent consent) {
        List<TppAccountAccess> accesses = consent.getAccesses();
        return new AisAccountAccess(this.mapToInitialAccountReferences(accesses, TypeAccess.ACCOUNT), this.mapToInitialAccountReferences(accesses, TypeAccess.BALANCE), this.mapToInitialAccountReferences(accesses, TypeAccess.TRANSACTION), this.getAccessType(consent.getAvailableAccounts()), this.getAccessType(consent.getAllPsd2()), this.getAccessType(consent.getAvailableAccountsWithBalance()), this.mapToInitialAdditionalInformationAccess(accesses, consent));
    }

    private List<AccountReference> mapToInitialAccountReferences(List<TppAccountAccess> aisAccounts, TypeAccess typeAccess) {
        return aisAccounts.stream().filter(a -> a.getTypeAccess() == typeAccess).map(access -> new AccountReference(access.getAccountReferenceType(), access.getAccountIdentifier(), access.getCurrency())).collect(Collectors.toList());
    }

    private AisAccountAccess mapToAspspAisAccountAccess(AisConsent consent) {
        List<AspspAccountAccess> accesses = consent.getAspspAccountAccesses();
        return new AisAccountAccess(this.mapToAccountReferences(accesses, TypeAccess.ACCOUNT), this.mapToAccountReferences(accesses, TypeAccess.BALANCE), this.mapToAccountReferences(accesses, TypeAccess.TRANSACTION), this.getAccessType(consent.getAvailableAccounts()), this.getAccessType(consent.getAllPsd2()), this.getAccessType(consent.getAvailableAccountsWithBalance()), this.mapToAspspAdditionalInformationAccess(accesses, consent));
    }

    private AdditionalInformationAccess mapToInitialAdditionalInformationAccess(List<TppAccountAccess> accesses, AisConsent consent) {
        return consent.checkNoneAdditionalAccountInformation() ? null : new AdditionalInformationAccess(this.mapToAdditionalInformationInitialAccountReferences(consent.getOwnerNameType(), TypeAccess.OWNER_NAME, accesses));
    }

    private List<AccountReference> mapToAdditionalInformationInitialAccountReferences(AdditionalAccountInformationType type, TypeAccess typeAccess, List<TppAccountAccess> accesses) {
        return type == AdditionalAccountInformationType.DEDICATED_ACCOUNTS ? this.mapToInitialAccountReferences(accesses, typeAccess) : (type == AdditionalAccountInformationType.ALL_AVAILABLE_ACCOUNTS ? Collections.emptyList() : null);
    }

    private AdditionalInformationAccess mapToAspspAdditionalInformationAccess(List<AspspAccountAccess> accesses, AisConsent consent) {
        return consent.checkNoneAdditionalAccountInformation() ? null : new AdditionalInformationAccess(this.mapToAdditionalInformationAspspAccountReferences(consent.getOwnerNameType(), TypeAccess.OWNER_NAME, accesses));
    }

    private List<AccountReference> mapToAdditionalInformationAspspAccountReferences(AdditionalAccountInformationType type, TypeAccess typeAccess, List<AspspAccountAccess> accesses) {
        return type == AdditionalAccountInformationType.DEDICATED_ACCOUNTS ? this.mapToAccountReferences(accesses, typeAccess) : (type == AdditionalAccountInformationType.ALL_AVAILABLE_ACCOUNTS ? Collections.emptyList() : null);
    }

    private List<AccountReference> mapToAccountReferences(List<AspspAccountAccess> aisAccounts, TypeAccess typeAccess) {
        return aisAccounts.stream().filter(a -> a.getTypeAccess() == typeAccess).map(access -> new AccountReference(access.getAccountReferenceType(), access.getAccountIdentifier(), access.getCurrency(), access.getResourceId(), access.getAspspAccountId())).collect(Collectors.toList());
    }

    private Set<AspspAccountAccess> getAspspAccountAccesses(TypeAccess typeAccess, List<AccountReference> accountReferences) {
        return Optional.ofNullable(accountReferences).map(lst -> lst.stream().map(acc -> this.mapToAspspAccountAccess(typeAccess, (AccountReference)acc)).collect(Collectors.toSet())).orElse(Collections.emptySet());
    }

    private AspspAccountAccess mapToAspspAccountAccess(TypeAccess typeAccess, AccountReference accountReference) {
        AccountReferenceSelector selector = accountReference.getUsedAccountReferenceSelector();
        return new AspspAccountAccess(selector.getAccountValue(), typeAccess, selector.getAccountReferenceType(), accountReference.getCurrency(), accountReference.getResourceId(), accountReference.getAspspAccountId());
    }

    private String getAccessType(AccountAccessType type) {
        return Optional.ofNullable(type).map(Enum::name).orElse(null);
    }

    private List<AisAccountConsentAuthorisation> mapToAisAccountConsentAuthorisation(List<AuthorisationEntity> aisConsentAuthorisations) {
        if (CollectionUtils.isEmpty(aisConsentAuthorisations)) {
            return Collections.emptyList();
        }
        return aisConsentAuthorisations.stream().map(this::mapToAisAccountConsentAuthorisation).collect(Collectors.toList());
    }

    private AisAccountConsentAuthorisation mapToAisAccountConsentAuthorisation(AuthorisationEntity aisConsentAuthorisation) {
        return Optional.ofNullable(aisConsentAuthorisation).map(auth -> new AisAccountConsentAuthorisation(auth.getExternalId(), this.psuDataMapper.mapToPsuIdData(auth.getPsuData()), auth.getScaStatus())).orElse(null);
    }

    @ConstructorProperties(value={"psuDataMapper", "tppInfoMapper", "aisConsentUsageService", "authorisationTemplateMapper"})
    public AisConsentMapper(PsuDataMapper psuDataMapper, TppInfoMapper tppInfoMapper, AisConsentUsageService aisConsentUsageService, AuthorisationTemplateMapper authorisationTemplateMapper) {
        this.psuDataMapper = psuDataMapper;
        this.tppInfoMapper = tppInfoMapper;
        this.aisConsentUsageService = aisConsentUsageService;
        this.authorisationTemplateMapper = authorisationTemplateMapper;
    }
}

