/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.api.CmsError;
import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.pis.CreatePisCommonPaymentResponse;
import de.adorsys.psd2.consent.api.pis.PisPayment;
import de.adorsys.psd2.consent.api.pis.proto.PisCommonPaymentRequest;
import de.adorsys.psd2.consent.api.pis.proto.PisCommonPaymentResponse;
import de.adorsys.psd2.consent.api.pis.proto.PisPaymentInfo;
import de.adorsys.psd2.consent.api.service.PisCommonPaymentService;
import de.adorsys.psd2.consent.domain.AuthorisationEntity;
import de.adorsys.psd2.consent.domain.payment.PisCommonPaymentData;
import de.adorsys.psd2.consent.domain.payment.PisPaymentData;
import de.adorsys.psd2.consent.repository.AuthorisationRepository;
import de.adorsys.psd2.consent.repository.PisCommonPaymentDataRepository;
import de.adorsys.psd2.consent.repository.PisPaymentDataRepository;
import de.adorsys.psd2.consent.repository.TppInfoRepository;
import de.adorsys.psd2.consent.service.CorePaymentsConvertService;
import de.adorsys.psd2.consent.service.PisCommonPaymentConfirmationExpirationService;
import de.adorsys.psd2.consent.service.mapper.PisCommonPaymentMapper;
import de.adorsys.psd2.consent.service.mapper.PsuDataMapper;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationType;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import java.beans.ConstructorProperties;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class PisCommonPaymentServiceInternal
implements PisCommonPaymentService {
    private static final Logger log = LoggerFactory.getLogger(PisCommonPaymentServiceInternal.class);
    private final PisCommonPaymentMapper pisCommonPaymentMapper;
    private final PsuDataMapper psuDataMapper;
    private final PisPaymentDataRepository pisPaymentDataRepository;
    private final PisCommonPaymentDataRepository pisCommonPaymentDataRepository;
    private final TppInfoRepository tppInfoRepository;
    private final PisCommonPaymentConfirmationExpirationService pisCommonPaymentConfirmationExpirationService;
    private final CorePaymentsConvertService corePaymentsConvertService;
    private final AuthorisationRepository authorisationRepository;

    @Transactional
    public CmsResponse<CreatePisCommonPaymentResponse> createCommonPayment(PisPaymentInfo request) {
        PisCommonPaymentData commonPaymentData = this.pisCommonPaymentMapper.mapToPisCommonPaymentData(request);
        this.tppInfoRepository.findByAuthorisationNumber(request.getTppInfo().getAuthorisationNumber()).ifPresent(commonPaymentData::setTppInfo);
        PisCommonPaymentData saved = (PisCommonPaymentData)this.pisCommonPaymentDataRepository.save(commonPaymentData);
        if (saved.getId() == null) {
            log.info("Payment ID: [{}]. Pis common payment cannot be created, because when saving to DB got null PisCommonPaymentData ID", (Object)request.getPaymentId());
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
        return CmsResponse.builder().payload((Object)new CreatePisCommonPaymentResponse(saved.getPaymentId(), saved.getTppNotificationContentPreferred())).build();
    }

    @Transactional
    public CmsResponse<TransactionStatus> getPisCommonPaymentStatusById(String paymentId) {
        Optional<TransactionStatus> statusOptional = this.pisCommonPaymentDataRepository.findByPaymentId(paymentId).map(this.pisCommonPaymentConfirmationExpirationService::checkAndUpdateOnConfirmationExpiration).map(PisCommonPaymentData::getTransactionStatus);
        if (statusOptional.isPresent()) {
            return CmsResponse.builder().payload((Object)statusOptional.get()).build();
        }
        log.info("Payment ID: [{}]. Get common payment status by ID failed, because payment was not found by the ID", (Object)paymentId);
        return CmsResponse.builder().error(CmsError.LOGICAL_ERROR).build();
    }

    @Transactional
    public CmsResponse<PisCommonPaymentResponse> getCommonPaymentById(String paymentId) {
        Optional<PisCommonPaymentData> paymentOptional = this.pisCommonPaymentDataRepository.findByPaymentId(paymentId);
        if (paymentOptional.isPresent()) {
            List<AuthorisationEntity> authorisations = this.authorisationRepository.findAllByParentExternalIdAndAuthorisationTypeIn(paymentId, EnumSet.of(AuthorisationType.PIS_CREATION, AuthorisationType.PIS_CANCELLATION));
            Optional responseOptional = paymentOptional.map(this.pisCommonPaymentConfirmationExpirationService::checkAndUpdateOnConfirmationExpiration).flatMap(p -> this.pisCommonPaymentMapper.mapToPisCommonPaymentResponse((PisCommonPaymentData)p, authorisations));
            if (responseOptional.isPresent()) {
                PisCommonPaymentResponse pisCommonPaymentResponse = (PisCommonPaymentResponse)responseOptional.get();
                this.transferCorePaymentToCommonPayment(pisCommonPaymentResponse, paymentOptional.get());
                return CmsResponse.builder().payload((Object)pisCommonPaymentResponse).build();
            }
        }
        log.info("Payment ID: [{}]. Get common payment by ID failed, because payment was not found by the ID", (Object)paymentId);
        return CmsResponse.builder().error(CmsError.LOGICAL_ERROR).build();
    }

    void transferCorePaymentToCommonPayment(PisCommonPaymentResponse pisCommonPaymentResponse, PisCommonPaymentData pisCommonPaymentData) {
        if (pisCommonPaymentData.getPayment() != null) {
            return;
        }
        List<PisPayment> pisPayments = pisCommonPaymentData.getPayments().stream().map(this.pisCommonPaymentMapper::mapToPisPayment).collect(Collectors.toList());
        byte[] paymentData = this.corePaymentsConvertService.buildPaymentData(pisPayments, pisCommonPaymentData.getPaymentType());
        if (paymentData != null) {
            pisCommonPaymentData.setPayment(paymentData);
            this.pisCommonPaymentDataRepository.save(pisCommonPaymentData);
            pisCommonPaymentResponse.setPaymentData(paymentData);
        }
    }

    @Transactional
    public CmsResponse<Boolean> updateCommonPaymentStatusById(String paymentId, TransactionStatus status) {
        Optional<Boolean> isUpdatedOptional = this.pisCommonPaymentDataRepository.findByPaymentId(paymentId).map(this.pisCommonPaymentConfirmationExpirationService::checkAndUpdateOnConfirmationExpiration).filter(pm -> !pm.getTransactionStatus().isFinalisedStatus()).map(pmt -> this.setStatusAndSaveCommonPaymentData((PisCommonPaymentData)pmt, status)).map(con -> con.getTransactionStatus() == status);
        if (isUpdatedOptional.isPresent()) {
            return CmsResponse.builder().payload((Object)isUpdatedOptional.get()).build();
        }
        log.info("Payment ID: [{}]. Update common payment by ID failed, because payment was not found by the ID", (Object)paymentId);
        return CmsResponse.builder().payload((Object)false).build();
    }

    @Transactional
    public CmsResponse<CmsResponse.VoidResponse> updateCommonPayment(PisCommonPaymentRequest request, String paymentId) {
        Optional<PisCommonPaymentData> pisCommonPaymentById = this.pisCommonPaymentDataRepository.findByPaymentId(paymentId);
        pisCommonPaymentById.ifPresent(commonPayment -> this.savePaymentData(request));
        return CmsResponse.builder().payload((Object)CmsResponse.voidResponse()).build();
    }

    @Transactional
    public CmsResponse<Boolean> updateMultilevelSca(String paymentId, boolean multilevelScaRequired) {
        Optional<PisCommonPaymentData> pisCommonPaymentDataOptional = this.pisCommonPaymentDataRepository.findByPaymentId(paymentId);
        if (!pisCommonPaymentDataOptional.isPresent()) {
            log.info("Payment ID: [{}]. Update multilevel SCA required status failed, because payment is not found", (Object)paymentId);
            return CmsResponse.builder().payload((Object)false).build();
        }
        PisCommonPaymentData payment = pisCommonPaymentDataOptional.get();
        payment.setMultilevelScaRequired(multilevelScaRequired);
        this.pisCommonPaymentDataRepository.save(payment);
        return CmsResponse.builder().payload((Object)true).build();
    }

    public CmsResponse<List<PsuIdData>> getPsuDataListByPaymentId(String paymentId) {
        Optional<List> psuDataListOptional = this.readPisCommonPaymentDataByPaymentId(paymentId).map(pc -> this.psuDataMapper.mapToPsuIdDataList(pc.getPsuDataList()));
        if (psuDataListOptional.isPresent()) {
            return CmsResponse.builder().payload((Object)psuDataListOptional.get()).build();
        }
        log.info("PaymentId ID: [{}]. Get PSU data list by payment ID failed, because payment is not found", (Object)paymentId);
        return CmsResponse.builder().error(CmsError.LOGICAL_ERROR).build();
    }

    private PisCommonPaymentData setStatusAndSaveCommonPaymentData(PisCommonPaymentData commonPaymentData, TransactionStatus status) {
        commonPaymentData.setTransactionStatus(status);
        return (PisCommonPaymentData)this.pisCommonPaymentDataRepository.save(commonPaymentData);
    }

    private Optional<PisCommonPaymentData> readPisCommonPaymentDataByPaymentId(String paymentId) {
        Optional<PisCommonPaymentData> commonPaymentData = this.pisPaymentDataRepository.findByPaymentId(paymentId).filter(CollectionUtils::isNotEmpty).map(list -> ((PisPaymentData)list.get(0)).getPaymentData());
        if (!commonPaymentData.isPresent()) {
            commonPaymentData = this.pisCommonPaymentDataRepository.findByPaymentId(paymentId);
        }
        return commonPaymentData;
    }

    private void savePaymentData(PisCommonPaymentRequest request) {
        this.pisCommonPaymentDataRepository.save(this.pisCommonPaymentMapper.mapToPisCommonPaymentData(request.getPaymentInfo()));
    }

    @ConstructorProperties(value={"pisCommonPaymentMapper", "psuDataMapper", "pisPaymentDataRepository", "pisCommonPaymentDataRepository", "tppInfoRepository", "pisCommonPaymentConfirmationExpirationService", "corePaymentsConvertService", "authorisationRepository"})
    public PisCommonPaymentServiceInternal(PisCommonPaymentMapper pisCommonPaymentMapper, PsuDataMapper psuDataMapper, PisPaymentDataRepository pisPaymentDataRepository, PisCommonPaymentDataRepository pisCommonPaymentDataRepository, TppInfoRepository tppInfoRepository, PisCommonPaymentConfirmationExpirationService pisCommonPaymentConfirmationExpirationService, CorePaymentsConvertService corePaymentsConvertService, AuthorisationRepository authorisationRepository) {
        this.pisCommonPaymentMapper = pisCommonPaymentMapper;
        this.psuDataMapper = psuDataMapper;
        this.pisPaymentDataRepository = pisPaymentDataRepository;
        this.pisCommonPaymentDataRepository = pisCommonPaymentDataRepository;
        this.tppInfoRepository = tppInfoRepository;
        this.pisCommonPaymentConfirmationExpirationService = pisCommonPaymentConfirmationExpirationService;
        this.corePaymentsConvertService = corePaymentsConvertService;
        this.authorisationRepository = authorisationRepository;
    }
}

