/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.mapper;

import de.adorsys.psd2.consent.domain.AdditionalPsuData;
import de.adorsys.psd2.consent.domain.PsuData;
import de.adorsys.psd2.xs2a.core.psu.AdditionalPsuIdData;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class PsuDataMapper {
    public List<PsuData> mapToPsuDataList(List<PsuIdData> psuIdDataList) {
        return psuIdDataList.stream().map(this::mapToPsuData).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<PsuIdData> mapToPsuIdDataList(List<PsuData> psuIdDataList) {
        return psuIdDataList.stream().map(this::mapToPsuIdData).collect(Collectors.toList());
    }

    public PsuData mapToPsuData(PsuIdData psuIdData) {
        return Optional.ofNullable(psuIdData).filter(PsuIdData::isNotEmpty).map(psu -> new PsuData(psu.getPsuId(), psu.getPsuIdType(), psu.getPsuCorporateId(), psu.getPsuCorporateIdType(), psu.getPsuIpAddress(), this.mapToAdditionalPsuData(psu.getAdditionalPsuIdData()))).orElse(null);
    }

    public PsuIdData mapToPsuIdData(PsuData psuData) {
        return Optional.ofNullable(psuData).filter(PsuData::isNotEmpty).map(psu -> new PsuIdData(psu.getPsuId(), psu.getPsuIdType(), psu.getPsuCorporateId(), psu.getPsuCorporateIdType(), psu.getPsuIpAddress(), this.mapToAdditionalPsuIdData(psu.getAdditionalPsuData()))).orElse(null);
    }

    private AdditionalPsuData mapToAdditionalPsuData(AdditionalPsuIdData additionalPsuIdData) {
        return Optional.ofNullable(additionalPsuIdData).filter(AdditionalPsuIdData::isNotEmpty).map(dta -> new AdditionalPsuData(dta.getPsuIpPort(), dta.getPsuUserAgent(), dta.getPsuGeoLocation(), dta.getPsuAccept(), dta.getPsuAcceptCharset(), dta.getPsuAcceptEncoding(), dta.getPsuAcceptLanguage(), dta.getPsuHttpMethod(), Optional.ofNullable(dta.getPsuDeviceId()).map(UUID::toString).orElse(null))).orElse(null);
    }

    private AdditionalPsuIdData mapToAdditionalPsuIdData(AdditionalPsuData additionalPsuData) {
        return Optional.ofNullable(additionalPsuData).map(dta -> new AdditionalPsuIdData(dta.getPsuIpPort(), dta.getPsuUserAgent(), dta.getPsuGeoLocation(), dta.getPsuAccept(), dta.getPsuAcceptCharset(), dta.getPsuAcceptEncoding(), dta.getPsuAcceptLanguage(), dta.getPsuHttpMethod(), (UUID)Optional.ofNullable(dta.getPsuDeviceId()).map(UUID::fromString).orElse(null))).orElse(null);
    }
}

