/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.mapper;

import de.adorsys.psd2.consent.api.CmsAddress;
import de.adorsys.psd2.consent.api.pis.CmsRemittance;
import de.adorsys.psd2.consent.api.pis.PisPayment;
import de.adorsys.psd2.consent.api.pis.proto.PisCommonPaymentResponse;
import de.adorsys.psd2.consent.api.pis.proto.PisPaymentInfo;
import de.adorsys.psd2.consent.domain.AuthorisationEntity;
import de.adorsys.psd2.consent.domain.AuthorisationTemplateEntity;
import de.adorsys.psd2.consent.domain.payment.PisAddress;
import de.adorsys.psd2.consent.domain.payment.PisCommonPaymentData;
import de.adorsys.psd2.consent.domain.payment.PisPaymentData;
import de.adorsys.psd2.consent.domain.payment.PisRemittance;
import de.adorsys.psd2.consent.service.mapper.AccountReferenceMapper;
import de.adorsys.psd2.consent.service.mapper.AuthorisationMapper;
import de.adorsys.psd2.consent.service.mapper.PsuDataMapper;
import de.adorsys.psd2.consent.service.mapper.TppInfoMapper;
import de.adorsys.psd2.xs2a.core.tpp.TppRedirectUri;
import java.beans.ConstructorProperties;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class PisCommonPaymentMapper {
    private final TppInfoMapper tppInfoMapper;
    private final PsuDataMapper psuDataMapper;
    private final AccountReferenceMapper accountReferenceMapper;
    private final AuthorisationMapper authorisationMapper;

    public PisCommonPaymentData mapToPisCommonPaymentData(PisPaymentInfo paymentInfo) {
        PisCommonPaymentData commonPaymentData = new PisCommonPaymentData();
        commonPaymentData.setPaymentId(paymentInfo.getPaymentId());
        commonPaymentData.setPaymentType(paymentInfo.getPaymentType());
        commonPaymentData.setPaymentProduct(paymentInfo.getPaymentProduct());
        commonPaymentData.setTransactionStatus(paymentInfo.getTransactionStatus());
        commonPaymentData.setPayment(paymentInfo.getPaymentData());
        commonPaymentData.setTppInfo(this.tppInfoMapper.mapToTppInfoEntity(paymentInfo.getTppInfo()));
        commonPaymentData.setPsuDataList(this.psuDataMapper.mapToPsuDataList(paymentInfo.getPsuDataList()));
        commonPaymentData.setMultilevelScaRequired(paymentInfo.isMultilevelScaRequired());
        commonPaymentData.setAspspAccountId(paymentInfo.getAspspAccountId());
        AuthorisationTemplateEntity authorisationTemplate = new AuthorisationTemplateEntity();
        TppRedirectUri tppRedirectUri = paymentInfo.getTppRedirectUri();
        if (tppRedirectUri != null) {
            authorisationTemplate.setRedirectUri(tppRedirectUri.getUri());
            authorisationTemplate.setNokRedirectUri(tppRedirectUri.getNokUri());
        }
        commonPaymentData.setAuthorisationTemplate(authorisationTemplate);
        commonPaymentData.setInternalRequestId(paymentInfo.getInternalRequestId());
        Optional.ofNullable(paymentInfo.getCreationTimestamp()).ifPresent(commonPaymentData::setCreationTimestamp);
        commonPaymentData.setTppNotificationUri(paymentInfo.getTppNotificationUri());
        commonPaymentData.setTppNotificationContentPreferred(paymentInfo.getNotificationSupportedModes());
        commonPaymentData.setContentType(paymentInfo.getContentType());
        return commonPaymentData;
    }

    public Optional<PisCommonPaymentResponse> mapToPisCommonPaymentResponse(PisCommonPaymentData commonPaymentData, List<AuthorisationEntity> authorisations) {
        return Optional.ofNullable(commonPaymentData).map(cmd -> {
            PisCommonPaymentResponse response = new PisCommonPaymentResponse();
            response.setPayments(this.mapToPisPaymentList(cmd.getPayments(), cmd.getCreationTimestamp()));
            response.setExternalId(cmd.getPaymentId());
            response.setPaymentType(cmd.getPaymentType());
            response.setPaymentProduct(cmd.getPaymentProduct());
            response.setTppInfo(this.tppInfoMapper.mapToTppInfo(cmd.getTppInfo()));
            response.setPsuData(this.psuDataMapper.mapToPsuIdDataList(cmd.getPsuDataList()));
            response.setPaymentData(cmd.getPayment());
            response.setTransactionStatus(cmd.getTransactionStatus());
            response.setStatusChangeTimestamp(cmd.getStatusChangeTimestamp());
            response.setMultilevelScaRequired(cmd.isMultilevelScaRequired());
            response.setAuthorisations(this.authorisationMapper.mapToAuthorisations(authorisations));
            response.setCreationTimestamp(cmd.getCreationTimestamp());
            response.setContentType(cmd.getContentType());
            return response;
        });
    }

    private List<PisPayment> mapToPisPaymentList(List<PisPaymentData> payments, OffsetDateTime offsetDateTime) {
        List<PisPayment> pisPayments = payments.stream().map(this::mapToPisPayment).collect(Collectors.toList());
        pisPayments.forEach(pisPayment -> pisPayment.setCreationTimestamp(offsetDateTime));
        return pisPayments;
    }

    public PisPayment mapToPisPayment(PisPaymentData payment) {
        return Optional.ofNullable(payment).map(pm -> {
            PisPayment pisPayment = new PisPayment();
            pisPayment.setPaymentId(pm.getPaymentId());
            pisPayment.setEndToEndIdentification(pm.getEndToEndIdentification());
            pisPayment.setInstructionIdentification(pm.getInstructionIdentification());
            pisPayment.setDebtorAccount(this.accountReferenceMapper.mapToCmsAccountReference(pm.getDebtorAccount()));
            pisPayment.setUltimateDebtor(pm.getUltimateDebtor());
            pisPayment.setCurrency(pm.getCurrency());
            pisPayment.setAmount(pm.getAmount());
            pisPayment.setCreditorAccount(this.accountReferenceMapper.mapToCmsAccountReference(pm.getCreditorAccount()));
            pisPayment.setCreditorAgent(pm.getCreditorAgent());
            pisPayment.setCreditorName(pm.getCreditorName());
            pisPayment.setCreditorAddress(this.mapToCmsAddress(pm.getCreditorAddress()));
            pisPayment.setRemittanceInformationUnstructured(pm.getRemittanceInformationUnstructured());
            pisPayment.setRemittanceInformationStructured(this.mapToCmsRemittance(pm.getRemittanceInformationStructured()));
            pisPayment.setRequestedExecutionDate(pm.getRequestedExecutionDate());
            pisPayment.setRequestedExecutionTime(pm.getRequestedExecutionTime());
            pisPayment.setUltimateCreditor(pm.getUltimateCreditor());
            pisPayment.setPurposeCode(pm.getPurposeCode());
            pisPayment.setStartDate(pm.getStartDate());
            pisPayment.setEndDate(pm.getEndDate());
            pisPayment.setExecutionRule(pm.getExecutionRule());
            pisPayment.setFrequency(pm.getFrequency());
            pisPayment.setDayOfExecution(pm.getDayOfExecution());
            pisPayment.setPsuDataList(this.psuDataMapper.mapToPsuIdDataList(pm.getPaymentData().getPsuDataList()));
            pisPayment.setBatchBookingPreferred(pm.getBatchBookingPreferred());
            return pisPayment;
        }).orElse(null);
    }

    private CmsRemittance mapToCmsRemittance(PisRemittance pisRemittance) {
        return Optional.ofNullable(pisRemittance).map(r -> {
            CmsRemittance remittance = new CmsRemittance();
            remittance.setReference(r.getReference());
            remittance.setReferenceIssuer(r.getReferenceIssuer());
            remittance.setReferenceType(r.getReferenceType());
            return remittance;
        }).orElse(null);
    }

    CmsAddress mapToCmsAddress(PisAddress pisAddress) {
        return Optional.ofNullable(pisAddress).map(adr -> {
            CmsAddress cmsAddress = new CmsAddress();
            cmsAddress.setStreet(adr.getStreet());
            cmsAddress.setBuildingNumber(adr.getBuildingNumber());
            cmsAddress.setCity(adr.getCity());
            cmsAddress.setPostalCode(adr.getPostalCode());
            cmsAddress.setCountry(adr.getCountry());
            return cmsAddress;
        }).orElse(null);
    }

    @ConstructorProperties(value={"tppInfoMapper", "psuDataMapper", "accountReferenceMapper", "authorisationMapper"})
    public PisCommonPaymentMapper(TppInfoMapper tppInfoMapper, PsuDataMapper psuDataMapper, AccountReferenceMapper accountReferenceMapper, AuthorisationMapper authorisationMapper) {
        this.tppInfoMapper = tppInfoMapper;
        this.psuDataMapper = psuDataMapper;
        this.accountReferenceMapper = accountReferenceMapper;
        this.authorisationMapper = authorisationMapper;
    }
}

