/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.mapper;

import de.adorsys.psd2.consent.api.authorisation.CreateAuthorisationRequest;
import de.adorsys.psd2.consent.domain.Authorisable;
import de.adorsys.psd2.consent.domain.AuthorisationEntity;
import de.adorsys.psd2.consent.domain.AuthorisationTemplateEntity;
import de.adorsys.psd2.consent.domain.PsuData;
import de.adorsys.psd2.consent.service.mapper.PsuDataMapper;
import de.adorsys.psd2.xs2a.core.authorisation.Authorisation;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationType;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.core.tpp.TppRedirectUri;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;

@Mapper(componentModel="spring", uses={PsuDataMapper.class})
public interface AuthorisationMapper {
    @Mappings(value={@Mapping(target="psuIdData", source="psuData"), @Mapping(target="password", ignore=true), @Mapping(target="authorisationId", source="externalId"), @Mapping(target="parentId", source="parentExternalId"), @Mapping(target="chosenScaApproach", source="scaApproach")})
    public Authorisation mapToAuthorisation(AuthorisationEntity var1);

    public List<Authorisation> mapToAuthorisations(List<AuthorisationEntity> var1);

    default public AuthorisationEntity prepareAuthorisationEntity(Authorisable authorisationParent, CreateAuthorisationRequest request, Optional<PsuData> psuDataOptional, AuthorisationType authorisationType, long redirectUrlExpirationTimeMs, long authorisationExpirationTimeMs) {
        AuthorisationEntity entity = new AuthorisationEntity();
        entity.setAuthorisationType(authorisationType);
        ScaStatus scaStatus = ScaStatus.RECEIVED;
        if (psuDataOptional.isPresent()) {
            entity.setPsuData(psuDataOptional.get());
            scaStatus = ScaStatus.PSUIDENTIFIED;
        }
        entity.setExternalId(UUID.randomUUID().toString());
        entity.setParentExternalId(authorisationParent.getExternalId());
        entity.setScaStatus(scaStatus);
        entity.setRedirectUrlExpirationTimestamp(OffsetDateTime.now().plus(redirectUrlExpirationTimeMs, ChronoUnit.MILLIS));
        entity.setAuthorisationExpirationTimestamp(OffsetDateTime.now().plus(authorisationExpirationTimeMs, ChronoUnit.MILLIS));
        entity.setScaApproach(request.getScaApproach());
        TppRedirectUri redirectURIs = request.getTppRedirectURIs();
        AuthorisationTemplateEntity authorisationTemplate = authorisationParent.getAuthorisationTemplate();
        entity.setTppOkRedirectUri((String)StringUtils.defaultIfBlank((CharSequence)redirectURIs.getUri(), (CharSequence)authorisationTemplate.getRedirectUri()));
        entity.setTppNokRedirectUri((String)StringUtils.defaultIfBlank((CharSequence)redirectURIs.getNokUri(), (CharSequence)authorisationTemplate.getNokRedirectUri()));
        return entity;
    }
}

