/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.api.CmsError;
import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.service.UpdatePaymentAfterSpiService;
import de.adorsys.psd2.consent.api.service.UpdatePaymentAfterSpiServiceEncrypted;
import de.adorsys.psd2.consent.service.security.SecurityDataService;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.tpp.TppRedirectUri;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class UpdatePaymentAfterSpiServiceInternalEncrypted
implements UpdatePaymentAfterSpiServiceEncrypted {
    private static final Logger log = LoggerFactory.getLogger(UpdatePaymentAfterSpiServiceInternalEncrypted.class);
    private final SecurityDataService securityDataService;
    private final UpdatePaymentAfterSpiService updatePaymentStatusAfterSpiService;

    @Transactional
    public CmsResponse<Boolean> updatePaymentStatus(@NotNull String encryptedPaymentId, @NotNull TransactionStatus status) {
        Optional<String> decryptIdOptional = this.securityDataService.decryptId(encryptedPaymentId);
        if (!decryptIdOptional.isPresent()) {
            log.info("Encrypted Payment ID [{}]. Update payment status by id failed, couldn't decrypt payment id", (Object)encryptedPaymentId);
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
        return this.updatePaymentStatusAfterSpiService.updatePaymentStatus(decryptIdOptional.get(), status);
    }

    @Transactional
    public CmsResponse<Boolean> updatePaymentCancellationTppRedirectUri(@NotNull String encryptedPaymentId, @NotNull TppRedirectUri tppRedirectUri) {
        Optional<String> decryptIdOptional = this.securityDataService.decryptId(encryptedPaymentId);
        if (!decryptIdOptional.isPresent()) {
            log.info("Encrypted Payment ID [{}]. Update cancellation payment tpp redirect URIs by id failed, couldn't decrypt payment id", (Object)encryptedPaymentId);
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
        return this.updatePaymentStatusAfterSpiService.updatePaymentCancellationTppRedirectUri(decryptIdOptional.get(), tppRedirectUri);
    }

    @Transactional
    public CmsResponse<Boolean> updatePaymentCancellationInternalRequestId(@NotNull String encryptedPaymentId, @NotNull String internalRequestId) {
        Optional<String> decryptIdOptional = this.securityDataService.decryptId(encryptedPaymentId);
        if (!decryptIdOptional.isPresent()) {
            log.info("Encrypted Payment ID [{}]. Update cancellation payment internal request ID failed, couldn't decrypt payment id", (Object)encryptedPaymentId);
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
        return this.updatePaymentStatusAfterSpiService.updatePaymentCancellationInternalRequestId(decryptIdOptional.get(), internalRequestId);
    }

    @ConstructorProperties(value={"securityDataService", "updatePaymentStatusAfterSpiService"})
    public UpdatePaymentAfterSpiServiceInternalEncrypted(SecurityDataService securityDataService, UpdatePaymentAfterSpiService updatePaymentStatusAfterSpiService) {
        this.securityDataService = securityDataService;
        this.updatePaymentStatusAfterSpiService = updatePaymentStatusAfterSpiService;
    }
}

