/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.aspsp.profile.service.AspspProfileService;
import de.adorsys.psd2.consent.api.ActionStatus;
import de.adorsys.psd2.consent.api.CmsError;
import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.WrongChecksumException;
import de.adorsys.psd2.consent.api.ais.AccountAdditionalInformationAccess;
import de.adorsys.psd2.consent.api.ais.AdditionalAccountInformationType;
import de.adorsys.psd2.consent.api.ais.AisAccountAccessInfo;
import de.adorsys.psd2.consent.api.ais.AisAccountConsent;
import de.adorsys.psd2.consent.api.ais.AisConsentActionRequest;
import de.adorsys.psd2.consent.api.ais.CreateAisConsentRequest;
import de.adorsys.psd2.consent.api.ais.CreateAisConsentResponse;
import de.adorsys.psd2.consent.api.service.AisConsentService;
import de.adorsys.psd2.consent.domain.AuthorisationEntity;
import de.adorsys.psd2.consent.domain.AuthorisationTemplateEntity;
import de.adorsys.psd2.consent.domain.PsuData;
import de.adorsys.psd2.consent.domain.TppInfoEntity;
import de.adorsys.psd2.consent.domain.account.AisConsent;
import de.adorsys.psd2.consent.domain.account.AisConsentAction;
import de.adorsys.psd2.consent.domain.account.AspspAccountAccess;
import de.adorsys.psd2.consent.domain.account.AspspAccountAccessHolder;
import de.adorsys.psd2.consent.domain.account.TppAccountAccessHolder;
import de.adorsys.psd2.consent.repository.AisConsentActionRepository;
import de.adorsys.psd2.consent.repository.AisConsentJpaRepository;
import de.adorsys.psd2.consent.repository.AisConsentVerifyingRepository;
import de.adorsys.psd2.consent.repository.AuthorisationRepository;
import de.adorsys.psd2.consent.repository.TppInfoRepository;
import de.adorsys.psd2.consent.service.AisConsentConfirmationExpirationService;
import de.adorsys.psd2.consent.service.AisConsentRequestTypeService;
import de.adorsys.psd2.consent.service.AisConsentUsageService;
import de.adorsys.psd2.consent.service.OneOffConsentExpirationService;
import de.adorsys.psd2.consent.service.mapper.AisConsentMapper;
import de.adorsys.psd2.consent.service.mapper.PsuDataMapper;
import de.adorsys.psd2.consent.service.mapper.TppInfoMapper;
import de.adorsys.psd2.consent.service.psu.CmsPsuService;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationType;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.tpp.TppRedirectUri;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class AisConsentServiceInternal
implements AisConsentService {
    private static final Logger log = LoggerFactory.getLogger(AisConsentServiceInternal.class);
    private final AuthorisationRepository authorisationRepository;
    private final AisConsentJpaRepository aisConsentJpaRepository;
    private final AisConsentVerifyingRepository aisConsentRepository;
    private final AisConsentActionRepository aisConsentActionRepository;
    private final TppInfoRepository tppInfoRepository;
    private final AisConsentMapper consentMapper;
    private final PsuDataMapper psuDataMapper;
    private final AspspProfileService aspspProfileService;
    private final AisConsentConfirmationExpirationService aisConsentConfirmationExpirationService;
    private final TppInfoMapper tppInfoMapper;
    private final CmsPsuService cmsPsuService;
    private final AisConsentUsageService aisConsentUsageService;
    private final AisConsentRequestTypeService aisConsentRequestTypeService;
    private final OneOffConsentExpirationService oneOffConsentExpirationService;

    @Transactional(rollbackFor={WrongChecksumException.class})
    public CmsResponse<CreateAisConsentResponse> createConsent(CreateAisConsentRequest request) throws WrongChecksumException {
        if (request.getAllowedFrequencyPerDay() == null) {
            log.info("TPP ID: [{}]. Consent cannot be created, because request contains no allowed frequency per day", (Object)request.getTppInfo().getAuthorisationNumber());
            return CmsResponse.builder().error(CmsError.LOGICAL_ERROR).build();
        }
        AisConsent consent = this.createConsentFromRequest(request);
        this.tppInfoRepository.findByAuthorisationNumber(request.getTppInfo().getAuthorisationNumber()).ifPresent(consent::setTppInfo);
        AisConsent savedConsent = this.aisConsentRepository.verifyAndSave(consent);
        if (savedConsent.getId() != null) {
            return CmsResponse.builder().payload((Object)new CreateAisConsentResponse(savedConsent.getExternalId(), this.consentMapper.mapToAisAccountConsent(savedConsent, Collections.emptyList()), consent.getTppNotificationContentPreferred())).build();
        }
        log.info("TPP ID: [{}], External Consent ID: [{}]. AIS consent cannot be created, because when saving to DB got null ID", (Object)request.getTppInfo().getAuthorisationNumber(), (Object)consent.getExternalId());
        return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
    }

    @Transactional
    public CmsResponse<ConsentStatus> getConsentStatusById(String consentId) {
        Optional<ConsentStatus> consentStatusOptional = this.aisConsentJpaRepository.findByExternalId(consentId).map(this.aisConsentConfirmationExpirationService::checkAndUpdateOnConfirmationExpiration).map(this::checkAndUpdateOnExpiration).map(AisConsent::getConsentStatus);
        if (consentStatusOptional.isPresent()) {
            return CmsResponse.builder().payload((Object)consentStatusOptional.get()).build();
        }
        log.info("Consent ID: [{}]. Get consent status failed, because consent not found", (Object)consentId);
        return CmsResponse.builder().error(CmsError.LOGICAL_ERROR).build();
    }

    @Transactional(rollbackFor={WrongChecksumException.class})
    public CmsResponse<Boolean> updateConsentStatusById(String consentId, ConsentStatus status) throws WrongChecksumException {
        Optional<AisConsent> consentOptional = this.getActualAisConsent(consentId);
        if (consentOptional.isPresent()) {
            AisConsent consent = consentOptional.get();
            boolean result = this.setStatusAndSaveConsent(consent, status);
            return CmsResponse.builder().payload((Object)result).build();
        }
        log.info("Consent ID [{}]. Update consent status by ID failed, because consent not found", (Object)consentId);
        return CmsResponse.builder().error(CmsError.LOGICAL_ERROR).build();
    }

    @Transactional
    public CmsResponse<AisAccountConsent> getAisAccountConsentById(String consentId) {
        Optional<AisConsent> consentOptional = this.aisConsentJpaRepository.findByExternalId(consentId).map(this.aisConsentConfirmationExpirationService::checkAndUpdateOnConfirmationExpiration).map(this::checkAndUpdateOnExpiration);
        if (!consentOptional.isPresent()) {
            log.info("Consent ID [{}]. Get consent by ID failed, because consent not found", (Object)consentId);
            return CmsResponse.builder().error(CmsError.LOGICAL_ERROR).build();
        }
        AisConsent consent = consentOptional.get();
        List<AuthorisationEntity> authorisations = this.authorisationRepository.findAllByParentExternalIdAndAuthorisationType(consent.getExternalId(), AuthorisationType.AIS);
        AisAccountConsent aisAccountConsent = this.consentMapper.mapToAisAccountConsent(consent, authorisations);
        return CmsResponse.builder().payload((Object)aisAccountConsent).build();
    }

    @Transactional
    public CmsResponse<Boolean> findAndTerminateOldConsentsByNewConsentId(String newConsentId) {
        TppInfoEntity tppInfo;
        AisConsent newConsent = this.aisConsentJpaRepository.findByExternalId(newConsentId).orElseThrow(() -> {
            log.info("Consent ID: [{}]. Cannot find consent by ID", (Object)newConsentId);
            return new IllegalArgumentException("Wrong consent ID: " + newConsentId);
        });
        if (newConsent.isOneAccessType()) {
            log.info("Consent ID: [{}]. Cannot find old consents, because consent is OneAccessType", (Object)newConsentId);
            return CmsResponse.builder().payload((Object)false).build();
        }
        if (newConsent.isWrongConsentData()) {
            log.info("Consent ID: [{}]. Find old consents failed, because consent PSU data list is empty or TPP Info is null", (Object)newConsentId);
            throw new IllegalArgumentException("Wrong consent data");
        }
        List<PsuData> psuDataList = newConsent.getPsuDataList();
        Set<String> psuIds = psuDataList.stream().filter(Objects::nonNull).map(PsuData::getPsuId).collect(Collectors.toSet());
        List<AisConsent> oldConsents = this.aisConsentJpaRepository.findOldConsentsByNewConsentParams(psuIds, (tppInfo = newConsent.getTppInfo()).getAuthorisationNumber(), newConsent.getInstanceId(), newConsent.getExternalId(), EnumSet.of(ConsentStatus.RECEIVED, ConsentStatus.PARTIALLY_AUTHORISED, ConsentStatus.VALID));
        List<AisConsent> oldConsentsWithExactPsuDataLists = oldConsents.stream().distinct().filter(c -> this.cmsPsuService.isPsuDataListEqual(c.getPsuDataList(), psuDataList)).collect(Collectors.toList());
        if (oldConsentsWithExactPsuDataLists.isEmpty()) {
            log.info("Consent ID: [{}]. Cannot find old consents, because consent hasn't exact PSU data lists as old consents", (Object)newConsentId);
            return CmsResponse.builder().payload((Object)false).build();
        }
        oldConsentsWithExactPsuDataLists.forEach(this::updateStatus);
        this.aisConsentJpaRepository.saveAll(oldConsentsWithExactPsuDataLists);
        return CmsResponse.builder().payload((Object)true).build();
    }

    @Transactional(rollbackFor={WrongChecksumException.class})
    public CmsResponse<CmsResponse.VoidResponse> checkConsentAndSaveActionLog(AisConsentActionRequest request) throws WrongChecksumException {
        Optional<AisConsent> consentOpt = this.getActualAisConsent(request.getConsentId());
        if (consentOpt.isPresent()) {
            AisConsent consent = consentOpt.get();
            this.aisConsentConfirmationExpirationService.checkAndUpdateOnConfirmationExpiration(consent);
            this.checkAndUpdateOnExpiration(consent);
            this.updateAisConsentUsage(consent, request);
            this.logConsentAction(consent.getExternalId(), this.resolveConsentActionStatus(request, consent), request.getTppId());
        }
        return CmsResponse.builder().payload((Object)CmsResponse.voidResponse()).build();
    }

    @Transactional(rollbackFor={WrongChecksumException.class})
    public CmsResponse<String> updateAspspAccountAccess(String consentId, AisAccountAccessInfo request) throws WrongChecksumException {
        Optional<AisConsent> consentOptional = this.aisConsentRepository.getActualAisConsent(consentId);
        if (!consentOptional.isPresent()) {
            log.info("Consent ID [{}]. Update aspsp account access failed, because consent not found", (Object)consentId);
            return CmsResponse.builder().error(CmsError.LOGICAL_ERROR).build();
        }
        AisConsent consent = consentOptional.get();
        consent.addAspspAccountAccess(new AspspAccountAccessHolder(request).getAccountAccesses());
        String externalId = this.aisConsentRepository.verifyAndSave(consent).getExternalId();
        return CmsResponse.builder().payload((Object)externalId).build();
    }

    @Transactional(rollbackFor={WrongChecksumException.class})
    public CmsResponse<AisAccountConsent> updateAspspAccountAccessWithResponse(String consentId, AisAccountAccessInfo request) throws WrongChecksumException {
        Optional<AisConsent> consentOptional = this.aisConsentRepository.getActualAisConsent(consentId);
        if (!consentOptional.isPresent()) {
            log.info("Consent ID [{}]. Update aspsp account access with response failed, because consent not found", (Object)consentId);
            return CmsResponse.builder().error(CmsError.LOGICAL_ERROR).build();
        }
        AisConsent consent = consentOptional.get();
        Set<AspspAccountAccess> aspspAccesses = new AspspAccountAccessHolder(request).getAccountAccesses();
        List<AspspAccountAccess> cmsAccesses = consent.getAspspAccountAccesses();
        consent.setAspspAccountAccesses(this.getUpdatedAccesses(cmsAccesses, aspspAccesses));
        AisConsent aisConsent = this.aisConsentRepository.verifyAndUpdate(consent);
        List<AuthorisationEntity> authorisations = this.authorisationRepository.findAllByParentExternalIdAndAuthorisationType(aisConsent.getExternalId(), AuthorisationType.AIS);
        return CmsResponse.builder().payload((Object)this.consentMapper.mapToAisAccountConsent(aisConsent, authorisations)).build();
    }

    private AspspAccountAccess enrichAccount(Set<AspspAccountAccess> accounts, AspspAccountAccess element) {
        return accounts.stream().filter(a -> a.getAccountIdentifier().equals(element.getAccountIdentifier()) && a.getAccountReferenceType() == element.getAccountReferenceType() && a.getCurrency() == element.getCurrency() && a.getTypeAccess() == element.getTypeAccess()).findFirst().orElse(element);
    }

    private List<AspspAccountAccess> getUpdatedAccesses(List<AspspAccountAccess> cmsAccesses, Set<AspspAccountAccess> requestAccesses) {
        if (CollectionUtils.isEmpty(cmsAccesses)) {
            return new ArrayList<AspspAccountAccess>(requestAccesses);
        }
        HashSet<AspspAccountAccess> updatedCmsAccesses = new HashSet<AspspAccountAccess>();
        for (AspspAccountAccess access : cmsAccesses) {
            updatedCmsAccesses.add(this.enrichAccount(requestAccesses, access));
        }
        return new ArrayList<AspspAccountAccess>(updatedCmsAccesses);
    }

    public CmsResponse<List<PsuIdData>> getPsuDataByConsentId(String consentId) {
        Optional<List> psuIdDataOptional = this.getActualAisConsent(consentId).map(ac -> this.psuDataMapper.mapToPsuIdDataList(ac.getPsuDataList()));
        if (psuIdDataOptional.isPresent()) {
            return CmsResponse.builder().payload((Object)psuIdDataOptional.get()).build();
        }
        log.info("Consent ID [{}]. Get psu data by consent id failed, because consent not found", (Object)consentId);
        return CmsResponse.builder().error(CmsError.LOGICAL_ERROR).build();
    }

    @Transactional(rollbackFor={WrongChecksumException.class})
    public CmsResponse<Boolean> updateMultilevelScaRequired(String consentId, boolean multilevelScaRequired) throws WrongChecksumException {
        Optional<AisConsent> aisConsentOptional = this.aisConsentJpaRepository.findByExternalId(consentId);
        if (!aisConsentOptional.isPresent()) {
            log.info("Consent ID: [{}]. Get update multilevel SCA required status failed, because consent authorisation is not found", (Object)consentId);
            return CmsResponse.builder().payload((Object)false).build();
        }
        AisConsent consent = aisConsentOptional.get();
        consent.setMultilevelScaRequired(multilevelScaRequired);
        this.aisConsentRepository.verifyAndSave(consent);
        return CmsResponse.builder().payload((Object)true).build();
    }

    private AisConsent checkAndUpdateOnExpiration(AisConsent consent) {
        if (consent != null && consent.shouldConsentBeExpired()) {
            return this.aisConsentConfirmationExpirationService.expireConsent(consent);
        }
        return consent;
    }

    private AisConsent createConsentFromRequest(CreateAisConsentRequest request) {
        AisConsent consent = new AisConsent();
        consent.setExternalId(UUID.randomUUID().toString());
        consent.setConsentStatus(ConsentStatus.RECEIVED);
        consent.setAllowedFrequencyPerDay(request.getAllowedFrequencyPerDay());
        consent.setTppFrequencyPerDay(request.getRequestedFrequencyPerDay());
        consent.setRequestDateTime(LocalDateTime.now());
        consent.setValidUntil(this.adjustExpireDate(request.getValidUntil()));
        consent.setPsuDataList(this.psuDataMapper.mapToPsuDataList(Collections.singletonList(request.getPsuData())));
        consent.setTppInfo(this.tppInfoMapper.mapToTppInfoEntity(request.getTppInfo()));
        AuthorisationTemplateEntity authorisationTemplate = new AuthorisationTemplateEntity();
        TppRedirectUri tppRedirectUri = request.getTppRedirectUri();
        if (tppRedirectUri != null) {
            authorisationTemplate.setRedirectUri(tppRedirectUri.getUri());
            authorisationTemplate.setNokRedirectUri(tppRedirectUri.getNokUri());
        }
        consent.setAuthorisationTemplate(authorisationTemplate);
        consent.addAccountAccess(new TppAccountAccessHolder(request.getAccess()).getAccountAccesses());
        consent.setRecurringIndicator(request.isRecurringIndicator());
        consent.setTppRedirectPreferred(request.isTppRedirectPreferred());
        consent.setCombinedServiceIndicator(request.isCombinedServiceIndicator());
        consent.setAisConsentRequestType(this.aisConsentRequestTypeService.getRequestTypeFromAccess(request.getAccess()));
        consent.setAvailableAccounts(request.getAccess().getAvailableAccounts());
        consent.setAllPsd2(request.getAccess().getAllPsd2());
        consent.setAvailableAccountsWithBalance(request.getAccess().getAvailableAccountsWithBalance());
        consent.setLastActionDate(LocalDate.now());
        this.setAdditionalInformationTypes(consent, request.getAccess().getAccountAdditionalInformationAccess());
        consent.setInternalRequestId(request.getInternalRequestId());
        consent.setTppNotificationUri(request.getTppNotificationUri());
        consent.setTppNotificationContentPreferred(request.getNotificationSupportedModes());
        return consent;
    }

    private void setAdditionalInformationTypes(AisConsent consent, AccountAdditionalInformationAccess info) {
        AdditionalAccountInformationType ownerNameType = info == null ? AdditionalAccountInformationType.NONE : AdditionalAccountInformationType.findTypeByList((List)info.getOwnerName());
        consent.setOwnerNameType(ownerNameType);
    }

    private LocalDate adjustExpireDate(LocalDate validUntil) {
        int lifetime = this.aspspProfileService.getAspspSettings().getAis().getConsentTypes().getMaxConsentValidityDays();
        if (lifetime <= 0) {
            return validUntil;
        }
        LocalDate lifeTimeDate = LocalDate.now().plusDays((long)lifetime - 1L);
        return lifeTimeDate.isBefore(validUntil) ? lifeTimeDate : validUntil;
    }

    private ActionStatus resolveConsentActionStatus(AisConsentActionRequest request, AisConsent consent) {
        if (consent == null) {
            log.info("Consent ID: [{}]. Consent action status resolver received null consent", (Object)request.getConsentId());
            return ActionStatus.BAD_PAYLOAD;
        }
        return request.getActionStatus();
    }

    private void logConsentAction(String requestedConsentId, ActionStatus actionStatus, String tppId) {
        AisConsentAction action = new AisConsentAction();
        action.setActionStatus(actionStatus);
        action.setRequestedConsentId(requestedConsentId);
        action.setTppId(tppId);
        action.setRequestDate(LocalDate.now());
        this.aisConsentActionRepository.save(action);
    }

    private Optional<AisConsent> getActualAisConsent(String consentId) {
        return this.aisConsentJpaRepository.findByExternalId(consentId).filter(c -> !c.getConsentStatus().isFinalisedStatus());
    }

    private boolean setStatusAndSaveConsent(AisConsent consent, ConsentStatus status) throws WrongChecksumException {
        if (consent.getConsentStatus().isFinalisedStatus()) {
            log.info("Consent ID: [{}], Consent status [{}]. Update consent status by ID failed, because consent status is finalised", (Object)consent.getExternalId(), (Object)consent.getConsentStatus());
            return false;
        }
        consent.setLastActionDate(LocalDate.now());
        consent.setConsentStatus(status);
        AisConsent aisConsent = this.aisConsentRepository.verifyAndSave(consent);
        return Optional.ofNullable(aisConsent).isPresent();
    }

    private void updateAisConsentUsage(AisConsent consent, AisConsentActionRequest request) throws WrongChecksumException {
        if (!request.isUpdateUsage()) {
            return;
        }
        this.aisConsentUsageService.incrementUsage(consent, request);
        if (!consent.isRecurringIndicator() && consent.getAllowedFrequencyPerDay() == 1 && this.oneOffConsentExpirationService.isConsentExpired(consent)) {
            consent.setConsentStatus(ConsentStatus.EXPIRED);
        }
        consent.setLastActionDate(LocalDate.now());
        this.aisConsentRepository.verifyAndSave(consent);
    }

    private void updateStatus(AisConsent aisConsent) {
        aisConsent.setConsentStatus(aisConsent.getConsentStatus() == ConsentStatus.RECEIVED || aisConsent.getConsentStatus() == ConsentStatus.PARTIALLY_AUTHORISED ? ConsentStatus.REJECTED : ConsentStatus.TERMINATED_BY_TPP);
    }

    @ConstructorProperties(value={"authorisationRepository", "aisConsentJpaRepository", "aisConsentRepository", "aisConsentActionRepository", "tppInfoRepository", "consentMapper", "psuDataMapper", "aspspProfileService", "aisConsentConfirmationExpirationService", "tppInfoMapper", "cmsPsuService", "aisConsentUsageService", "aisConsentRequestTypeService", "oneOffConsentExpirationService"})
    public AisConsentServiceInternal(AuthorisationRepository authorisationRepository, AisConsentJpaRepository aisConsentJpaRepository, AisConsentVerifyingRepository aisConsentRepository, AisConsentActionRepository aisConsentActionRepository, TppInfoRepository tppInfoRepository, AisConsentMapper consentMapper, PsuDataMapper psuDataMapper, AspspProfileService aspspProfileService, AisConsentConfirmationExpirationService aisConsentConfirmationExpirationService, TppInfoMapper tppInfoMapper, CmsPsuService cmsPsuService, AisConsentUsageService aisConsentUsageService, AisConsentRequestTypeService aisConsentRequestTypeService, OneOffConsentExpirationService oneOffConsentExpirationService) {
        this.authorisationRepository = authorisationRepository;
        this.aisConsentJpaRepository = aisConsentJpaRepository;
        this.aisConsentRepository = aisConsentRepository;
        this.aisConsentActionRepository = aisConsentActionRepository;
        this.tppInfoRepository = tppInfoRepository;
        this.consentMapper = consentMapper;
        this.psuDataMapper = psuDataMapper;
        this.aspspProfileService = aspspProfileService;
        this.aisConsentConfirmationExpirationService = aisConsentConfirmationExpirationService;
        this.tppInfoMapper = tppInfoMapper;
        this.cmsPsuService = cmsPsuService;
        this.aisConsentUsageService = aisConsentUsageService;
        this.aisConsentRequestTypeService = aisConsentRequestTypeService;
        this.oneOffConsentExpirationService = oneOffConsentExpirationService;
    }
}

