/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.repository.impl;

import de.adorsys.psd2.consent.service.sha.ChecksumCalculatingService;
import de.adorsys.psd2.consent.service.sha.ChecksumCalculatingServiceV1;
import de.adorsys.psd2.consent.service.sha.ChecksumCalculatingServiceV2;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ChecksumCalculatingFactory {
    private final Map<String, ChecksumCalculatingService> services = new HashMap<String, ChecksumCalculatingService>();
    @Autowired
    private ChecksumCalculatingServiceV1 v001;
    @Autowired
    private ChecksumCalculatingServiceV2 v002;

    @PostConstruct
    public void init() {
        this.services.put(this.v001.getVersion(), this.v001);
        this.services.put(this.v002.getVersion(), this.v002);
    }

    Optional<ChecksumCalculatingService> getServiceByChecksum(byte[] checksum) {
        if (checksum == null) {
            return Optional.of(this.getDefaultService());
        }
        String checksumStr = new String(checksum);
        String[] elements = checksumStr.split("_%_");
        if (elements.length < 1) {
            return Optional.of(this.getDefaultService());
        }
        String versionSting = elements[0];
        return Optional.ofNullable(this.services.get(versionSting));
    }

    private ChecksumCalculatingService getDefaultService() {
        return this.v002;
    }
}

