/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.api.CmsScaMethod;
import de.adorsys.psd2.consent.api.pis.authorisation.CreatePisAuthorisationRequest;
import de.adorsys.psd2.consent.api.pis.authorisation.CreatePisAuthorisationResponse;
import de.adorsys.psd2.consent.api.pis.authorisation.GetPisAuthorisationResponse;
import de.adorsys.psd2.consent.api.pis.authorisation.UpdatePisCommonPaymentPsuDataRequest;
import de.adorsys.psd2.consent.api.pis.authorisation.UpdatePisCommonPaymentPsuDataResponse;
import de.adorsys.psd2.consent.api.service.PisAuthorisationService;
import de.adorsys.psd2.consent.api.service.PisAuthorisationServiceEncrypted;
import de.adorsys.psd2.consent.service.security.SecurityDataService;
import de.adorsys.psd2.xs2a.core.pis.PaymentAuthorisationType;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.sca.AuthorisationScaApproachResponse;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class PisAuthorisationServiceInternalEncrypted
implements PisAuthorisationServiceEncrypted {
    private final SecurityDataService securityDataService;
    private final PisAuthorisationService pisAuthorisationService;

    @Transactional
    public Optional<CreatePisAuthorisationResponse> createAuthorization(String encryptedPaymentId, CreatePisAuthorisationRequest request) {
        return this.securityDataService.decryptId(encryptedPaymentId).flatMap(id -> this.pisAuthorisationService.createAuthorization(id, request));
    }

    @Transactional
    public Optional<CreatePisAuthorisationResponse> createAuthorizationCancellation(String encryptedPaymentId, CreatePisAuthorisationRequest request) {
        return this.securityDataService.decryptId(encryptedPaymentId).flatMap(id -> this.pisAuthorisationService.createAuthorizationCancellation(id, request));
    }

    @Transactional
    public Optional<UpdatePisCommonPaymentPsuDataResponse> updatePisAuthorisation(String authorisationId, UpdatePisCommonPaymentPsuDataRequest request) {
        return this.pisAuthorisationService.updatePisAuthorisation(authorisationId, request);
    }

    @Transactional
    public boolean updatePisAuthorisationStatus(String authorisationId, ScaStatus scaStatus) {
        return this.pisAuthorisationService.updatePisAuthorisationStatus(authorisationId, scaStatus);
    }

    @Transactional
    public Optional<UpdatePisCommonPaymentPsuDataResponse> updatePisCancellationAuthorisation(String authorisationId, UpdatePisCommonPaymentPsuDataRequest request) {
        return this.pisAuthorisationService.updatePisCancellationAuthorisation(authorisationId, request);
    }

    public Optional<GetPisAuthorisationResponse> getPisAuthorisationById(String authorisationId) {
        return this.pisAuthorisationService.getPisAuthorisationById(authorisationId);
    }

    public Optional<GetPisAuthorisationResponse> getPisCancellationAuthorisationById(String cancellationId) {
        return this.pisAuthorisationService.getPisCancellationAuthorisationById(cancellationId);
    }

    public Optional<List<String>> getAuthorisationsByPaymentId(String encryptedPaymentId, PaymentAuthorisationType authorisationType) {
        return this.securityDataService.decryptId(encryptedPaymentId).flatMap(id -> this.pisAuthorisationService.getAuthorisationsByPaymentId(id, authorisationType));
    }

    @Transactional
    public Optional<ScaStatus> getAuthorisationScaStatus(String encryptedPaymentId, String authorisationId, PaymentAuthorisationType authorisationType) {
        return this.securityDataService.decryptId(encryptedPaymentId).flatMap(id -> this.pisAuthorisationService.getAuthorisationScaStatus(id, authorisationId, authorisationType));
    }

    public boolean isAuthenticationMethodDecoupled(String authorisationId, String authenticationMethodId) {
        return this.pisAuthorisationService.isAuthenticationMethodDecoupled(authorisationId, authenticationMethodId);
    }

    @Transactional
    public boolean saveAuthenticationMethods(String authorisationId, List<CmsScaMethod> methods) {
        return this.pisAuthorisationService.saveAuthenticationMethods(authorisationId, methods);
    }

    @Transactional
    public boolean updateScaApproach(String authorisationId, ScaApproach scaApproach) {
        return this.pisAuthorisationService.updateScaApproach(authorisationId, scaApproach);
    }

    public Optional<AuthorisationScaApproachResponse> getAuthorisationScaApproach(String authorisationId, PaymentAuthorisationType authorisationType) {
        return this.pisAuthorisationService.getAuthorisationScaApproach(authorisationId, authorisationType);
    }

    @ConstructorProperties(value={"securityDataService", "pisAuthorisationService"})
    public PisAuthorisationServiceInternalEncrypted(SecurityDataService securityDataService, PisAuthorisationService pisAuthorisationService) {
        this.securityDataService = securityDataService;
        this.pisAuthorisationService = pisAuthorisationService;
    }
}

