/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.repository.specification;

import de.adorsys.psd2.consent.domain.payment.PisCommonPaymentData;
import de.adorsys.psd2.consent.repository.specification.EntityAttributeSpecificationProvider;
import de.adorsys.psd2.consent.repository.specification.GenericSpecification;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import java.time.LocalDate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.domain.Specifications;
import org.springframework.stereotype.Service;

@Service
public class PisCommonPaymentDataSpecification
extends GenericSpecification {
    public Specification<PisCommonPaymentData> byPaymentId(String paymentId) {
        return Specifications.where(EntityAttributeSpecificationProvider.provideSpecificationForEntityAttribute("paymentId", paymentId));
    }

    public Specification<PisCommonPaymentData> byPaymentIdAndInstanceId(String paymentId, String instanceId) {
        return Specifications.where(EntityAttributeSpecificationProvider.provideSpecificationForEntityAttribute("paymentId", paymentId)).and(EntityAttributeSpecificationProvider.provideSpecificationForEntityAttribute("instanceId", instanceId));
    }

    public Specification<PisCommonPaymentData> byTppIdAndCreationPeriodAndPsuIdDataAndInstanceId(@NotNull String tppAuthorisationNumber, @Nullable LocalDate createDateFrom, @Nullable LocalDate createDateTo, @Nullable PsuIdData psuIdData, @Nullable String instanceId) {
        return Specifications.where(this.byTppAuthorisationNumber(tppAuthorisationNumber)).and(this.byCreationTimestamp(createDateFrom, createDateTo)).and(this.byPsuIdDataInList(psuIdData)).and(this.byInstanceId(instanceId));
    }

    public Specification<PisCommonPaymentData> byPsuIdDataAndCreationPeriodAndInstanceId(@NotNull PsuIdData psuIdData, @Nullable LocalDate createDateFrom, @Nullable LocalDate createDateTo, @Nullable String instanceId) {
        return Specifications.where(this.byPsuIdDataInList(psuIdData)).and(this.byCreationTimestamp(createDateFrom, createDateTo)).and(this.byInstanceId(instanceId));
    }

    public Specification<PisCommonPaymentData> byAspspAccountIdAndCreationPeriodAndInstanceId(@NotNull String aspspAccountId, @Nullable LocalDate createDateFrom, @Nullable LocalDate createDateTo, @Nullable String instanceId) {
        return Specifications.where(this.byAspspAccountId(aspspAccountId)).and(this.byCreationTimestamp(createDateFrom, createDateTo)).and(this.byInstanceId(instanceId));
    }
}

