/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.scheduler;

import de.adorsys.psd2.consent.domain.account.AisConsent;
import de.adorsys.psd2.consent.repository.AisConsentRepository;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ConsentScheduleTask {
    private static final Logger log = LoggerFactory.getLogger(ConsentScheduleTask.class);
    private final AisConsentRepository aisConsentRepository;

    @Scheduled(cron="${consent.cron.expression}")
    @Transactional
    public void checkConsentStatus() {
        log.info("Consent schedule task is run!");
        List<AisConsent> availableConsents = Optional.ofNullable(this.aisConsentRepository.findByConsentStatusIn(EnumSet.of(ConsentStatus.RECEIVED, ConsentStatus.VALID))).orElse(Collections.emptyList());
        this.aisConsentRepository.saveAll(this.updateConsent(availableConsents));
    }

    private List<AisConsent> updateConsent(List<AisConsent> availableConsents) {
        return availableConsents.stream().filter(AisConsent::isExpiredByDate).map(this::updateConsentParameters).collect(Collectors.toList());
    }

    private AisConsent updateConsentParameters(AisConsent consent) {
        consent.setConsentStatus(ConsentStatus.EXPIRED);
        consent.setExpireDate(LocalDate.now());
        return consent;
    }

    @ConstructorProperties(value={"aisConsentRepository"})
    public ConsentScheduleTask(AisConsentRepository aisConsentRepository) {
        this.aisConsentRepository = aisConsentRepository;
    }
}

