/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.api.service.UpdatePaymentAfterSpiService;
import de.adorsys.psd2.consent.api.service.UpdatePaymentAfterSpiServiceEncrypted;
import de.adorsys.psd2.consent.service.security.SecurityDataService;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.tpp.TppRedirectUri;
import java.beans.ConstructorProperties;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class UpdatePaymentAfterSpiServiceInternalEncrypted
implements UpdatePaymentAfterSpiServiceEncrypted {
    private static final Logger log = LoggerFactory.getLogger(UpdatePaymentAfterSpiServiceInternalEncrypted.class);
    private final SecurityDataService securityDataService;
    private final UpdatePaymentAfterSpiService updatePaymentStatusAfterSpiService;

    @Transactional
    public boolean updatePaymentStatus(@NotNull String encryptedPaymentId, @NotNull TransactionStatus status) {
        return this.securityDataService.decryptId(encryptedPaymentId).map(id -> this.updatePaymentStatusAfterSpiService.updatePaymentStatus(id, status)).orElseGet(() -> {
            log.info("Encrypted Payment ID [{}]. Update payment status by id failed, couldn't decrypt payment id", (Object)encryptedPaymentId);
            return false;
        });
    }

    @Transactional
    public boolean updatePaymentCancellationTppRedirectUri(@NotNull String encryptedPaymentId, @NotNull TppRedirectUri tppRedirectUri) {
        return this.securityDataService.decryptId(encryptedPaymentId).map(id -> this.updatePaymentStatusAfterSpiService.updatePaymentCancellationTppRedirectUri(id, tppRedirectUri)).orElseGet(() -> {
            log.info("Encrypted Payment ID [{}]. Update cancellation payment tpp redirect URIs by id failed, couldn't decrypt payment id", (Object)encryptedPaymentId);
            return false;
        });
    }

    @Transactional
    public boolean updatePaymentCancellationInternalRequestId(@NotNull String encryptedPaymentId, @NotNull String internalRequestId) {
        return this.securityDataService.decryptId(encryptedPaymentId).map(id -> this.updatePaymentStatusAfterSpiService.updatePaymentCancellationInternalRequestId(id, internalRequestId)).orElseGet(() -> {
            log.info("Encrypted Payment ID [{}]. Update cancellation payment internal request ID failed, couldn't decrypt payment id", (Object)encryptedPaymentId);
            return false;
        });
    }

    @ConstructorProperties(value={"securityDataService", "updatePaymentStatusAfterSpiService"})
    public UpdatePaymentAfterSpiServiceInternalEncrypted(SecurityDataService securityDataService, UpdatePaymentAfterSpiService updatePaymentStatusAfterSpiService) {
        this.securityDataService = securityDataService;
        this.updatePaymentStatusAfterSpiService = updatePaymentStatusAfterSpiService;
    }
}

