/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.api.pis.CreatePisCommonPaymentResponse;
import de.adorsys.psd2.consent.api.pis.proto.PisCommonPaymentRequest;
import de.adorsys.psd2.consent.api.pis.proto.PisCommonPaymentResponse;
import de.adorsys.psd2.consent.api.pis.proto.PisPaymentInfo;
import de.adorsys.psd2.consent.api.service.PisCommonPaymentService;
import de.adorsys.psd2.consent.api.service.PisCommonPaymentServiceEncrypted;
import de.adorsys.psd2.consent.service.security.SecurityDataService;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class PisCommonPaymentServiceInternalEncrypted
implements PisCommonPaymentServiceEncrypted {
    private final SecurityDataService securityDataService;
    private final PisCommonPaymentService pisCommonPaymentService;

    @Transactional
    public Optional<CreatePisCommonPaymentResponse> createCommonPayment(PisPaymentInfo request) {
        return this.pisCommonPaymentService.createCommonPayment(request).map(CreatePisCommonPaymentResponse::getPaymentId).flatMap(this.securityDataService::encryptId).map(CreatePisCommonPaymentResponse::new);
    }

    @Transactional
    public Optional<TransactionStatus> getPisCommonPaymentStatusById(String encryptedPaymentId) {
        return this.securityDataService.decryptId(encryptedPaymentId).flatMap(x$0 -> this.pisCommonPaymentService.getPisCommonPaymentStatusById(x$0));
    }

    @Transactional
    public Optional<PisCommonPaymentResponse> getCommonPaymentById(String encryptedPaymentId) {
        return this.securityDataService.decryptId(encryptedPaymentId).flatMap(x$0 -> this.pisCommonPaymentService.getCommonPaymentById(x$0));
    }

    @Transactional
    public Optional<Boolean> updateCommonPaymentStatusById(String encryptedPaymentId, TransactionStatus status) {
        return this.securityDataService.decryptId(encryptedPaymentId).flatMap(id -> this.pisCommonPaymentService.updateCommonPaymentStatusById(id, status));
    }

    public Optional<String> getDecryptedId(String encryptedId) {
        return this.securityDataService.decryptId(encryptedId);
    }

    @Transactional
    public void updateCommonPayment(PisCommonPaymentRequest request, String encryptedPaymentId) {
        this.securityDataService.decryptId(encryptedPaymentId).ifPresent(id -> this.pisCommonPaymentService.updateCommonPayment(request, id));
    }

    @Transactional
    public boolean updateMultilevelSca(String paymentId, boolean multilevelScaRequired) {
        Optional<String> decryptedId = this.securityDataService.decryptId(paymentId);
        return decryptedId.filter(id -> this.pisCommonPaymentService.updateMultilevelSca(id, multilevelScaRequired)).isPresent();
    }

    public Optional<List<PsuIdData>> getPsuDataListByPaymentId(String encryptedPaymentId) {
        return this.securityDataService.decryptId(encryptedPaymentId).flatMap(x$0 -> this.pisCommonPaymentService.getPsuDataListByPaymentId(x$0));
    }

    @ConstructorProperties(value={"securityDataService", "pisCommonPaymentService"})
    public PisCommonPaymentServiceInternalEncrypted(SecurityDataService securityDataService, PisCommonPaymentService pisCommonPaymentService) {
        this.securityDataService = securityDataService;
        this.pisCommonPaymentService = pisCommonPaymentService;
    }
}

