/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.api.pis.CreatePisCommonPaymentResponse;
import de.adorsys.psd2.consent.api.pis.proto.PisCommonPaymentRequest;
import de.adorsys.psd2.consent.api.pis.proto.PisCommonPaymentResponse;
import de.adorsys.psd2.consent.api.pis.proto.PisPaymentInfo;
import de.adorsys.psd2.consent.api.service.PisCommonPaymentService;
import de.adorsys.psd2.consent.domain.payment.PisCommonPaymentData;
import de.adorsys.psd2.consent.domain.payment.PisPaymentData;
import de.adorsys.psd2.consent.repository.PisCommonPaymentDataRepository;
import de.adorsys.psd2.consent.repository.PisPaymentDataRepository;
import de.adorsys.psd2.consent.repository.TppInfoRepository;
import de.adorsys.psd2.consent.service.PisCommonPaymentConfirmationExpirationService;
import de.adorsys.psd2.consent.service.mapper.PisCommonPaymentMapper;
import de.adorsys.psd2.consent.service.mapper.PsuDataMapper;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class PisCommonPaymentServiceInternal
implements PisCommonPaymentService {
    private static final Logger log = LoggerFactory.getLogger(PisCommonPaymentServiceInternal.class);
    private final PisCommonPaymentMapper pisCommonPaymentMapper;
    private final PsuDataMapper psuDataMapper;
    private final PisPaymentDataRepository pisPaymentDataRepository;
    private final PisCommonPaymentDataRepository pisCommonPaymentDataRepository;
    private final TppInfoRepository tppInfoRepository;
    private final PisCommonPaymentConfirmationExpirationService pisCommonPaymentConfirmationExpirationService;

    @Transactional
    public Optional<CreatePisCommonPaymentResponse> createCommonPayment(PisPaymentInfo request) {
        PisCommonPaymentData commonPaymentData = this.pisCommonPaymentMapper.mapToPisCommonPaymentData(request);
        this.tppInfoRepository.findByAuthorisationNumber(request.getTppInfo().getAuthorisationNumber()).ifPresent(commonPaymentData::setTppInfo);
        PisCommonPaymentData saved = (PisCommonPaymentData)this.pisCommonPaymentDataRepository.save(commonPaymentData);
        if (saved.getId() == null) {
            log.info("Payment ID: [{}]. Pis common payment cannot be created, because when saving to DB got null PisCommonPaymentData ID", (Object)request.getPaymentId());
            return Optional.empty();
        }
        return Optional.of(new CreatePisCommonPaymentResponse(saved.getPaymentId()));
    }

    @Transactional
    public Optional<TransactionStatus> getPisCommonPaymentStatusById(String paymentId) {
        return this.pisCommonPaymentDataRepository.findByPaymentId(paymentId).map(this.pisCommonPaymentConfirmationExpirationService::checkAndUpdatePaymentDataOnConfirmationExpiration).map(PisCommonPaymentData::getTransactionStatus);
    }

    @Transactional
    public Optional<PisCommonPaymentResponse> getCommonPaymentById(String paymentId) {
        return this.pisCommonPaymentDataRepository.findByPaymentId(paymentId).map(this.pisCommonPaymentConfirmationExpirationService::checkAndUpdatePaymentDataOnConfirmationExpiration).flatMap(this.pisCommonPaymentMapper::mapToPisCommonPaymentResponse);
    }

    @Transactional
    public Optional<Boolean> updateCommonPaymentStatusById(String paymentId, TransactionStatus status) {
        return this.pisCommonPaymentDataRepository.findByPaymentId(paymentId).map(this.pisCommonPaymentConfirmationExpirationService::checkAndUpdatePaymentDataOnConfirmationExpiration).filter(pm -> !pm.getTransactionStatus().isFinalisedStatus()).map(pmt -> this.setStatusAndSaveCommonPaymentData((PisCommonPaymentData)pmt, status)).map(con -> con.getTransactionStatus() == status);
    }

    @Transactional
    public void updateCommonPayment(PisCommonPaymentRequest request, String paymentId) {
        Optional<PisCommonPaymentData> pisCommonPaymentById = this.pisCommonPaymentDataRepository.findByPaymentId(paymentId);
        pisCommonPaymentById.ifPresent(commonPayment -> this.savePaymentData((PisCommonPaymentData)commonPayment, request));
    }

    @Transactional
    public boolean updateMultilevelSca(String paymentId, boolean multilevelScaRequired) {
        Optional<PisCommonPaymentData> pisCommonPaymentDataOptional = this.pisCommonPaymentDataRepository.findByPaymentId(paymentId);
        if (!pisCommonPaymentDataOptional.isPresent()) {
            log.info("Payment ID: [{}]. Update multilevel SCA required status failed, because payment is not found", (Object)paymentId);
            return false;
        }
        PisCommonPaymentData payment = pisCommonPaymentDataOptional.get();
        payment.setMultilevelScaRequired(multilevelScaRequired);
        this.pisCommonPaymentDataRepository.save(payment);
        return true;
    }

    public Optional<List<PsuIdData>> getPsuDataListByPaymentId(String paymentId) {
        return this.readPisCommonPaymentDataByPaymentId(paymentId).map(pc -> this.psuDataMapper.mapToPsuIdDataList(pc.getPsuDataList()));
    }

    private PisCommonPaymentData setStatusAndSaveCommonPaymentData(PisCommonPaymentData commonPaymentData, TransactionStatus status) {
        commonPaymentData.setTransactionStatus(status);
        return (PisCommonPaymentData)this.pisCommonPaymentDataRepository.save(commonPaymentData);
    }

    private Optional<PisCommonPaymentData> readPisCommonPaymentDataByPaymentId(String paymentId) {
        Optional<PisCommonPaymentData> commonPaymentData = this.pisPaymentDataRepository.findByPaymentId(paymentId).filter(CollectionUtils::isNotEmpty).map(list -> ((PisPaymentData)list.get(0)).getPaymentData());
        if (!commonPaymentData.isPresent()) {
            commonPaymentData = this.pisCommonPaymentDataRepository.findByPaymentId(paymentId);
        }
        return commonPaymentData;
    }

    private void savePaymentData(PisCommonPaymentData pisCommonPayment, PisCommonPaymentRequest request) {
        boolean isCommonPayment;
        boolean bl = isCommonPayment = CollectionUtils.isEmpty((Collection)request.getPayments()) && request.getPaymentInfo() != null;
        if (isCommonPayment) {
            this.pisCommonPaymentDataRepository.save(this.pisCommonPaymentMapper.mapToPisCommonPaymentData(request.getPaymentInfo()));
        } else {
            this.pisPaymentDataRepository.saveAll(this.pisCommonPaymentMapper.mapToPisPaymentDataList(request.getPayments(), pisCommonPayment));
        }
    }

    @ConstructorProperties(value={"pisCommonPaymentMapper", "psuDataMapper", "pisPaymentDataRepository", "pisCommonPaymentDataRepository", "tppInfoRepository", "pisCommonPaymentConfirmationExpirationService"})
    public PisCommonPaymentServiceInternal(PisCommonPaymentMapper pisCommonPaymentMapper, PsuDataMapper psuDataMapper, PisPaymentDataRepository pisPaymentDataRepository, PisCommonPaymentDataRepository pisCommonPaymentDataRepository, TppInfoRepository tppInfoRepository, PisCommonPaymentConfirmationExpirationService pisCommonPaymentConfirmationExpirationService) {
        this.pisCommonPaymentMapper = pisCommonPaymentMapper;
        this.psuDataMapper = psuDataMapper;
        this.pisPaymentDataRepository = pisPaymentDataRepository;
        this.pisCommonPaymentDataRepository = pisCommonPaymentDataRepository;
        this.tppInfoRepository = tppInfoRepository;
        this.pisCommonPaymentConfirmationExpirationService = pisCommonPaymentConfirmationExpirationService;
    }
}

