/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.api.ais.AisAccountAccessInfo;
import de.adorsys.psd2.consent.domain.account.AisConsent;
import de.adorsys.psd2.xs2a.core.ais.AccountAccessType;
import de.adorsys.psd2.xs2a.core.consent.AisConsentRequestType;
import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class AisConsentRequestTypeService {
    public AisConsentRequestType getRequestTypeFromConsent(AisConsent aisConsent) {
        return this.getRequestType(aisConsent.getAllPsd2(), aisConsent.getAvailableAccounts(), aisConsent.getAvailableAccountsWithBalance(), aisConsent.getAspspAccountAccesses().isEmpty());
    }

    public AisConsentRequestType getRequestTypeFromAccess(AisAccountAccessInfo accessInfo) {
        return this.getRequestType(accessInfo.getAllPsd2(), accessInfo.getAvailableAccounts(), accessInfo.getAvailableAccountsWithBalance(), this.isEmptyAccess(accessInfo));
    }

    private boolean isEmptyAccess(AisAccountAccessInfo accessInfo) {
        return CollectionUtils.isEmpty((Collection)accessInfo.getAccounts()) && CollectionUtils.isEmpty((Collection)accessInfo.getBalances()) && CollectionUtils.isEmpty((Collection)accessInfo.getTransactions());
    }

    private AisConsentRequestType getRequestType(AccountAccessType allPsd2, AccountAccessType availableAccounts, AccountAccessType availableAccountsWithBalance, boolean isAccessesEmpty) {
        if (AccountAccessType.ALL_ACCOUNTS == allPsd2) {
            return AisConsentRequestType.GLOBAL;
        }
        if (AccountAccessType.ALL_ACCOUNTS == availableAccounts) {
            return AisConsentRequestType.ALL_AVAILABLE_ACCOUNTS;
        }
        if (AccountAccessType.ALL_ACCOUNTS == availableAccountsWithBalance) {
            return AisConsentRequestType.ALL_AVAILABLE_ACCOUNTS;
        }
        if (isAccessesEmpty) {
            return AisConsentRequestType.BANK_OFFERED;
        }
        return AisConsentRequestType.DEDICATED_ACCOUNTS;
    }
}

