/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.api.service.AccountService;
import de.adorsys.psd2.consent.domain.account.AisConsent;
import de.adorsys.psd2.consent.domain.account.AisConsentTransaction;
import de.adorsys.psd2.consent.repository.AisConsentRepository;
import de.adorsys.psd2.consent.repository.AisConsentTransactionRepository;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AccountServiceInternal
implements AccountService {
    private static final Logger log = LoggerFactory.getLogger(AccountServiceInternal.class);
    private final AisConsentTransactionRepository aisConsentTransactionRepository;
    private final AisConsentRepository aisConsentRepository;

    @Transactional
    public boolean saveNumberOfTransactions(String consentId, String resourceId, int numberOfTransactions) {
        Optional<AisConsent> optionalAisConsent = this.aisConsentRepository.findByExternalId(consentId);
        if (optionalAisConsent.isPresent()) {
            AisConsentTransaction aisConsentTransaction = new AisConsentTransaction();
            aisConsentTransaction.setConsentId(optionalAisConsent.get());
            aisConsentTransaction.setResourceId(resourceId);
            aisConsentTransaction.setNumberOfTransactions(numberOfTransactions);
            this.aisConsentTransactionRepository.save(aisConsentTransaction);
            return true;
        }
        log.info("Consent ID: [{}]. Save number of transactions failed, because consent not found", (Object)consentId);
        return false;
    }

    @ConstructorProperties(value={"aisConsentTransactionRepository", "aisConsentRepository"})
    public AccountServiceInternal(AisConsentTransactionRepository aisConsentTransactionRepository, AisConsentRepository aisConsentRepository) {
        this.aisConsentTransactionRepository = aisConsentTransactionRepository;
        this.aisConsentRepository = aisConsentRepository;
    }
}

