/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.domain.payment;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.adorsys.psd2.consent.domain.AccountReferenceEntity;
import de.adorsys.psd2.consent.domain.InstanceDependableEntity;
import de.adorsys.psd2.consent.domain.payment.PisAddress;
import de.adorsys.psd2.consent.domain.payment.PisCommonPaymentData;
import de.adorsys.psd2.consent.domain.payment.PisRemittance;
import de.adorsys.psd2.xs2a.core.pis.PisDayOfExecution;
import de.adorsys.psd2.xs2a.core.pis.PisExecutionRule;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Currency;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;

@Entity(name="pis_payment_data")
@ApiModel(description="pis payment entity", value="PisPaymentData")
public class PisPaymentData
extends InstanceDependableEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="pis_payment_data_generator")
    @SequenceGenerator(name="pis_payment_data_generator", sequenceName="pis_payment_data_id_seq", allocationSize=1)
    private Long id;
    @Column(name="payment_id", nullable=false)
    private String paymentId;
    @Column(name="end_to_end_identification")
    @ApiModelProperty(value="End to end identification", example="RI-123456789")
    private String endToEndIdentification;
    @Column(name="instruction_identification")
    private String instructionIdentification;
    @JoinColumn(name="debtor_acc_reference_id")
    @ManyToOne(cascade={CascadeType.ALL})
    @ApiModelProperty(value="Debtor account", required=true)
    private AccountReferenceEntity debtorAccount;
    @Column(name="ultimate_debtor")
    @ApiModelProperty(value="Name of the ultimate debtor", example="Mueller")
    private String ultimateDebtor;
    @Column(name="currency", nullable=false)
    @ApiModelProperty(value="Iso currency code", required=true, example="EUR")
    private Currency currency;
    @Column(name="amount", nullable=false)
    @ApiModelProperty(value="Payment amount", required=true, example="1000")
    private BigDecimal amount;
    @JoinColumn(name="creditor_acc_reference_id")
    @ManyToOne(cascade={CascadeType.ALL})
    @ApiModelProperty(value="Creditor account", required=true)
    private AccountReferenceEntity creditorAccount;
    @Column(name="creditor_agent")
    @ApiModelProperty(value="Creditor agent", example="Telekom")
    private String creditorAgent;
    @Column(name="creditor_name", nullable=false)
    @ApiModelProperty(value="Name of the creditor", required=true, example="Telekom")
    private String creditorName;
    @OneToOne(cascade={CascadeType.ALL})
    @ApiModelProperty(value="Creditor Address")
    @JoinColumn(name="address_id")
    private PisAddress creditorAddress;
    @Column(name="remittance_info_unstruct")
    @ApiModelProperty(value="remittance information unstructured", example="Ref. Number TELEKOM-1222")
    private String remittanceInformationUnstructured;
    @OneToOne(cascade={CascadeType.ALL})
    @ApiModelProperty(value="remittance information structured")
    @JoinColumn(name="remittance_id")
    private PisRemittance remittanceInformationStructured;
    @Column(name="requested_execution_date")
    @ApiModelProperty(value="Requested execution date", example="2020-01-01")
    private LocalDate requestedExecutionDate;
    @Column(name="requested_execution_time")
    @ApiModelProperty(value="Requested execution time", example="2020-01-01T15:30:35.035Z")
    private OffsetDateTime requestedExecutionTime;
    @Column(name="ultimate_creditor")
    @ApiModelProperty(value="Ultimate creditor", example="Telekom")
    private String ultimateCreditor;
    @Column(name="purpose_code")
    @ApiModelProperty(value="Purpose code", example="BCENECEQ")
    private String purposeCode;
    @Column(name="start_date")
    @ApiModelProperty(name="startDate", example="2020-01-01")
    private LocalDate startDate;
    @Column(name="execution_rule")
    @ApiModelProperty(name="Execution rule", example="following")
    private PisExecutionRule executionRule;
    @Column(name="end_date")
    @ApiModelProperty(name="endDate", example="2020-03-03")
    private LocalDate endDate;
    @ApiModelProperty(name="frequency", example="ANNUAL")
    private String frequency;
    @Column(name="day_of_execution")
    @ApiModelProperty(name="dayOfExecution", example="14")
    private PisDayOfExecution dayOfExecution;
    @JsonIgnore
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="common_payment_id", nullable=false)
    @ApiModelProperty(value="Detailed information about payment", required=true)
    private PisCommonPaymentData paymentData;
    @Column(name="batch_booking_preferred")
    @ApiModelProperty(name="Batch booking preferred", example="true")
    private Boolean batchBookingPreferred;

    public Long getId() {
        return this.id;
    }

    public String getPaymentId() {
        return this.paymentId;
    }

    public String getEndToEndIdentification() {
        return this.endToEndIdentification;
    }

    public String getInstructionIdentification() {
        return this.instructionIdentification;
    }

    public AccountReferenceEntity getDebtorAccount() {
        return this.debtorAccount;
    }

    public String getUltimateDebtor() {
        return this.ultimateDebtor;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public AccountReferenceEntity getCreditorAccount() {
        return this.creditorAccount;
    }

    public String getCreditorAgent() {
        return this.creditorAgent;
    }

    public String getCreditorName() {
        return this.creditorName;
    }

    public PisAddress getCreditorAddress() {
        return this.creditorAddress;
    }

    public String getRemittanceInformationUnstructured() {
        return this.remittanceInformationUnstructured;
    }

    public PisRemittance getRemittanceInformationStructured() {
        return this.remittanceInformationStructured;
    }

    public LocalDate getRequestedExecutionDate() {
        return this.requestedExecutionDate;
    }

    public OffsetDateTime getRequestedExecutionTime() {
        return this.requestedExecutionTime;
    }

    public String getUltimateCreditor() {
        return this.ultimateCreditor;
    }

    public String getPurposeCode() {
        return this.purposeCode;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public PisExecutionRule getExecutionRule() {
        return this.executionRule;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public String getFrequency() {
        return this.frequency;
    }

    public PisDayOfExecution getDayOfExecution() {
        return this.dayOfExecution;
    }

    public PisCommonPaymentData getPaymentData() {
        return this.paymentData;
    }

    public Boolean getBatchBookingPreferred() {
        return this.batchBookingPreferred;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }

    public void setEndToEndIdentification(String endToEndIdentification) {
        this.endToEndIdentification = endToEndIdentification;
    }

    public void setInstructionIdentification(String instructionIdentification) {
        this.instructionIdentification = instructionIdentification;
    }

    public void setDebtorAccount(AccountReferenceEntity debtorAccount) {
        this.debtorAccount = debtorAccount;
    }

    public void setUltimateDebtor(String ultimateDebtor) {
        this.ultimateDebtor = ultimateDebtor;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public void setCreditorAccount(AccountReferenceEntity creditorAccount) {
        this.creditorAccount = creditorAccount;
    }

    public void setCreditorAgent(String creditorAgent) {
        this.creditorAgent = creditorAgent;
    }

    public void setCreditorName(String creditorName) {
        this.creditorName = creditorName;
    }

    public void setCreditorAddress(PisAddress creditorAddress) {
        this.creditorAddress = creditorAddress;
    }

    public void setRemittanceInformationUnstructured(String remittanceInformationUnstructured) {
        this.remittanceInformationUnstructured = remittanceInformationUnstructured;
    }

    public void setRemittanceInformationStructured(PisRemittance remittanceInformationStructured) {
        this.remittanceInformationStructured = remittanceInformationStructured;
    }

    public void setRequestedExecutionDate(LocalDate requestedExecutionDate) {
        this.requestedExecutionDate = requestedExecutionDate;
    }

    public void setRequestedExecutionTime(OffsetDateTime requestedExecutionTime) {
        this.requestedExecutionTime = requestedExecutionTime;
    }

    public void setUltimateCreditor(String ultimateCreditor) {
        this.ultimateCreditor = ultimateCreditor;
    }

    public void setPurposeCode(String purposeCode) {
        this.purposeCode = purposeCode;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public void setExecutionRule(PisExecutionRule executionRule) {
        this.executionRule = executionRule;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public void setFrequency(String frequency) {
        this.frequency = frequency;
    }

    public void setDayOfExecution(PisDayOfExecution dayOfExecution) {
        this.dayOfExecution = dayOfExecution;
    }

    public void setPaymentData(PisCommonPaymentData paymentData) {
        this.paymentData = paymentData;
    }

    public void setBatchBookingPreferred(Boolean batchBookingPreferred) {
        this.batchBookingPreferred = batchBookingPreferred;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PisPaymentData)) {
            return false;
        }
        PisPaymentData other = (PisPaymentData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$paymentId = this.getPaymentId();
        String other$paymentId = other.getPaymentId();
        if (this$paymentId == null ? other$paymentId != null : !this$paymentId.equals(other$paymentId)) {
            return false;
        }
        String this$endToEndIdentification = this.getEndToEndIdentification();
        String other$endToEndIdentification = other.getEndToEndIdentification();
        if (this$endToEndIdentification == null ? other$endToEndIdentification != null : !this$endToEndIdentification.equals(other$endToEndIdentification)) {
            return false;
        }
        String this$instructionIdentification = this.getInstructionIdentification();
        String other$instructionIdentification = other.getInstructionIdentification();
        if (this$instructionIdentification == null ? other$instructionIdentification != null : !this$instructionIdentification.equals(other$instructionIdentification)) {
            return false;
        }
        AccountReferenceEntity this$debtorAccount = this.getDebtorAccount();
        AccountReferenceEntity other$debtorAccount = other.getDebtorAccount();
        if (this$debtorAccount == null ? other$debtorAccount != null : !((Object)this$debtorAccount).equals(other$debtorAccount)) {
            return false;
        }
        String this$ultimateDebtor = this.getUltimateDebtor();
        String other$ultimateDebtor = other.getUltimateDebtor();
        if (this$ultimateDebtor == null ? other$ultimateDebtor != null : !this$ultimateDebtor.equals(other$ultimateDebtor)) {
            return false;
        }
        Currency this$currency = this.getCurrency();
        Currency other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        BigDecimal this$amount = this.getAmount();
        BigDecimal other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        AccountReferenceEntity this$creditorAccount = this.getCreditorAccount();
        AccountReferenceEntity other$creditorAccount = other.getCreditorAccount();
        if (this$creditorAccount == null ? other$creditorAccount != null : !((Object)this$creditorAccount).equals(other$creditorAccount)) {
            return false;
        }
        String this$creditorAgent = this.getCreditorAgent();
        String other$creditorAgent = other.getCreditorAgent();
        if (this$creditorAgent == null ? other$creditorAgent != null : !this$creditorAgent.equals(other$creditorAgent)) {
            return false;
        }
        String this$creditorName = this.getCreditorName();
        String other$creditorName = other.getCreditorName();
        if (this$creditorName == null ? other$creditorName != null : !this$creditorName.equals(other$creditorName)) {
            return false;
        }
        PisAddress this$creditorAddress = this.getCreditorAddress();
        PisAddress other$creditorAddress = other.getCreditorAddress();
        if (this$creditorAddress == null ? other$creditorAddress != null : !((Object)this$creditorAddress).equals(other$creditorAddress)) {
            return false;
        }
        String this$remittanceInformationUnstructured = this.getRemittanceInformationUnstructured();
        String other$remittanceInformationUnstructured = other.getRemittanceInformationUnstructured();
        if (this$remittanceInformationUnstructured == null ? other$remittanceInformationUnstructured != null : !this$remittanceInformationUnstructured.equals(other$remittanceInformationUnstructured)) {
            return false;
        }
        PisRemittance this$remittanceInformationStructured = this.getRemittanceInformationStructured();
        PisRemittance other$remittanceInformationStructured = other.getRemittanceInformationStructured();
        if (this$remittanceInformationStructured == null ? other$remittanceInformationStructured != null : !((Object)this$remittanceInformationStructured).equals(other$remittanceInformationStructured)) {
            return false;
        }
        LocalDate this$requestedExecutionDate = this.getRequestedExecutionDate();
        LocalDate other$requestedExecutionDate = other.getRequestedExecutionDate();
        if (this$requestedExecutionDate == null ? other$requestedExecutionDate != null : !((Object)this$requestedExecutionDate).equals(other$requestedExecutionDate)) {
            return false;
        }
        OffsetDateTime this$requestedExecutionTime = this.getRequestedExecutionTime();
        OffsetDateTime other$requestedExecutionTime = other.getRequestedExecutionTime();
        if (this$requestedExecutionTime == null ? other$requestedExecutionTime != null : !((Object)this$requestedExecutionTime).equals(other$requestedExecutionTime)) {
            return false;
        }
        String this$ultimateCreditor = this.getUltimateCreditor();
        String other$ultimateCreditor = other.getUltimateCreditor();
        if (this$ultimateCreditor == null ? other$ultimateCreditor != null : !this$ultimateCreditor.equals(other$ultimateCreditor)) {
            return false;
        }
        String this$purposeCode = this.getPurposeCode();
        String other$purposeCode = other.getPurposeCode();
        if (this$purposeCode == null ? other$purposeCode != null : !this$purposeCode.equals(other$purposeCode)) {
            return false;
        }
        LocalDate this$startDate = this.getStartDate();
        LocalDate other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
            return false;
        }
        PisExecutionRule this$executionRule = this.getExecutionRule();
        PisExecutionRule other$executionRule = other.getExecutionRule();
        if (this$executionRule == null ? other$executionRule != null : !this$executionRule.equals(other$executionRule)) {
            return false;
        }
        LocalDate this$endDate = this.getEndDate();
        LocalDate other$endDate = other.getEndDate();
        if (this$endDate == null ? other$endDate != null : !((Object)this$endDate).equals(other$endDate)) {
            return false;
        }
        String this$frequency = this.getFrequency();
        String other$frequency = other.getFrequency();
        if (this$frequency == null ? other$frequency != null : !this$frequency.equals(other$frequency)) {
            return false;
        }
        PisDayOfExecution this$dayOfExecution = this.getDayOfExecution();
        PisDayOfExecution other$dayOfExecution = other.getDayOfExecution();
        if (this$dayOfExecution == null ? other$dayOfExecution != null : !this$dayOfExecution.equals(other$dayOfExecution)) {
            return false;
        }
        PisCommonPaymentData this$paymentData = this.getPaymentData();
        PisCommonPaymentData other$paymentData = other.getPaymentData();
        if (this$paymentData == null ? other$paymentData != null : !((Object)this$paymentData).equals(other$paymentData)) {
            return false;
        }
        Boolean this$batchBookingPreferred = this.getBatchBookingPreferred();
        Boolean other$batchBookingPreferred = other.getBatchBookingPreferred();
        return !(this$batchBookingPreferred == null ? other$batchBookingPreferred != null : !((Object)this$batchBookingPreferred).equals(other$batchBookingPreferred));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PisPaymentData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $paymentId = this.getPaymentId();
        result = result * 59 + ($paymentId == null ? 43 : $paymentId.hashCode());
        String $endToEndIdentification = this.getEndToEndIdentification();
        result = result * 59 + ($endToEndIdentification == null ? 43 : $endToEndIdentification.hashCode());
        String $instructionIdentification = this.getInstructionIdentification();
        result = result * 59 + ($instructionIdentification == null ? 43 : $instructionIdentification.hashCode());
        AccountReferenceEntity $debtorAccount = this.getDebtorAccount();
        result = result * 59 + ($debtorAccount == null ? 43 : ((Object)$debtorAccount).hashCode());
        String $ultimateDebtor = this.getUltimateDebtor();
        result = result * 59 + ($ultimateDebtor == null ? 43 : $ultimateDebtor.hashCode());
        Currency $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        BigDecimal $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        AccountReferenceEntity $creditorAccount = this.getCreditorAccount();
        result = result * 59 + ($creditorAccount == null ? 43 : ((Object)$creditorAccount).hashCode());
        String $creditorAgent = this.getCreditorAgent();
        result = result * 59 + ($creditorAgent == null ? 43 : $creditorAgent.hashCode());
        String $creditorName = this.getCreditorName();
        result = result * 59 + ($creditorName == null ? 43 : $creditorName.hashCode());
        PisAddress $creditorAddress = this.getCreditorAddress();
        result = result * 59 + ($creditorAddress == null ? 43 : ((Object)$creditorAddress).hashCode());
        String $remittanceInformationUnstructured = this.getRemittanceInformationUnstructured();
        result = result * 59 + ($remittanceInformationUnstructured == null ? 43 : $remittanceInformationUnstructured.hashCode());
        PisRemittance $remittanceInformationStructured = this.getRemittanceInformationStructured();
        result = result * 59 + ($remittanceInformationStructured == null ? 43 : ((Object)$remittanceInformationStructured).hashCode());
        LocalDate $requestedExecutionDate = this.getRequestedExecutionDate();
        result = result * 59 + ($requestedExecutionDate == null ? 43 : ((Object)$requestedExecutionDate).hashCode());
        OffsetDateTime $requestedExecutionTime = this.getRequestedExecutionTime();
        result = result * 59 + ($requestedExecutionTime == null ? 43 : ((Object)$requestedExecutionTime).hashCode());
        String $ultimateCreditor = this.getUltimateCreditor();
        result = result * 59 + ($ultimateCreditor == null ? 43 : $ultimateCreditor.hashCode());
        String $purposeCode = this.getPurposeCode();
        result = result * 59 + ($purposeCode == null ? 43 : $purposeCode.hashCode());
        LocalDate $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
        PisExecutionRule $executionRule = this.getExecutionRule();
        result = result * 59 + ($executionRule == null ? 43 : $executionRule.hashCode());
        LocalDate $endDate = this.getEndDate();
        result = result * 59 + ($endDate == null ? 43 : ((Object)$endDate).hashCode());
        String $frequency = this.getFrequency();
        result = result * 59 + ($frequency == null ? 43 : $frequency.hashCode());
        PisDayOfExecution $dayOfExecution = this.getDayOfExecution();
        result = result * 59 + ($dayOfExecution == null ? 43 : $dayOfExecution.hashCode());
        PisCommonPaymentData $paymentData = this.getPaymentData();
        result = result * 59 + ($paymentData == null ? 43 : ((Object)$paymentData).hashCode());
        Boolean $batchBookingPreferred = this.getBatchBookingPreferred();
        result = result * 59 + ($batchBookingPreferred == null ? 43 : ((Object)$batchBookingPreferred).hashCode());
        return result;
    }

    public String toString() {
        return "PisPaymentData(id=" + this.getId() + ", paymentId=" + this.getPaymentId() + ", endToEndIdentification=" + this.getEndToEndIdentification() + ", instructionIdentification=" + this.getInstructionIdentification() + ", debtorAccount=" + this.getDebtorAccount() + ", ultimateDebtor=" + this.getUltimateDebtor() + ", currency=" + this.getCurrency() + ", amount=" + this.getAmount() + ", creditorAccount=" + this.getCreditorAccount() + ", creditorAgent=" + this.getCreditorAgent() + ", creditorName=" + this.getCreditorName() + ", creditorAddress=" + this.getCreditorAddress() + ", remittanceInformationUnstructured=" + this.getRemittanceInformationUnstructured() + ", remittanceInformationStructured=" + this.getRemittanceInformationStructured() + ", requestedExecutionDate=" + this.getRequestedExecutionDate() + ", requestedExecutionTime=" + this.getRequestedExecutionTime() + ", ultimateCreditor=" + this.getUltimateCreditor() + ", purposeCode=" + this.getPurposeCode() + ", startDate=" + this.getStartDate() + ", executionRule=" + this.getExecutionRule() + ", endDate=" + this.getEndDate() + ", frequency=" + this.getFrequency() + ", dayOfExecution=" + this.getDayOfExecution() + ", batchBookingPreferred=" + this.getBatchBookingPreferred() + ")";
    }
}

