/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.aspsp.profile.service.AspspProfileService;
import de.adorsys.psd2.consent.domain.payment.PisAuthorization;
import de.adorsys.psd2.consent.domain.payment.PisCommonPaymentData;
import de.adorsys.psd2.consent.repository.PisCommonPaymentDataRepository;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import java.beans.ConstructorProperties;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.IterableUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PisCommonPaymentConfirmationExpirationService {
    private final PisCommonPaymentDataRepository pisCommonPaymentDataRepository;
    private final AspspProfileService aspspProfileService;

    @Transactional
    public PisCommonPaymentData checkAndUpdatePaymentDataOnConfirmationExpiration(PisCommonPaymentData pisCommonPaymentData) {
        if (this.isPaymentDataOnConfirmationExpired(pisCommonPaymentData)) {
            return this.updatePaymentDataOnConfirmationExpiration(pisCommonPaymentData);
        }
        return pisCommonPaymentData;
    }

    public boolean isPaymentDataOnConfirmationExpired(PisCommonPaymentData pisCommonPaymentData) {
        long expirationPeriodMs = this.aspspProfileService.getAspspSettings().getNotConfirmedPaymentExpirationPeriodMs();
        return pisCommonPaymentData != null && pisCommonPaymentData.isConfirmationExpired(expirationPeriodMs);
    }

    @Transactional
    public PisCommonPaymentData updatePaymentDataOnConfirmationExpiration(PisCommonPaymentData pisCommonPaymentData) {
        pisCommonPaymentData.setTransactionStatus(TransactionStatus.RJCT);
        pisCommonPaymentData.getAuthorizations().forEach(this::failAuthorisation);
        return (PisCommonPaymentData)this.pisCommonPaymentDataRepository.save(pisCommonPaymentData);
    }

    @Transactional
    public List<PisCommonPaymentData> updatePaymentDataListOnConfirmationExpiration(List<PisCommonPaymentData> pisCommonPaymentDataList) {
        return IterableUtils.toList((Iterable)this.pisCommonPaymentDataRepository.saveAll(this.obsoletePaymentDataList(pisCommonPaymentDataList)));
    }

    private void failAuthorisation(PisAuthorization authorisation) {
        authorisation.setScaStatus(ScaStatus.FAILED);
        authorisation.setRedirectUrlExpirationTimestamp(OffsetDateTime.now());
    }

    private List<PisCommonPaymentData> obsoletePaymentDataList(List<PisCommonPaymentData> pisCommonPaymentDataList) {
        return pisCommonPaymentDataList.stream().map(this::obsoletePaymentData).collect(Collectors.toList());
    }

    private PisCommonPaymentData obsoletePaymentData(PisCommonPaymentData pisCommonPaymentData) {
        pisCommonPaymentData.setTransactionStatus(TransactionStatus.RJCT);
        pisCommonPaymentData.getAuthorizations().forEach(auth -> auth.setScaStatus(ScaStatus.FAILED));
        return pisCommonPaymentData;
    }

    @ConstructorProperties(value={"pisCommonPaymentDataRepository", "aspspProfileService"})
    public PisCommonPaymentConfirmationExpirationService(PisCommonPaymentDataRepository pisCommonPaymentDataRepository, AspspProfileService aspspProfileService) {
        this.pisCommonPaymentDataRepository = pisCommonPaymentDataRepository;
        this.aspspProfileService = aspspProfileService;
    }
}

