/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.mapper;

import de.adorsys.psd2.consent.aspsp.api.piis.CreatePiisConsentRequest;
import de.adorsys.psd2.consent.domain.piis.PiisConsentEntity;
import de.adorsys.psd2.consent.service.mapper.AccountReferenceMapper;
import de.adorsys.psd2.consent.service.mapper.PsuDataMapper;
import de.adorsys.psd2.consent.service.mapper.TppInfoMapper;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.piis.PiisConsent;
import de.adorsys.psd2.xs2a.core.piis.PiisConsentTppAccessType;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import java.beans.ConstructorProperties;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class PiisConsentMapper {
    private final PsuDataMapper psuDataMapper;
    private final TppInfoMapper tppInfoMapper;
    private final AccountReferenceMapper accountReferenceMapper;

    public PiisConsent mapToPiisConsent(PiisConsentEntity piisConsentEntity) {
        return new PiisConsent(piisConsentEntity.getExternalId(), piisConsentEntity.isRecurringIndicator(), piisConsentEntity.getRequestDateTime(), piisConsentEntity.getLastActionDate(), piisConsentEntity.getExpireDate(), this.psuDataMapper.mapToPsuIdData(piisConsentEntity.getPsuData()), this.tppInfoMapper.mapToTppInfo(piisConsentEntity.getTppInfo()), piisConsentEntity.getConsentStatus(), this.accountReferenceMapper.mapToAccountReferenceEntity(piisConsentEntity.getAccount()), piisConsentEntity.getTppAccessType(), piisConsentEntity.getAllowedFrequencyPerDay(), piisConsentEntity.getCreationTimestamp(), piisConsentEntity.getInstanceId(), piisConsentEntity.getCardNumber(), piisConsentEntity.getCardExpiryDate(), piisConsentEntity.getCardInformation(), piisConsentEntity.getRegistrationInformation(), piisConsentEntity.getStatusChangeTimestamp(), piisConsentEntity.getTppAuthorisationNumber());
    }

    public List<PiisConsent> mapToPiisConsentList(List<PiisConsentEntity> consentEntities) {
        return consentEntities.stream().map(this::mapToPiisConsent).collect(Collectors.toList());
    }

    public PiisConsentEntity mapToPiisConsentEntity(PsuIdData psuIdData, CreatePiisConsentRequest request) {
        PiisConsentEntity consent = new PiisConsentEntity();
        consent.setExternalId(UUID.randomUUID().toString());
        consent.setConsentStatus(ConsentStatus.VALID);
        consent.setRequestDateTime(OffsetDateTime.now());
        consent.setExpireDate(request.getValidUntil());
        consent.setPsuData(this.psuDataMapper.mapToPsuData(psuIdData));
        consent.setTppInfo(this.tppInfoMapper.mapToTppInfoEntity(request.getTppInfo()));
        consent.setAccount(this.accountReferenceMapper.mapToAccountReferenceEntity(request.getAccount()));
        consent.setTppAccessType(this.getAccessType(request));
        consent.setAllowedFrequencyPerDay(request.getAllowedFrequencyPerDay());
        consent.setCardNumber(request.getCardNumber());
        consent.setCardExpiryDate(request.getCardExpiryDate());
        consent.setCardInformation(request.getCardInformation());
        consent.setRegistrationInformation(request.getRegistrationInformation());
        consent.setTppAuthorisationNumber(request.getTppAuthorisationNumber());
        return consent;
    }

    @NotNull
    private PiisConsentTppAccessType getAccessType(CreatePiisConsentRequest request) {
        return request.getTppInfo() != null || StringUtils.isNotBlank((CharSequence)request.getTppAuthorisationNumber()) ? PiisConsentTppAccessType.SINGLE_TPP : PiisConsentTppAccessType.ALL_TPP;
    }

    @ConstructorProperties(value={"psuDataMapper", "tppInfoMapper", "accountReferenceMapper"})
    public PiisConsentMapper(PsuDataMapper psuDataMapper, TppInfoMapper tppInfoMapper, AccountReferenceMapper accountReferenceMapper) {
        this.psuDataMapper = psuDataMapper;
        this.tppInfoMapper = tppInfoMapper;
        this.accountReferenceMapper = accountReferenceMapper;
    }
}

