/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.aspsp.profile.service.AspspProfileService;
import de.adorsys.psd2.consent.api.CmsScaMethod;
import de.adorsys.psd2.consent.api.ais.AisConsentAuthorizationRequest;
import de.adorsys.psd2.consent.api.ais.AisConsentAuthorizationResponse;
import de.adorsys.psd2.consent.api.ais.CreateAisConsentAuthorizationResponse;
import de.adorsys.psd2.consent.api.service.AisConsentAuthorisationService;
import de.adorsys.psd2.consent.domain.PsuData;
import de.adorsys.psd2.consent.domain.ScaMethod;
import de.adorsys.psd2.consent.domain.account.AisConsent;
import de.adorsys.psd2.consent.domain.account.AisConsentAuthorization;
import de.adorsys.psd2.consent.repository.AisConsentAuthorisationRepository;
import de.adorsys.psd2.consent.repository.AisConsentRepository;
import de.adorsys.psd2.consent.service.AisConsentConfirmationExpirationService;
import de.adorsys.psd2.consent.service.mapper.AisConsentMapper;
import de.adorsys.psd2.consent.service.mapper.PsuDataMapper;
import de.adorsys.psd2.consent.service.mapper.ScaMethodMapper;
import de.adorsys.psd2.consent.service.psu.CmsPsuService;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.AuthorisationScaApproachResponse;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import java.beans.ConstructorProperties;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class AisAuthorisationServiceInternal
implements AisConsentAuthorisationService {
    private static final Logger log = LoggerFactory.getLogger(AisAuthorisationServiceInternal.class);
    private final AisConsentRepository aisConsentRepository;
    private final AisConsentAuthorisationRepository aisConsentAuthorisationRepository;
    private final AisConsentMapper consentMapper;
    private final PsuDataMapper psuDataMapper;
    private final AspspProfileService aspspProfileService;
    private final AisConsentConfirmationExpirationService aisConsentConfirmationExpirationService;
    private final ScaMethodMapper scaMethodMapper;
    private final CmsPsuService cmsPsuService;

    @Transactional
    public Optional<CreateAisConsentAuthorizationResponse> createAuthorizationWithResponse(String consentId, AisConsentAuthorizationRequest request) {
        return this.aisConsentRepository.findByExternalId(consentId).filter(con -> !con.getConsentStatus().isFinalisedStatus()).map(aisConsent -> {
            this.closePreviousAuthorisationsByPsu(aisConsent.getAuthorizations(), request.getPsuData());
            AisConsentAuthorization newAuthorisation = this.saveNewAuthorization((AisConsent)aisConsent, request);
            return new CreateAisConsentAuthorizationResponse(newAuthorisation.getExternalId(), newAuthorisation.getScaStatus());
        });
    }

    public Optional<AisConsentAuthorizationResponse> getAccountConsentAuthorizationById(String authorizationId, String consentId) {
        boolean consentPresent = this.aisConsentRepository.findByExternalId(consentId).filter(c -> !c.getConsentStatus().isFinalisedStatus()).isPresent();
        if (consentPresent) {
            return this.aisConsentAuthorisationRepository.findByExternalId(authorizationId).map(this.consentMapper::mapToAisConsentAuthorizationResponse);
        }
        log.info("Consent ID: [{}], Authorisation ID: [{}]. Get account consent authorisation failed, because consent is not found", (Object)consentId, (Object)authorizationId);
        return Optional.empty();
    }

    public Optional<List<String>> getAuthorisationsByConsentId(String consentId) {
        return this.aisConsentRepository.findByExternalId(consentId).map(cst -> cst.getAuthorizations().stream().map(AisConsentAuthorization::getExternalId).collect(Collectors.toList()));
    }

    @Transactional
    public Optional<ScaStatus> getAuthorisationScaStatus(String consentId, String authorisationId) {
        Optional<AisConsent> consentOptional = this.aisConsentRepository.findByExternalId(consentId);
        if (!consentOptional.isPresent()) {
            log.info("Consent ID: [{}], Authorisation ID: [{}]. Get authorisation SCA status failed, because consent is not found", (Object)consentId, (Object)authorisationId);
            return Optional.empty();
        }
        AisConsent consent = consentOptional.get();
        if (this.aisConsentConfirmationExpirationService.isConsentConfirmationExpired(consent)) {
            this.aisConsentConfirmationExpirationService.updateConsentOnConfirmationExpiration(consent);
            log.info("Consent ID: [{}], Authorisation ID: [{}]. Get authorisation SCA status failed, because consent is expired", (Object)consentId, (Object)authorisationId);
            return Optional.of(ScaStatus.FAILED);
        }
        Optional<AisConsentAuthorization> authorisation = this.findAuthorisationInConsent(authorisationId, consent);
        return authorisation.map(AisConsentAuthorization::getScaStatus);
    }

    public boolean isAuthenticationMethodDecoupled(String authorisationId, String authenticationMethodId) {
        Optional<AisConsentAuthorization> authorisationOptional = this.aisConsentAuthorisationRepository.findByExternalId(authorisationId);
        return authorisationOptional.map(a -> a.getAvailableScaMethods().stream().filter(m -> Objects.equals(m.getAuthenticationMethodId(), authenticationMethodId)).anyMatch(ScaMethod::isDecoupled)).orElseGet(() -> {
            log.info("Authorisation ID: [{}]. Get authorisation method decoupled status failed, because consent authorisation is not found", (Object)authorisationId);
            return false;
        });
    }

    @Transactional
    public boolean saveAuthenticationMethods(String authorisationId, List<CmsScaMethod> methods) {
        Optional<AisConsentAuthorization> authorisationOptional = this.aisConsentAuthorisationRepository.findByExternalId(authorisationId);
        if (!authorisationOptional.isPresent()) {
            log.info(" Authorisation ID: [{}]. Save authentication methods failed, because authorisation is not found", (Object)authorisationId);
            return false;
        }
        AisConsentAuthorization authorisation = authorisationOptional.get();
        authorisation.setAvailableScaMethods(this.scaMethodMapper.mapToScaMethods(methods));
        this.aisConsentAuthorisationRepository.save(authorisation);
        return true;
    }

    @Transactional
    public boolean updateConsentAuthorization(String authorisationId, AisConsentAuthorizationRequest request) {
        Optional<AisConsentAuthorization> aisConsentAuthorizationOptional = this.aisConsentAuthorisationRepository.findByExternalId(authorisationId);
        if (!aisConsentAuthorizationOptional.isPresent()) {
            log.info("Authorisation ID: [{}]. Update consent authorisation failed, because consent authorisation is not found", (Object)authorisationId);
            return false;
        }
        AisConsentAuthorization aisConsentAuthorisation = aisConsentAuthorizationOptional.get();
        PsuIdData psuDataFromRequest = request.getPsuData();
        this.closePreviousAuthorisationsByPsu(aisConsentAuthorisation, psuDataFromRequest);
        if (aisConsentAuthorisation.getScaStatus().isFinalisedStatus()) {
            log.info("Authorisation ID: [{}], SCA status: [{}]. Update consent authorisation failed, because consent authorisation has finalised status", (Object)authorisationId, (Object)aisConsentAuthorisation.getScaStatus().getValue());
            return false;
        }
        if (ScaStatus.RECEIVED == aisConsentAuthorisation.getScaStatus()) {
            PsuData psuRequest = this.psuDataMapper.mapToPsuData(psuDataFromRequest);
            if (!this.cmsPsuService.isPsuDataRequestCorrect(psuRequest, aisConsentAuthorisation.getPsuData())) {
                log.info("Authorisation ID: [{}], SCA status: [{}]. Update consent authorisation failed, because psu data request does not match stored psu data", (Object)authorisationId, (Object)aisConsentAuthorisation.getScaStatus().getValue());
                return false;
            }
            AisConsent aisConsent = aisConsentAuthorisation.getConsent();
            Optional<PsuData> psuDataOptional = this.cmsPsuService.definePsuDataForAuthorisation(psuRequest, aisConsent.getPsuDataList());
            if (psuDataOptional.isPresent()) {
                PsuData psuData = psuDataOptional.get();
                aisConsent.setPsuDataList(this.cmsPsuService.enrichPsuData(psuData, aisConsent.getPsuDataList()));
                aisConsentAuthorisation.setPsuData(psuData);
            }
            aisConsentAuthorisation.setConsent(aisConsent);
        }
        if (ScaStatus.SCAMETHODSELECTED == request.getScaStatus()) {
            aisConsentAuthorisation.setAuthenticationMethodId(request.getAuthenticationMethodId());
        }
        aisConsentAuthorisation.setScaStatus(request.getScaStatus());
        aisConsentAuthorisation = (AisConsentAuthorization)this.aisConsentAuthorisationRepository.save(aisConsentAuthorisation);
        return aisConsentAuthorisation.getExternalId() != null;
    }

    @Transactional
    public boolean updateScaApproach(String authorisationId, ScaApproach scaApproach) {
        Optional<AisConsentAuthorization> aisConsentAuthorisationOptional = this.aisConsentAuthorisationRepository.findByExternalId(authorisationId);
        if (!aisConsentAuthorisationOptional.isPresent()) {
            log.info("Authorisation ID: [{}]. Update SCA approach failed, because consent authorisation is not found", (Object)authorisationId);
            return false;
        }
        AisConsentAuthorization aisConsentAuthorisation = aisConsentAuthorisationOptional.get();
        aisConsentAuthorisation.setScaApproach(scaApproach);
        this.aisConsentAuthorisationRepository.save(aisConsentAuthorisation);
        return true;
    }

    public Optional<AuthorisationScaApproachResponse> getAuthorisationScaApproach(String authorisationID) {
        return this.aisConsentAuthorisationRepository.findByExternalId(authorisationID).map(a -> new AuthorisationScaApproachResponse(a.getScaApproach()));
    }

    private AisConsentAuthorization saveNewAuthorization(AisConsent aisConsent, AisConsentAuthorizationRequest request) {
        AisConsentAuthorization consentAuthorization = new AisConsentAuthorization();
        Optional<PsuData> psuDataOptional = this.cmsPsuService.definePsuDataForAuthorisation(this.psuDataMapper.mapToPsuData(request.getPsuData()), aisConsent.getPsuDataList());
        ScaStatus scaStatus = request.getScaStatus();
        if (psuDataOptional.isPresent()) {
            PsuData psuData = psuDataOptional.get();
            aisConsent.setPsuDataList(this.cmsPsuService.enrichPsuData(psuData, aisConsent.getPsuDataList()));
            consentAuthorization.setPsuData(psuData);
            scaStatus = ScaStatus.PSUIDENTIFIED;
        }
        consentAuthorization.setExternalId(UUID.randomUUID().toString());
        consentAuthorization.setConsent(aisConsent);
        consentAuthorization.setScaStatus(scaStatus);
        consentAuthorization.setRedirectUrlExpirationTimestamp(OffsetDateTime.now().plus(this.aspspProfileService.getAspspSettings().getRedirectUrlExpirationTimeMs(), ChronoUnit.MILLIS));
        consentAuthorization.setAuthorisationExpirationTimestamp(OffsetDateTime.now().plus(this.aspspProfileService.getAspspSettings().getAuthorisationExpirationTimeMs(), ChronoUnit.MILLIS));
        consentAuthorization.setScaApproach(request.getScaApproach());
        return (AisConsentAuthorization)this.aisConsentAuthorisationRepository.save(consentAuthorization);
    }

    private Optional<AisConsentAuthorization> findAuthorisationInConsent(String authorisationId, AisConsent consent) {
        return consent.getAuthorizations().stream().filter(auth -> auth.getExternalId().equals(authorisationId)).findFirst();
    }

    private void closePreviousAuthorisationsByPsu(AisConsentAuthorization authorisation, PsuIdData psuIdData) {
        AisConsent consent = authorisation.getConsent();
        List<AisConsentAuthorization> previousAuthorisations = consent.getAuthorizations().stream().filter(a -> !a.getExternalId().equals(authorisation.getExternalId())).collect(Collectors.toList());
        this.closePreviousAuthorisationsByPsu(previousAuthorisations, psuIdData);
    }

    private void closePreviousAuthorisationsByPsu(List<AisConsentAuthorization> authorisations, PsuIdData psuIdData) {
        PsuData psuData = this.psuDataMapper.mapToPsuData(psuIdData);
        if (Objects.isNull(psuData) || psuData.isEmpty()) {
            log.info("Close previous authorisations by psu failed, because psuData is not allowed");
            return;
        }
        List aisConsentAuthorisations = authorisations.stream().filter(auth -> Objects.nonNull(auth.getPsuData()) && auth.getPsuData().contentEquals(psuData)).map(this::makeAuthorisationFailedAndExpired).collect(Collectors.toList());
        this.aisConsentAuthorisationRepository.saveAll(aisConsentAuthorisations);
    }

    private AisConsentAuthorization makeAuthorisationFailedAndExpired(AisConsentAuthorization auth) {
        auth.setScaStatus(ScaStatus.FAILED);
        auth.setRedirectUrlExpirationTimestamp(OffsetDateTime.now());
        return auth;
    }

    @ConstructorProperties(value={"aisConsentRepository", "aisConsentAuthorisationRepository", "consentMapper", "psuDataMapper", "aspspProfileService", "aisConsentConfirmationExpirationService", "scaMethodMapper", "cmsPsuService"})
    public AisAuthorisationServiceInternal(AisConsentRepository aisConsentRepository, AisConsentAuthorisationRepository aisConsentAuthorisationRepository, AisConsentMapper consentMapper, PsuDataMapper psuDataMapper, AspspProfileService aspspProfileService, AisConsentConfirmationExpirationService aisConsentConfirmationExpirationService, ScaMethodMapper scaMethodMapper, CmsPsuService cmsPsuService) {
        this.aisConsentRepository = aisConsentRepository;
        this.aisConsentAuthorisationRepository = aisConsentAuthorisationRepository;
        this.consentMapper = consentMapper;
        this.psuDataMapper = psuDataMapper;
        this.aspspProfileService = aspspProfileService;
        this.aisConsentConfirmationExpirationService = aisConsentConfirmationExpirationService;
        this.scaMethodMapper = scaMethodMapper;
        this.cmsPsuService = cmsPsuService;
    }
}

