/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.psu;

import de.adorsys.psd2.consent.domain.PsuData;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CmsPsuService {
    private static final Logger log = LoggerFactory.getLogger(CmsPsuService.class);

    public Optional<PsuData> definePsuDataForAuthorisation(PsuData psuDataForCheck, List<PsuData> psuDataList) {
        return Optional.ofNullable(psuDataForCheck).map(psuData -> psuDataList.stream().filter(psu -> StringUtils.equals((CharSequence)psu.getPsuId(), (CharSequence)psuData.getPsuId())).findFirst().orElse(psuDataForCheck));
    }

    public List<PsuData> enrichPsuData(PsuData psuData, List<PsuData> psuDataList) {
        if (this.isPsuDataNew(psuData, psuDataList)) {
            psuDataList.add(psuData);
        }
        return psuDataList;
    }

    public boolean isPsuDataNew(PsuData psuData, List<PsuData> psuDataList) {
        return Optional.ofNullable(psuData).map(psu -> !this.isPsuDataInList((PsuData)psu, psuDataList)).orElseGet(() -> {
            log.info("Check is psu data a new instance failed - psuData is null");
            return false;
        });
    }

    public boolean isPsuDataListEqual(@NotNull List<PsuData> psuDataList, @NotNull List<PsuData> anotherPsuDataList) {
        if (psuDataList.size() != anotherPsuDataList.size()) {
            return false;
        }
        return psuDataList.stream().allMatch(psuData -> this.isPsuDataInList((PsuData)psuData, anotherPsuDataList));
    }

    public boolean isPsuDataRequestCorrect(PsuData psuRequest, PsuData psuAuth) {
        return Optional.ofNullable(psuRequest).map(psu -> psuAuth == null || psu.contentEquals(psuAuth)).orElse(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isPsuDataInList(PsuData psuData, List<PsuData> psuDataList) {
        if (!psuData.isNotEmpty()) return false;
        if (!psuDataList.stream().anyMatch(psuData::contentEquals)) return false;
        return true;
    }
}

