/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.aspsp.api.tpp.CmsAspspTppService;
import de.adorsys.psd2.consent.domain.TppInfoEntity;
import de.adorsys.psd2.consent.domain.TppStopListEntity;
import de.adorsys.psd2.consent.repository.TppInfoRepository;
import de.adorsys.psd2.consent.repository.TppStopListRepository;
import de.adorsys.psd2.consent.service.mapper.TppInfoMapper;
import de.adorsys.psd2.consent.service.mapper.TppStopListMapper;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.core.tpp.TppStopListRecord;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CmsAspspTppServiceInternal
implements CmsAspspTppService {
    private final TppStopListRepository stopListRepository;
    private final TppStopListMapper tppStopListMapper;
    private final TppInfoRepository tppInfoRepository;
    private final TppInfoMapper tppInfoMapper;

    @NotNull
    public Optional<TppStopListRecord> getTppStopListRecord(@NotNull String tppAuthorisationNumber, @NotNull String nationalAuthorityId, @NotNull String instanceId) {
        Optional<TppStopListEntity> stopListEntityOptional = this.stopListRepository.findByTppAuthorisationNumberAndNationalAuthorityIdAndInstanceId(tppAuthorisationNumber, nationalAuthorityId, instanceId);
        return stopListEntityOptional.map(this.tppStopListMapper::mapToTppStopListRecord);
    }

    @Transactional
    public boolean blockTpp(@NotNull String tppAuthorisationNumber, @NotNull String nationalAuthorityId, @NotNull String instanceId, @Nullable Duration lockPeriod) {
        Optional<TppStopListEntity> stopListEntityOptional = this.stopListRepository.findByTppAuthorisationNumberAndNationalAuthorityIdAndInstanceId(tppAuthorisationNumber, nationalAuthorityId, instanceId);
        TppStopListEntity entityToBeBlocked = stopListEntityOptional.orElseGet(() -> {
            TppStopListEntity entity = new TppStopListEntity();
            entity.setTppAuthorisationNumber(tppAuthorisationNumber);
            entity.setNationalAuthorityId(nationalAuthorityId);
            return entity;
        });
        entityToBeBlocked.block(lockPeriod);
        this.stopListRepository.save(entityToBeBlocked);
        return true;
    }

    @Transactional
    public boolean unblockTpp(@NotNull String tppAuthorisationNumber, @NotNull String nationalAuthorityId, @NotNull String instanceId) {
        Optional<TppStopListEntity> stopListEntityOptional = this.stopListRepository.findByTppAuthorisationNumberAndNationalAuthorityIdAndInstanceId(tppAuthorisationNumber, nationalAuthorityId, instanceId);
        if (stopListEntityOptional.isPresent()) {
            TppStopListEntity entityToBeUnblocked = stopListEntityOptional.get();
            entityToBeUnblocked.unblock();
            this.stopListRepository.save(entityToBeUnblocked);
        }
        return true;
    }

    @NotNull
    public Optional<TppInfo> getTppInfo(@NotNull String tppAuthorisationNumber, @NotNull String nationalAuthorityId, @NotNull String instanceId) {
        Optional<TppInfoEntity> tppInfoEntityOptional = this.tppInfoRepository.findFirstByAuthorisationNumberAndAuthorityIdAndInstanceId(tppAuthorisationNumber, nationalAuthorityId, instanceId);
        return tppInfoEntityOptional.map(this.tppInfoMapper::mapToTppInfo);
    }

    @ConstructorProperties(value={"stopListRepository", "tppStopListMapper", "tppInfoRepository", "tppInfoMapper"})
    public CmsAspspTppServiceInternal(TppStopListRepository stopListRepository, TppStopListMapper tppStopListMapper, TppInfoRepository tppInfoRepository, TppInfoMapper tppInfoMapper) {
        this.stopListRepository = stopListRepository;
        this.tppStopListMapper = tppStopListMapper;
        this.tppInfoRepository = tppInfoRepository;
        this.tppInfoMapper = tppInfoMapper;
    }
}

