/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.repository.specification;

import de.adorsys.psd2.consent.domain.event.EventEntity;
import de.adorsys.psd2.consent.repository.specification.EntityAttributeSpecificationProvider;
import java.io.Serializable;
import java.time.OffsetDateTime;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.domain.Specifications;
import org.springframework.stereotype.Service;

@Service
public class EventEntitySpecification {
    public Specification<EventEntity> byPeriodAndInstanceId(OffsetDateTime start, OffsetDateTime end, String instanceId) {
        return Specifications.where(this.eventPeriodSpecification(start, end)).and(EntityAttributeSpecificationProvider.provideSpecificationForEntityAttribute("instanceId", instanceId));
    }

    public Specification<EventEntity> byPeriodAndConsentIdAndInstanceId(OffsetDateTime start, OffsetDateTime end, String consentId, String instanceId) {
        return Specifications.where(this.eventPeriodSpecification(start, end)).and(EntityAttributeSpecificationProvider.provideSpecificationForEntityAttribute("instanceId", instanceId)).and(EntityAttributeSpecificationProvider.provideSpecificationForEntityAttribute("consentId", consentId));
    }

    public Specification<EventEntity> byPeriodAndPaymentIdAndInstanceId(OffsetDateTime start, OffsetDateTime end, String paymentId, String instanceId) {
        return Specifications.where(this.eventPeriodSpecification(start, end)).and(EntityAttributeSpecificationProvider.provideSpecificationForEntityAttribute("instanceId", instanceId)).and(EntityAttributeSpecificationProvider.provideSpecificationForEntityAttribute("paymentId", paymentId));
    }

    private Specification<EventEntity> eventPeriodSpecification(OffsetDateTime start, OffsetDateTime end) {
        return (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
            criteriaQuery.orderBy(new Order[]{criteriaBuilder.asc((Expression)root.get("timestamp"))});
            return criteriaBuilder.between((Expression)root.get("timestamp"), (Comparable)start, (Comparable)end);
        };
    }
}

