/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.domain.account;

import de.adorsys.psd2.consent.domain.InstanceDependableEntity;
import de.adorsys.psd2.consent.domain.PsuData;
import de.adorsys.psd2.consent.domain.ScaMethod;
import de.adorsys.psd2.consent.domain.account.AisConsent;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;

@Entity(name="ais_consent_authorization")
public class AisConsentAuthorization
extends InstanceDependableEntity {
    @Id
    @Column(name="authorization_id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ais_consent_authorization_generator")
    @SequenceGenerator(name="ais_consent_authorization_generator", sequenceName="ais_consent_auth_id_seq", allocationSize=1)
    private Long id;
    @Column(name="external_id", nullable=false)
    private String externalId;
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="psu_id")
    private PsuData psuData;
    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="consent_id", nullable=false)
    private AisConsent consent;
    @Column(name="sca_status", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private ScaStatus scaStatus;
    @Column(name="authentication_method_id")
    private String authenticationMethodId;
    @Column(name="sca_authentication_data")
    private String scaAuthenticationData;
    @Column(name="expiration_timestamp")
    private OffsetDateTime redirectUrlExpirationTimestamp;
    @ElementCollection
    @CollectionTable(name="ais_available_sca_method", joinColumns={@JoinColumn(name="authorisation_id")})
    private List<ScaMethod> availableScaMethods = new ArrayList<ScaMethod>();
    @Column(name="sca_approach", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private ScaApproach scaApproach;

    public boolean isExpired() {
        return this.redirectUrlExpirationTimestamp.isBefore(OffsetDateTime.now());
    }

    public boolean isNotExpired() {
        return !this.isExpired();
    }

    public Long getId() {
        return this.id;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public PsuData getPsuData() {
        return this.psuData;
    }

    public AisConsent getConsent() {
        return this.consent;
    }

    public ScaStatus getScaStatus() {
        return this.scaStatus;
    }

    public String getAuthenticationMethodId() {
        return this.authenticationMethodId;
    }

    public String getScaAuthenticationData() {
        return this.scaAuthenticationData;
    }

    public OffsetDateTime getRedirectUrlExpirationTimestamp() {
        return this.redirectUrlExpirationTimestamp;
    }

    public List<ScaMethod> getAvailableScaMethods() {
        return this.availableScaMethods;
    }

    public ScaApproach getScaApproach() {
        return this.scaApproach;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public void setPsuData(PsuData psuData) {
        this.psuData = psuData;
    }

    public void setConsent(AisConsent consent) {
        this.consent = consent;
    }

    public void setScaStatus(ScaStatus scaStatus) {
        this.scaStatus = scaStatus;
    }

    public void setAuthenticationMethodId(String authenticationMethodId) {
        this.authenticationMethodId = authenticationMethodId;
    }

    public void setScaAuthenticationData(String scaAuthenticationData) {
        this.scaAuthenticationData = scaAuthenticationData;
    }

    public void setRedirectUrlExpirationTimestamp(OffsetDateTime redirectUrlExpirationTimestamp) {
        this.redirectUrlExpirationTimestamp = redirectUrlExpirationTimestamp;
    }

    public void setAvailableScaMethods(List<ScaMethod> availableScaMethods) {
        this.availableScaMethods = availableScaMethods;
    }

    public void setScaApproach(ScaApproach scaApproach) {
        this.scaApproach = scaApproach;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AisConsentAuthorization)) {
            return false;
        }
        AisConsentAuthorization other = (AisConsentAuthorization)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$externalId = this.getExternalId();
        String other$externalId = other.getExternalId();
        if (this$externalId == null ? other$externalId != null : !this$externalId.equals(other$externalId)) {
            return false;
        }
        PsuData this$psuData = this.getPsuData();
        PsuData other$psuData = other.getPsuData();
        if (this$psuData == null ? other$psuData != null : !((Object)this$psuData).equals(other$psuData)) {
            return false;
        }
        AisConsent this$consent = this.getConsent();
        AisConsent other$consent = other.getConsent();
        if (this$consent == null ? other$consent != null : !((Object)this$consent).equals(other$consent)) {
            return false;
        }
        ScaStatus this$scaStatus = this.getScaStatus();
        ScaStatus other$scaStatus = other.getScaStatus();
        if (this$scaStatus == null ? other$scaStatus != null : !this$scaStatus.equals(other$scaStatus)) {
            return false;
        }
        String this$authenticationMethodId = this.getAuthenticationMethodId();
        String other$authenticationMethodId = other.getAuthenticationMethodId();
        if (this$authenticationMethodId == null ? other$authenticationMethodId != null : !this$authenticationMethodId.equals(other$authenticationMethodId)) {
            return false;
        }
        String this$scaAuthenticationData = this.getScaAuthenticationData();
        String other$scaAuthenticationData = other.getScaAuthenticationData();
        if (this$scaAuthenticationData == null ? other$scaAuthenticationData != null : !this$scaAuthenticationData.equals(other$scaAuthenticationData)) {
            return false;
        }
        OffsetDateTime this$redirectUrlExpirationTimestamp = this.getRedirectUrlExpirationTimestamp();
        OffsetDateTime other$redirectUrlExpirationTimestamp = other.getRedirectUrlExpirationTimestamp();
        if (this$redirectUrlExpirationTimestamp == null ? other$redirectUrlExpirationTimestamp != null : !((Object)this$redirectUrlExpirationTimestamp).equals(other$redirectUrlExpirationTimestamp)) {
            return false;
        }
        List<ScaMethod> this$availableScaMethods = this.getAvailableScaMethods();
        List<ScaMethod> other$availableScaMethods = other.getAvailableScaMethods();
        if (this$availableScaMethods == null ? other$availableScaMethods != null : !((Object)this$availableScaMethods).equals(other$availableScaMethods)) {
            return false;
        }
        ScaApproach this$scaApproach = this.getScaApproach();
        ScaApproach other$scaApproach = other.getScaApproach();
        return !(this$scaApproach == null ? other$scaApproach != null : !this$scaApproach.equals(other$scaApproach));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AisConsentAuthorization;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : $externalId.hashCode());
        PsuData $psuData = this.getPsuData();
        result = result * 59 + ($psuData == null ? 43 : ((Object)$psuData).hashCode());
        AisConsent $consent = this.getConsent();
        result = result * 59 + ($consent == null ? 43 : ((Object)$consent).hashCode());
        ScaStatus $scaStatus = this.getScaStatus();
        result = result * 59 + ($scaStatus == null ? 43 : $scaStatus.hashCode());
        String $authenticationMethodId = this.getAuthenticationMethodId();
        result = result * 59 + ($authenticationMethodId == null ? 43 : $authenticationMethodId.hashCode());
        String $scaAuthenticationData = this.getScaAuthenticationData();
        result = result * 59 + ($scaAuthenticationData == null ? 43 : $scaAuthenticationData.hashCode());
        OffsetDateTime $redirectUrlExpirationTimestamp = this.getRedirectUrlExpirationTimestamp();
        result = result * 59 + ($redirectUrlExpirationTimestamp == null ? 43 : ((Object)$redirectUrlExpirationTimestamp).hashCode());
        List<ScaMethod> $availableScaMethods = this.getAvailableScaMethods();
        result = result * 59 + ($availableScaMethods == null ? 43 : ((Object)$availableScaMethods).hashCode());
        ScaApproach $scaApproach = this.getScaApproach();
        result = result * 59 + ($scaApproach == null ? 43 : $scaApproach.hashCode());
        return result;
    }

    public String toString() {
        return "AisConsentAuthorization(id=" + this.getId() + ", externalId=" + this.getExternalId() + ", psuData=" + this.getPsuData() + ", consent=" + this.getConsent() + ", scaStatus=" + this.getScaStatus() + ", authenticationMethodId=" + this.getAuthenticationMethodId() + ", scaAuthenticationData=" + this.getScaAuthenticationData() + ", redirectUrlExpirationTimestamp=" + this.getRedirectUrlExpirationTimestamp() + ", availableScaMethods=" + this.getAvailableScaMethods() + ", scaApproach=" + this.getScaApproach() + ")";
    }
}

