/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.domain;

import de.adorsys.psd2.consent.domain.InstanceDependableEntity;
import de.adorsys.psd2.xs2a.core.tpp.TppStatus;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Optional;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import org.jetbrains.annotations.Nullable;

@Entity(name="tpp_stop_list")
public class TppStopListEntity
extends InstanceDependableEntity {
    @Id
    @Column(name="id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="tpp_stop_list_generator")
    @SequenceGenerator(name="tpp_stop_list_generator", sequenceName="tpp_stop_list_id_seq", allocationSize=1)
    private Long id;
    @Column(name="tpp_authorisation_number", nullable=false)
    private String tppAuthorisationNumber;
    @Column(name="authority_id", nullable=false)
    private String nationalAuthorityId;
    @Column(name="status", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private TppStatus status;
    @Column(name="expiration_timestamp")
    private OffsetDateTime blockingExpirationTimestamp;

    public void block(@Nullable Duration lockPeriod) {
        this.status = TppStatus.BLOCKED;
        this.blockingExpirationTimestamp = lockPeriod != null ? OffsetDateTime.now().plus(lockPeriod) : null;
    }

    public void unblock() {
        this.status = TppStatus.ENABLED;
        this.blockingExpirationTimestamp = null;
    }

    public boolean isBlocked() {
        return this.status == TppStatus.BLOCKED;
    }

    public boolean isBlockingExpired() {
        return Optional.ofNullable(this.blockingExpirationTimestamp).map(timestamp -> timestamp.isBefore(OffsetDateTime.now())).orElse(false);
    }

    public Long getId() {
        return this.id;
    }

    public String getTppAuthorisationNumber() {
        return this.tppAuthorisationNumber;
    }

    public String getNationalAuthorityId() {
        return this.nationalAuthorityId;
    }

    public TppStatus getStatus() {
        return this.status;
    }

    public OffsetDateTime getBlockingExpirationTimestamp() {
        return this.blockingExpirationTimestamp;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setTppAuthorisationNumber(String tppAuthorisationNumber) {
        this.tppAuthorisationNumber = tppAuthorisationNumber;
    }

    public void setNationalAuthorityId(String nationalAuthorityId) {
        this.nationalAuthorityId = nationalAuthorityId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TppStopListEntity)) {
            return false;
        }
        TppStopListEntity other = (TppStopListEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$tppAuthorisationNumber = this.getTppAuthorisationNumber();
        String other$tppAuthorisationNumber = other.getTppAuthorisationNumber();
        if (this$tppAuthorisationNumber == null ? other$tppAuthorisationNumber != null : !this$tppAuthorisationNumber.equals(other$tppAuthorisationNumber)) {
            return false;
        }
        String this$nationalAuthorityId = this.getNationalAuthorityId();
        String other$nationalAuthorityId = other.getNationalAuthorityId();
        if (this$nationalAuthorityId == null ? other$nationalAuthorityId != null : !this$nationalAuthorityId.equals(other$nationalAuthorityId)) {
            return false;
        }
        TppStatus this$status = this.getStatus();
        TppStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        OffsetDateTime this$blockingExpirationTimestamp = this.getBlockingExpirationTimestamp();
        OffsetDateTime other$blockingExpirationTimestamp = other.getBlockingExpirationTimestamp();
        return !(this$blockingExpirationTimestamp == null ? other$blockingExpirationTimestamp != null : !((Object)this$blockingExpirationTimestamp).equals(other$blockingExpirationTimestamp));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TppStopListEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $tppAuthorisationNumber = this.getTppAuthorisationNumber();
        result = result * 59 + ($tppAuthorisationNumber == null ? 43 : $tppAuthorisationNumber.hashCode());
        String $nationalAuthorityId = this.getNationalAuthorityId();
        result = result * 59 + ($nationalAuthorityId == null ? 43 : $nationalAuthorityId.hashCode());
        TppStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        OffsetDateTime $blockingExpirationTimestamp = this.getBlockingExpirationTimestamp();
        result = result * 59 + ($blockingExpirationTimestamp == null ? 43 : ((Object)$blockingExpirationTimestamp).hashCode());
        return result;
    }

    public String toString() {
        return "TppStopListEntity(id=" + this.getId() + ", tppAuthorisationNumber=" + this.getTppAuthorisationNumber() + ", nationalAuthorityId=" + this.getNationalAuthorityId() + ", status=" + this.getStatus() + ", blockingExpirationTimestamp=" + this.getBlockingExpirationTimestamp() + ")";
    }

    @ConstructorProperties(value={"id", "tppAuthorisationNumber", "nationalAuthorityId", "status", "blockingExpirationTimestamp"})
    public TppStopListEntity(Long id, String tppAuthorisationNumber, String nationalAuthorityId, TppStatus status, OffsetDateTime blockingExpirationTimestamp) {
        this.id = id;
        this.tppAuthorisationNumber = tppAuthorisationNumber;
        this.nationalAuthorityId = nationalAuthorityId;
        this.status = status;
        this.blockingExpirationTimestamp = blockingExpirationTimestamp;
    }

    public TppStopListEntity() {
    }
}

