/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.api.service.EventService;
import de.adorsys.psd2.consent.domain.event.EventEntity;
import de.adorsys.psd2.consent.repository.EventRepository;
import de.adorsys.psd2.consent.service.mapper.EventMapper;
import de.adorsys.psd2.xs2a.core.event.Event;
import java.beans.ConstructorProperties;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EventServiceInternal
implements EventService {
    private final EventMapper eventMapper;
    private final EventRepository eventRepository;

    @Transactional
    public boolean recordEvent(@NotNull Event event) {
        EventEntity eventEntity = this.eventMapper.mapToEventEntity(event);
        EventEntity savedEventEntity = (EventEntity)this.eventRepository.save(eventEntity);
        return savedEventEntity.getId() != null;
    }

    @ConstructorProperties(value={"eventMapper", "eventRepository"})
    public EventServiceInternal(EventMapper eventMapper, EventRepository eventRepository) {
        this.eventMapper = eventMapper;
        this.eventRepository = eventRepository;
    }
}

