/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.mapper;

import de.adorsys.psd2.consent.domain.PsuDataEmbeddable;
import de.adorsys.psd2.consent.domain.event.EventEntity;
import de.adorsys.psd2.consent.service.JsonConverterService;
import de.adorsys.psd2.xs2a.core.event.Event;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class EventMapper {
    private final JsonConverterService jsonConverterService;

    public List<Event> mapToEventList(@NotNull List<EventEntity> eventEntities) {
        return eventEntities.stream().map(this::mapToEvent).collect(Collectors.toList());
    }

    public EventEntity mapToEventEntity(@NotNull Event event) {
        EventEntity eventEntity = new EventEntity();
        eventEntity.setTimestamp(event.getTimestamp());
        eventEntity.setConsentId(event.getConsentId());
        eventEntity.setPaymentId(event.getPaymentId());
        byte[] payload = this.jsonConverterService.toJsonBytes(event.getPayload()).orElse(null);
        eventEntity.setPayload(payload);
        eventEntity.setEventOrigin(event.getEventOrigin());
        eventEntity.setEventType(event.getEventType());
        eventEntity.setPsuData(this.mapToPsuDataEmbeddable(event.getPsuIdData()));
        eventEntity.setTppAuthorisationNumber(event.getTppAuthorisationNumber());
        eventEntity.setXRequestId(event.getXRequestId() != null ? event.getXRequestId().toString() : null);
        return eventEntity;
    }

    private Event mapToEvent(@NotNull EventEntity eventEntity) {
        Object payload = this.jsonConverterService.toObject(eventEntity.getPayload(), Object.class).orElse(null);
        return Event.builder().timestamp(eventEntity.getTimestamp()).consentId(eventEntity.getConsentId()).paymentId(eventEntity.getPaymentId()).payload(payload).eventOrigin(eventEntity.getEventOrigin()).eventType(eventEntity.getEventType()).instanceId(eventEntity.getInstanceId()).psuIdData(this.mapToPsuIdData(eventEntity.getPsuData())).tppAuthorisationNumber(eventEntity.getTppAuthorisationNumber()).xRequestId(eventEntity.getXRequestId() != null ? UUID.fromString(eventEntity.getXRequestId()) : null).build();
    }

    private PsuDataEmbeddable mapToPsuDataEmbeddable(PsuIdData psuIdData) {
        return Optional.ofNullable(psuIdData).map(psu -> new PsuDataEmbeddable(psu.getPsuId(), psu.getPsuIdType(), psu.getPsuCorporateId(), psu.getPsuCorporateIdType())).orElse(null);
    }

    private PsuIdData mapToPsuIdData(PsuDataEmbeddable psuDataEmbeddable) {
        return Optional.ofNullable(psuDataEmbeddable).map(psu -> new PsuIdData(psu.getPsuId(), psu.getPsuIdType(), psu.getPsuCorporateId(), psu.getPsuCorporateIdType())).orElse(null);
    }

    @ConstructorProperties(value={"jsonConverterService"})
    public EventMapper(JsonConverterService jsonConverterService) {
        this.jsonConverterService = jsonConverterService;
    }
}

