/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;

@Entity(name="crypto_algorithm")
@ApiModel(description="Crypto Algorithm", value="CryptoAlgorithm")
public class CryptoAlgorithm {
    @Id
    @Column(name="algorithm_id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="crypto_algorithm_generator")
    @SequenceGenerator(name="crypto_algorithm_generator", sequenceName="crypto_algorithm_id_seq", allocationSize=1)
    private Long id;
    @ApiModelProperty(value="External Id", required=true, example="nML0IXWdMa")
    @Column(name="external_id", nullable=false, unique=true)
    private String externalId;
    @ApiModelProperty(value="Algorithm", required=true, example="AES/GCM/NoPadding")
    @Column(name="algorithm", nullable=false)
    private String algorithm;
    @ApiModelProperty(value="Version", required=true, example="1")
    @Column(name="version", nullable=false)
    private String version;

    public Long getId() {
        return this.id;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getVersion() {
        return this.version;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CryptoAlgorithm)) {
            return false;
        }
        CryptoAlgorithm other = (CryptoAlgorithm)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$externalId = this.getExternalId();
        String other$externalId = other.getExternalId();
        if (this$externalId == null ? other$externalId != null : !this$externalId.equals(other$externalId)) {
            return false;
        }
        String this$algorithm = this.getAlgorithm();
        String other$algorithm = other.getAlgorithm();
        if (this$algorithm == null ? other$algorithm != null : !this$algorithm.equals(other$algorithm)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CryptoAlgorithm;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : $externalId.hashCode());
        String $algorithm = this.getAlgorithm();
        result = result * 59 + ($algorithm == null ? 43 : $algorithm.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }

    public String toString() {
        return "CryptoAlgorithm(id=" + this.getId() + ", externalId=" + this.getExternalId() + ", algorithm=" + this.getAlgorithm() + ", version=" + this.getVersion() + ")";
    }
}

