/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.security.provider;

import de.adorsys.psd2.consent.service.security.DecryptedData;
import de.adorsys.psd2.consent.service.security.EncryptedData;
import de.adorsys.psd2.consent.service.security.provider.CryptoProvider;
import de.adorsys.psd2.consent.service.security.provider.CryptoProviderAlgorithmVersion;
import java.security.GeneralSecurityException;
import java.util.Optional;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AesEcbCryptoProviderImpl
implements CryptoProvider {
    private static final Logger log = LoggerFactory.getLogger(AesEcbCryptoProviderImpl.class);
    private static final String METHOD = "AES/ECB/PKCS5Padding";

    @Override
    public Optional<EncryptedData> encryptData(byte[] data, String password) {
        try {
            SecretKey secretKey = this.getSecretKey(password);
            Cipher cipher = Cipher.getInstance(METHOD);
            cipher.init(1, secretKey);
            byte[] encryptedData = cipher.doFinal(data);
            return Optional.of(new EncryptedData(encryptedData));
        }
        catch (GeneralSecurityException e) {
            log.info("Error encryption data: {}", (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public Optional<DecryptedData> decryptData(byte[] data, String password) {
        try {
            SecretKey secretKey = this.getSecretKey(password);
            Cipher cipher = Cipher.getInstance(METHOD);
            cipher.init(2, secretKey);
            byte[] decryptedData = cipher.doFinal(data);
            return Optional.of(new DecryptedData(decryptedData));
        }
        catch (BadPaddingException e) {
            log.info("Error decryption data. Wrong password");
        }
        catch (GeneralSecurityException e) {
            log.info("Error decryption data: {}", (Throwable)e);
        }
        return Optional.empty();
    }

    @Override
    public CryptoProviderAlgorithmVersion getAlgorithmVersion() {
        return new CryptoProviderAlgorithmVersion("bS6p6XvTWI", METHOD);
    }
}

