/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.repository.specification;

import de.adorsys.psd2.consent.repository.specification.EntityAttributeSpecificationProvider;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Optional;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.domain.Specifications;

public abstract class GenericSpecification {
    public <T> Specification<T> byPsuDataInListAndInstanceId(PsuIdData psuIdData, String instanceId) {
        return this.byPsuDataAndInstanceId(psuIdData, instanceId, "psuDataList");
    }

    public <T> Specification<T> byPsuDataAndInstanceId(PsuIdData psuIdData, String instanceId) {
        return this.byPsuDataAndInstanceId(psuIdData, instanceId, "psuData");
    }

    protected <T> Specification<T> byPsuIdDataInList(@Nullable PsuIdData psuIdData) {
        return this.byPsuIdData(psuIdData, "psuDataList");
    }

    protected <T> Specification<T> byPsuIdData(@Nullable PsuIdData psuIdData) {
        return this.byPsuIdData(psuIdData, "psuData");
    }

    private <T> Specification<T> byPsuDataAndInstanceId(PsuIdData psuIdData, String instanceId, String psuAttribute) {
        Specification<T> psuSpecification = this.byPsuIdData(psuIdData, psuAttribute);
        return Specifications.where(psuSpecification).and(EntityAttributeSpecificationProvider.provideSpecificationForEntityAttribute("instanceId", instanceId));
    }

    private <T> Specification<T> byPsuIdData(@Nullable PsuIdData psuIdData, String psuAttribute) {
        if (psuIdData == null) {
            return null;
        }
        return (Specification & Serializable)(root, query, cb) -> {
            Join psuDataJoin = root.join(psuAttribute);
            return Specifications.where(EntityAttributeSpecificationProvider.provideSpecificationForJoinedEntityAttribute(psuDataJoin, "psuId", psuIdData.getPsuId())).and(EntityAttributeSpecificationProvider.provideSpecificationForJoinedEntityAttribute(psuDataJoin, "psuIdType", psuIdData.getPsuIdType())).and(EntityAttributeSpecificationProvider.provideSpecificationForJoinedEntityAttribute(psuDataJoin, "psuCorporateId", psuIdData.getPsuCorporateId())).and(EntityAttributeSpecificationProvider.provideSpecificationForJoinedEntityAttribute(psuDataJoin, "psuCorporateIdType", psuIdData.getPsuCorporateIdType())).toPredicate(root, query, cb);
        };
    }

    protected <T> Specification<T> byTppAuthorisationNumber(@Nullable String tppAuthorisationNumber) {
        return (Specification & Serializable)(root, query, cb) -> {
            Join tppInfoJoin = root.join("tppInfo");
            return EntityAttributeSpecificationProvider.provideSpecificationForJoinedEntityAttribute(tppInfoJoin, "authorisationNumber", tppAuthorisationNumber).toPredicate(root, query, cb);
        };
    }

    protected <T> Specification<T> byTppInfo(TppInfo tppInfo) {
        return (Specification & Serializable)(root, query, cb) -> {
            Join tppInfoJoin = root.join("tppInfo");
            return Specifications.where(EntityAttributeSpecificationProvider.provideSpecificationForJoinedEntityAttribute(tppInfoJoin, "authorisationNumber", tppInfo.getAuthorisationNumber())).and(EntityAttributeSpecificationProvider.provideSpecificationForJoinedEntityAttribute(tppInfoJoin, "authorityId", tppInfo.getAuthorityId())).toPredicate(root, query, cb);
        };
    }

    protected <T> Specification<T> byAspspAccountId(@Nullable String aspspAccountId) {
        return EntityAttributeSpecificationProvider.provideSpecificationForEntityAttribute("aspspAccountId", aspspAccountId);
    }

    protected <T> Specification<T> byInstanceId(@Nullable String instanceId) {
        return EntityAttributeSpecificationProvider.provideSpecificationForEntityAttribute("instanceId", instanceId);
    }

    protected <T> Specification<T> byCreationTimestamp(@Nullable LocalDate start, @Nullable LocalDate end) {
        ZoneOffset currentOffset = OffsetDateTime.now().getOffset();
        OffsetDateTime startOffsetDateTime = Optional.ofNullable(start).map(odt -> OffsetDateTime.of(odt, LocalTime.MIN, currentOffset)).orElse(null);
        OffsetDateTime endOffsetDateTime = Optional.ofNullable(end).map(odt -> OffsetDateTime.of(odt, LocalTime.MAX, currentOffset)).orElse(null);
        return this.byCreationTimestamp(startOffsetDateTime, endOffsetDateTime);
    }

    protected <T> Specification<T> byCreationTimestamp(@Nullable OffsetDateTime start, @Nullable OffsetDateTime end) {
        return (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
            criteriaQuery.orderBy(new Order[]{criteriaBuilder.asc((Expression)root.get("creationTimestamp"))});
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (start != null) {
                predicates.add(criteriaBuilder.greaterThanOrEqualTo((Expression)root.get("creationTimestamp"), (Comparable)start));
            }
            if (end != null) {
                predicates.add(criteriaBuilder.lessThanOrEqualTo((Expression)root.get("creationTimestamp"), (Comparable)end));
            }
            return criteriaBuilder.and(predicates.toArray(new Predicate[0]));
        };
    }
}

