/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.domain.account;

import de.adorsys.psd2.consent.domain.account.AisConsent;
import java.time.LocalDate;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Version;

@Entity(name="ais_consent_usage")
public class AisConsentUsage {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ais_consent_usage_generator")
    @SequenceGenerator(name="ais_consent_usage_generator", sequenceName="ais_consent_usage_id_seq", allocationSize=1)
    private Long id;
    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="consent_id", nullable=false)
    private AisConsent consent;
    @Column(name="usage_date", nullable=false)
    private LocalDate usageDate;
    @Column(name="usage_amount", nullable=false)
    private int usage;
    @Version
    @Column(name="version")
    private long version;

    public AisConsentUsage(AisConsent consent) {
        this.usageDate = LocalDate.now();
        this.consent = consent;
    }

    public Long getId() {
        return this.id;
    }

    public AisConsent getConsent() {
        return this.consent;
    }

    public LocalDate getUsageDate() {
        return this.usageDate;
    }

    public int getUsage() {
        return this.usage;
    }

    public long getVersion() {
        return this.version;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setConsent(AisConsent consent) {
        this.consent = consent;
    }

    public void setUsageDate(LocalDate usageDate) {
        this.usageDate = usageDate;
    }

    public void setUsage(int usage) {
        this.usage = usage;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AisConsentUsage)) {
            return false;
        }
        AisConsentUsage other = (AisConsentUsage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        AisConsent this$consent = this.getConsent();
        AisConsent other$consent = other.getConsent();
        if (this$consent == null ? other$consent != null : !((Object)this$consent).equals(other$consent)) {
            return false;
        }
        LocalDate this$usageDate = this.getUsageDate();
        LocalDate other$usageDate = other.getUsageDate();
        if (this$usageDate == null ? other$usageDate != null : !((Object)this$usageDate).equals(other$usageDate)) {
            return false;
        }
        if (this.getUsage() != other.getUsage()) {
            return false;
        }
        return this.getVersion() == other.getVersion();
    }

    protected boolean canEqual(Object other) {
        return other instanceof AisConsentUsage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        AisConsent $consent = this.getConsent();
        result = result * 59 + ($consent == null ? 43 : ((Object)$consent).hashCode());
        LocalDate $usageDate = this.getUsageDate();
        result = result * 59 + ($usageDate == null ? 43 : ((Object)$usageDate).hashCode());
        result = result * 59 + this.getUsage();
        long $version = this.getVersion();
        result = result * 59 + (int)($version >>> 32 ^ $version);
        return result;
    }

    public String toString() {
        return "AisConsentUsage(id=" + this.getId() + ", consent=" + this.getConsent() + ", usageDate=" + this.getUsageDate() + ", usage=" + this.getUsage() + ", version=" + this.getVersion() + ")";
    }

    public AisConsentUsage() {
    }
}

