/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.mapper;

import de.adorsys.psd2.consent.domain.PsuData;
import de.adorsys.psd2.consent.domain.TppInfoEntity;
import de.adorsys.psd2.consent.domain.account.AisConsent;
import de.adorsys.psd2.consent.domain.account.AisConsentAuthorization;
import de.adorsys.psd2.consent.domain.payment.PisAuthorization;
import de.adorsys.psd2.consent.psu.api.CmsPsuAuthorisation;
import de.adorsys.psd2.consent.service.mapper.CmsPsuAuthorisationMapper;
import org.springframework.stereotype.Component;

@Component
public class CmsPsuAuthorisationMapperImpl
implements CmsPsuAuthorisationMapper {
    @Override
    public CmsPsuAuthorisation mapToCmsPsuAuthorisationPis(PisAuthorization pisAuthorization) {
        if (pisAuthorization == null) {
            return null;
        }
        CmsPsuAuthorisation cmsPsuAuthorisation = new CmsPsuAuthorisation();
        cmsPsuAuthorisation.setAuthorisationId(pisAuthorization.getExternalId());
        cmsPsuAuthorisation.setAuthorisationType(pisAuthorization.getAuthorizationType());
        cmsPsuAuthorisation.setPsuId(this.pisAuthorizationPsuDataPsuId(pisAuthorization));
        cmsPsuAuthorisation.setScaStatus(pisAuthorization.getScaStatus());
        cmsPsuAuthorisation.setRedirectUrlExpirationTimestamp(pisAuthorization.getRedirectUrlExpirationTimestamp());
        cmsPsuAuthorisation.setAuthorisationExpirationTimestamp(pisAuthorization.getAuthorisationExpirationTimestamp());
        cmsPsuAuthorisation.setScaApproach(pisAuthorization.getScaApproach());
        this.mapToCmsPsuAuthorisationPisAfterMapping(pisAuthorization, cmsPsuAuthorisation);
        return cmsPsuAuthorisation;
    }

    @Override
    public CmsPsuAuthorisation mapToCmsPsuAuthorisationAis(AisConsentAuthorization consentAuthorization) {
        if (consentAuthorization == null) {
            return null;
        }
        CmsPsuAuthorisation cmsPsuAuthorisation = new CmsPsuAuthorisation();
        cmsPsuAuthorisation.setAuthorisationId(consentAuthorization.getExternalId());
        cmsPsuAuthorisation.setTppOkRedirectUri(this.consentAuthorizationConsentTppInfoRedirectUri(consentAuthorization));
        cmsPsuAuthorisation.setTppNokRedirectUri(this.consentAuthorizationConsentTppInfoNokRedirectUri(consentAuthorization));
        cmsPsuAuthorisation.setPsuId(this.consentAuthorizationPsuDataPsuId(consentAuthorization));
        cmsPsuAuthorisation.setScaStatus(consentAuthorization.getScaStatus());
        cmsPsuAuthorisation.setRedirectUrlExpirationTimestamp(consentAuthorization.getRedirectUrlExpirationTimestamp());
        cmsPsuAuthorisation.setAuthorisationExpirationTimestamp(consentAuthorization.getAuthorisationExpirationTimestamp());
        cmsPsuAuthorisation.setScaApproach(consentAuthorization.getScaApproach());
        return cmsPsuAuthorisation;
    }

    private String pisAuthorizationPsuDataPsuId(PisAuthorization pisAuthorization) {
        if (pisAuthorization == null) {
            return null;
        }
        PsuData psuData = pisAuthorization.getPsuData();
        if (psuData == null) {
            return null;
        }
        String psuId = psuData.getPsuId();
        if (psuId == null) {
            return null;
        }
        return psuId;
    }

    private String consentAuthorizationConsentTppInfoRedirectUri(AisConsentAuthorization aisConsentAuthorization) {
        if (aisConsentAuthorization == null) {
            return null;
        }
        AisConsent consent = aisConsentAuthorization.getConsent();
        if (consent == null) {
            return null;
        }
        TppInfoEntity tppInfo = consent.getTppInfo();
        if (tppInfo == null) {
            return null;
        }
        String redirectUri = tppInfo.getRedirectUri();
        if (redirectUri == null) {
            return null;
        }
        return redirectUri;
    }

    private String consentAuthorizationConsentTppInfoNokRedirectUri(AisConsentAuthorization aisConsentAuthorization) {
        if (aisConsentAuthorization == null) {
            return null;
        }
        AisConsent consent = aisConsentAuthorization.getConsent();
        if (consent == null) {
            return null;
        }
        TppInfoEntity tppInfo = consent.getTppInfo();
        if (tppInfo == null) {
            return null;
        }
        String nokRedirectUri = tppInfo.getNokRedirectUri();
        if (nokRedirectUri == null) {
            return null;
        }
        return nokRedirectUri;
    }

    private String consentAuthorizationPsuDataPsuId(AisConsentAuthorization aisConsentAuthorization) {
        if (aisConsentAuthorization == null) {
            return null;
        }
        PsuData psuData = aisConsentAuthorization.getPsuData();
        if (psuData == null) {
            return null;
        }
        String psuId = psuData.getPsuId();
        if (psuId == null) {
            return null;
        }
        return psuId;
    }
}

