/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.aspsp.profile.service.AspspProfileService;
import de.adorsys.psd2.consent.domain.account.AisConsent;
import de.adorsys.psd2.consent.repository.AisConsentRepository;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.IterableUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AisConsentConfirmationExpirationService {
    private static final Logger log = LoggerFactory.getLogger(AisConsentConfirmationExpirationService.class);
    private final AisConsentRepository aisConsentRepository;
    private final AspspProfileService aspspProfileService;

    @Transactional
    public AisConsent checkAndUpdateOnConfirmationExpiration(AisConsent consent) {
        if (this.isConsentConfirmationExpired(consent)) {
            log.info("Consent ID: [{}]. Consent is expired", (Object)consent.getExternalId());
            return this.updateConsentOnConfirmationExpiration(consent);
        }
        return consent;
    }

    public boolean isConsentConfirmationExpired(AisConsent consent) {
        long expirationPeriodMs = this.aspspProfileService.getAspspSettings().getNotConfirmedConsentExpirationPeriodMs();
        return consent != null && consent.isConfirmationExpired(expirationPeriodMs);
    }

    public boolean isConsentExpiredOrFinalised(AisConsent consent) {
        return consent != null && !consent.getConsentStatus().isFinalisedStatus() && consent.isStatusNotExpired() && (consent.isExpiredByDate() || consent.isNonReccuringAlreadyUsed());
    }

    @Transactional
    public void expireConsent(AisConsent consent) {
        consent.setConsentStatus(ConsentStatus.EXPIRED);
        consent.setExpireDate(LocalDate.now());
        consent.setLastActionDate(LocalDate.now());
        this.aisConsentRepository.save(consent);
    }

    @Transactional
    public AisConsent updateConsentOnConfirmationExpiration(AisConsent consent) {
        return (AisConsent)this.aisConsentRepository.save(this.obsoleteConsent(consent));
    }

    @Transactional
    public List<AisConsent> updateConsentListOnConfirmationExpiration(List<AisConsent> consents) {
        return IterableUtils.toList((Iterable)this.aisConsentRepository.saveAll(this.obsoleteConsentList(consents)));
    }

    private List<AisConsent> obsoleteConsentList(List<AisConsent> consents) {
        return consents.stream().map(this::obsoleteConsent).collect(Collectors.toList());
    }

    private AisConsent obsoleteConsent(AisConsent consent) {
        consent.setConsentStatus(ConsentStatus.EXPIRED);
        consent.getAuthorizations().forEach(auth -> auth.setScaStatus(ScaStatus.FAILED));
        consent.setLastActionDate(LocalDate.now());
        return consent;
    }

    @ConstructorProperties(value={"aisConsentRepository", "aspspProfileService"})
    public AisConsentConfirmationExpirationService(AisConsentRepository aisConsentRepository, AspspProfileService aspspProfileService) {
        this.aisConsentRepository = aisConsentRepository;
        this.aspspProfileService = aspspProfileService;
    }
}

