/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.repository.specification;

import de.adorsys.psd2.consent.domain.piis.PiisConsentEntity;
import de.adorsys.psd2.consent.repository.specification.EntityAttributeSpecificationProvider;
import de.adorsys.psd2.consent.repository.specification.GenericSpecification;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.core.profile.AccountReferenceSelector;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Currency;
import javax.persistence.criteria.Join;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.domain.Specifications;
import org.springframework.stereotype.Service;

@Service
public class PiisConsentEntitySpecification
extends GenericSpecification {
    public Specification<PiisConsentEntity> byConsentIdAndInstanceId(String consentId, String instanceId) {
        return Specifications.where(EntityAttributeSpecificationProvider.provideSpecificationForEntityAttribute("instanceId", instanceId)).and(EntityAttributeSpecificationProvider.provideSpecificationForEntityAttribute("externalId", consentId));
    }

    public Specification<PiisConsentEntity> byTppIdAndCreationPeriodAndPsuIdDataAndInstanceId(@NotNull String tppAuthorisationNumber, @Nullable LocalDate createDateFrom, @Nullable LocalDate createDateTo, @Nullable PsuIdData psuIdData, @Nullable String instanceId) {
        return Specifications.where(this.byTppAuthorisationNumber(tppAuthorisationNumber)).and(this.byCreationTimestamp(createDateFrom, createDateTo)).and(this.byPsuIdData(psuIdData)).and(this.byInstanceId(instanceId));
    }

    public Specification<PiisConsentEntity> byPsuIdDataAndCreationPeriodAndInstanceId(@NotNull PsuIdData psuIdData, @Nullable LocalDate createDateFrom, @Nullable LocalDate createDateTo, @Nullable String instanceId) {
        return Specifications.where(this.byPsuIdData(psuIdData)).and(this.byCreationTimestamp(createDateFrom, createDateTo)).and(this.byInstanceId(instanceId));
    }

    public Specification<PiisConsentEntity> byAspspAccountIdAndCreationPeriodAndInstanceId(@NotNull String aspspAccountId, @Nullable LocalDate createDateFrom, @Nullable LocalDate createDateTo, @Nullable String instanceId) {
        return Specifications.where(this.byAspspAccountIdInAccount(aspspAccountId)).and(this.byCreationTimestamp(createDateFrom, createDateTo)).and(this.byInstanceId(instanceId));
    }

    public Specification<PiisConsentEntity> byPsuIdDataAndTppInfoAndAccountReference(@NotNull PsuIdData psuIdData, @NotNull String tppAuthorisationNumber, @NotNull AccountReference accountReference) {
        return Specifications.where(this.byPsuIdData(psuIdData)).and(this.byTppAuthorisationNumber(tppAuthorisationNumber)).and(this.byAccountReference(accountReference));
    }

    public Specification<PiisConsentEntity> byPsuIdDataAndTppInfoAndAccountReferenceWithoutJoin(@NotNull PsuIdData psuIdData, @NotNull String tppAuthorisationNumber, @NotNull AccountReference accountReference) {
        return Specification.where(this.byPsuIdData(psuIdData)).and(this.byTppAuthorisationNumberWithoutJoin(tppAuthorisationNumber)).and(this.byAccountReference(accountReference));
    }

    public Specification<PiisConsentEntity> byCurrencyAndAccountReferenceSelector(@Nullable Currency currency, @NotNull AccountReferenceSelector selector) {
        return (Specification & Serializable)(root, query, cb) -> {
            Join accountJoin = root.join("account");
            return Specification.where(EntityAttributeSpecificationProvider.provideSpecificationForJoinedEntityAttribute(accountJoin, selector.getAccountReferenceType().getValue(), selector.getAccountValue())).and(EntityAttributeSpecificationProvider.provideSpecificationForJoinedEntityAttribute(accountJoin, "currency", currency)).toPredicate(root, query, cb);
        };
    }

    public Specification<PiisConsentEntity> byAccountReferenceSelector(@NotNull AccountReferenceSelector selector) {
        return (Specification & Serializable)(root, query, cb) -> {
            Join accountJoin = root.join("account");
            return Specification.where(EntityAttributeSpecificationProvider.provideSpecificationForJoinedEntityAttribute(accountJoin, selector.getAccountReferenceType().getValue(), selector.getAccountValue())).toPredicate(root, query, cb);
        };
    }

    private Specification<PiisConsentEntity> byAspspAccountIdInAccount(@Nullable String aspspAccountId) {
        return (Specification & Serializable)(root, query, cb) -> {
            Join accountJoin = root.join("account");
            return EntityAttributeSpecificationProvider.provideSpecificationForJoinedEntityAttribute(accountJoin, "aspspAccountId", aspspAccountId).toPredicate(root, query, cb);
        };
    }

    private Specification<PiisConsentEntity> byAccountReference(@NotNull AccountReference accountReference) {
        return (Specification & Serializable)(root, query, cb) -> {
            AccountReferenceSelector selector = accountReference.getUsedAccountReferenceSelector();
            Join accountJoin = root.join("account");
            Specifications specifications = Specifications.where(EntityAttributeSpecificationProvider.provideSpecificationForJoinedEntityAttribute(accountJoin, selector.getAccountReferenceType().getValue(), selector.getAccountValue()));
            if (accountReference.getCurrency() != null) {
                specifications.and(EntityAttributeSpecificationProvider.provideSpecificationForJoinedEntityAttribute(accountJoin, "currency", accountReference.getCurrency()));
            }
            return specifications.toPredicate(root, query, cb);
        };
    }
}

