/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.psu;

import de.adorsys.psd2.consent.api.CmsAuthorisationType;
import de.adorsys.psd2.consent.api.ais.AisAccountAccess;
import de.adorsys.psd2.consent.api.ais.AisAccountConsent;
import de.adorsys.psd2.consent.api.service.AisConsentService;
import de.adorsys.psd2.consent.domain.PsuData;
import de.adorsys.psd2.consent.domain.account.AisConsent;
import de.adorsys.psd2.consent.domain.account.AisConsentAuthorization;
import de.adorsys.psd2.consent.domain.account.AspspAccountAccess;
import de.adorsys.psd2.consent.psu.api.CmsPsuAisService;
import de.adorsys.psd2.consent.psu.api.ais.CmsAisConsentAccessRequest;
import de.adorsys.psd2.consent.psu.api.ais.CmsAisConsentResponse;
import de.adorsys.psd2.consent.psu.api.ais.CmsAisPsuDataAuthorisation;
import de.adorsys.psd2.consent.repository.AisConsentAuthorisationRepository;
import de.adorsys.psd2.consent.repository.AisConsentRepository;
import de.adorsys.psd2.consent.repository.specification.AisConsentAuthorizationSpecification;
import de.adorsys.psd2.consent.repository.specification.AisConsentSpecification;
import de.adorsys.psd2.consent.service.AisConsentRequestTypeService;
import de.adorsys.psd2.consent.service.AisConsentUsageService;
import de.adorsys.psd2.consent.service.mapper.AisConsentMapper;
import de.adorsys.psd2.consent.service.mapper.PsuDataMapper;
import de.adorsys.psd2.consent.service.psu.CmsPsuService;
import de.adorsys.psd2.xs2a.core.ais.AccountAccessType;
import de.adorsys.psd2.xs2a.core.consent.AisConsentRequestType;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.core.tpp.TppRedirectUri;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CmsPsuAisServiceInternal
implements CmsPsuAisService {
    private static final Logger log = LoggerFactory.getLogger(CmsPsuAisServiceInternal.class);
    private final AisConsentRepository aisConsentRepository;
    private final AisConsentMapper consentMapper;
    private final AisConsentAuthorisationRepository aisConsentAuthorisationRepository;
    private final AisConsentAuthorizationSpecification aisConsentAuthorizationSpecification;
    private final AisConsentSpecification aisConsentSpecification;
    private final AisConsentService aisConsentService;
    private final PsuDataMapper psuDataMapper;
    private final AisConsentUsageService aisConsentUsageService;
    private final CmsPsuService cmsPsuService;
    private final AisConsentRequestTypeService aisConsentRequestTypeService;

    @Transactional
    public boolean updatePsuDataInConsent(@NotNull PsuIdData psuIdData, @NotNull String authorisationId, @NotNull String instanceId) {
        AisConsentAuthorization authorisation = (AisConsentAuthorization)this.aisConsentAuthorisationRepository.findOne(this.aisConsentAuthorizationSpecification.byExternalIdAndInstanceId(authorisationId, instanceId));
        return Optional.ofNullable(authorisation).map(auth -> this.updatePsuData((AisConsentAuthorization)auth, psuIdData)).orElseGet(() -> {
            log.info("Authorisation ID [{}], Instance ID: [{}]. Update PSU  in consent failed, because authorisation not found", (Object)instanceId, (Object)authorisationId);
            return false;
        });
    }

    @Transactional
    @NotNull
    public Optional<AisAccountConsent> getConsent(@NotNull PsuIdData psuIdData, @NotNull String consentId, @NotNull String instanceId) {
        return Optional.ofNullable(this.aisConsentRepository.findOne(this.aisConsentSpecification.byConsentIdAndInstanceId(consentId, instanceId))).map(this::checkAndUpdateOnExpiration).map(this.consentMapper::mapToAisAccountConsent);
    }

    @Transactional
    public boolean updateAuthorisationStatus(@NotNull PsuIdData psuIdData, @NotNull String consentId, @NotNull String authorisationId, @NotNull ScaStatus status, @NotNull String instanceId) {
        Optional<AisConsent> actualAisConsent = this.getActualAisConsent(consentId, instanceId);
        if (!actualAisConsent.isPresent()) {
            log.info("Consent ID: [{}]. Update of authorisation status failed, because consent either has finalised status or not found", (Object)consentId);
            return false;
        }
        return Optional.ofNullable(this.aisConsentAuthorisationRepository.findOne(this.aisConsentAuthorizationSpecification.byExternalIdAndInstanceId(authorisationId, instanceId))).map(auth -> this.updateScaStatus(status, (AisConsentAuthorization)auth)).orElseGet(() -> {
            log.info("Authorisation ID [{}], Instance ID: [{}]. Update authorisation status failed, because authorisation not found", (Object)authorisationId, (Object)instanceId);
            return false;
        });
    }

    @Transactional
    public boolean confirmConsent(@NotNull PsuIdData psuIdData, @NotNull String consentId, @NotNull String instanceId) {
        if (this.changeConsentStatus(consentId, ConsentStatus.VALID, instanceId)) {
            this.aisConsentService.findAndTerminateOldConsentsByNewConsentId(consentId);
            return true;
        }
        log.info("Consent ID [{}]. Confirmation of consent failed because consent has finalised status or not found", (Object)consentId);
        return false;
    }

    @Transactional
    public boolean rejectConsent(@NotNull PsuIdData psuIdData, @NotNull String consentId, @NotNull String instanceId) {
        return this.changeConsentStatus(consentId, ConsentStatus.REJECTED, instanceId);
    }

    @NotNull
    public List<AisAccountConsent> getConsentsForPsu(@NotNull PsuIdData psuIdData, @NotNull String instanceId) {
        if (psuIdData.isEmpty()) {
            return Collections.emptyList();
        }
        return this.aisConsentRepository.findAll(this.aisConsentSpecification.byPsuDataInListAndInstanceId(psuIdData, instanceId)).stream().map(this.consentMapper::mapToAisAccountConsent).collect(Collectors.toList());
    }

    @Transactional
    public boolean revokeConsent(@NotNull PsuIdData psuIdData, @NotNull String consentId, @NotNull String instanceId) {
        return this.changeConsentStatus(consentId, ConsentStatus.REVOKED_BY_PSU, instanceId);
    }

    @Transactional
    @NotNull
    public Optional<CmsAisConsentResponse> checkRedirectAndGetConsent(@NotNull String redirectId, @NotNull String instanceId) {
        Optional<AisConsentAuthorization> optionalAuthorisation = Optional.ofNullable(this.aisConsentAuthorisationRepository.findOne(this.aisConsentAuthorizationSpecification.byExternalIdAndInstanceId(redirectId, instanceId))).filter(a -> a.getScaStatus().isNotFinalisedStatus());
        if (optionalAuthorisation.isPresent()) {
            AisConsentAuthorization authorisation = optionalAuthorisation.get();
            if (authorisation.isNotExpired()) {
                return this.createCmsAisConsentResponseFromAisConsent(authorisation.getConsent(), redirectId);
            }
            log.info("Authorisation ID [{}]. Check redirect and get consent failed, because authorisation is expired", (Object)redirectId);
            this.updateAuthorisationOnExpiration(authorisation);
            String tppNokRedirectUri = authorisation.getConsent().getTppInfo().getNokRedirectUri();
            return Optional.of(new CmsAisConsentResponse(tppNokRedirectUri));
        }
        log.info("Authorisation ID [{}]. Check redirect and get consent failed, because authorisation not found or has finalised status", (Object)redirectId);
        return Optional.empty();
    }

    @Transactional
    public boolean updateAccountAccessInConsent(@NotNull String consentId, @NotNull CmsAisConsentAccessRequest accountAccessRequest, @NotNull String instanceId) {
        Optional<AisConsent> aisConsentOptional = this.getActualAisConsent(consentId, instanceId);
        if (aisConsentOptional.isPresent()) {
            return this.updateAccountAccessInConsent(aisConsentOptional.get(), accountAccessRequest);
        }
        log.info("Consent ID [{}]. Update account access in consent failed, because consent not found or has finalised status", (Object)consentId);
        return false;
    }

    public Optional<List<CmsAisPsuDataAuthorisation>> getPsuDataAuthorisations(@NotNull String consentId, @NotNull String instanceId) {
        return this.getActualAisConsent(consentId, instanceId).map(AisConsent::getAuthorizations).map(this::getPsuDataAuthorisations);
    }

    @NotNull
    private List<CmsAisPsuDataAuthorisation> getPsuDataAuthorisations(List<AisConsentAuthorization> authorisations) {
        return authorisations.stream().filter(auth -> Objects.nonNull(auth.getPsuData())).map(auth -> new CmsAisPsuDataAuthorisation(this.psuDataMapper.mapToPsuIdData(auth.getPsuData()), auth.getExternalId(), auth.getScaStatus(), CmsAuthorisationType.CREATED)).collect(Collectors.toList());
    }

    private boolean updateAccountAccessInConsent(AisConsent consent, CmsAisConsentAccessRequest request) {
        AisAccountAccess accountAccess = request.getAccountAccess();
        if (accountAccess == null) {
            log.info("Consent ID [{}]. Update account access in consent failed, because AIS Account Access is null", (Object)consent.getExternalId());
            return false;
        }
        Function<String, AccountAccessType> accountAccessTypeConverter = description -> AccountAccessType.getByDescription((String)description).orElse(null);
        consent.setAllPsd2(accountAccessTypeConverter.apply(accountAccess.getAllPsd2()));
        consent.setAvailableAccounts(accountAccessTypeConverter.apply(accountAccess.getAvailableAccounts()));
        consent.setAvailableAccountsWithBalances(accountAccessTypeConverter.apply(accountAccess.getAvailableAccountsWithBalances()));
        Optional.ofNullable(request.getRecurringIndicator()).ifPresent(consent::setRecurringIndicator);
        Optional.ofNullable(request.getCombinedServiceIndicator()).ifPresent(consent::setCombinedServiceIndicator);
        Set<AspspAccountAccess> aspspAccountAccesses = this.consentMapper.mapAspspAccountAccesses(accountAccess);
        AisConsentRequestType aisConsentRequestType = this.aisConsentRequestTypeService.getRequestTypeFromConsent(consent);
        consent.setAisConsentRequestType(aisConsentRequestType);
        consent.addAspspAccountAccess(aspspAccountAccesses);
        consent.setExpireDate(request.getValidUntil());
        consent.setAllowedFrequencyPerDay(request.getFrequencyPerDay());
        this.aisConsentUsageService.resetUsage(consent);
        this.aisConsentRepository.save(consent);
        return true;
    }

    private boolean changeConsentStatus(String consentId, ConsentStatus status, String instanceId) {
        return Optional.ofNullable(this.aisConsentRepository.findOne(this.aisConsentSpecification.byConsentIdAndInstanceId(consentId, instanceId))).map(con -> this.updateConsentStatus((AisConsent)con, status)).orElseGet(() -> {
            log.info("Consent ID [{}], Instance ID: [{}]. Change consent status failed, because AIS consent not found", (Object)consentId, (Object)instanceId);
            return false;
        });
    }

    private AisConsent checkAndUpdateOnExpiration(AisConsent consent) {
        if (consent != null && consent.isExpiredByDate() && consent.isStatusNotExpired()) {
            consent.setConsentStatus(ConsentStatus.EXPIRED);
            consent.setExpireDate(LocalDate.now());
            consent.setLastActionDate(LocalDate.now());
            this.aisConsentRepository.save(consent);
        } else {
            log.info("Get consent failed in checkAndUpdateOnExpiration method, because consent is null or expired.");
        }
        return consent;
    }

    private Optional<AisConsent> getActualAisConsent(String consentId, String instanceId) {
        return Optional.ofNullable(this.aisConsentRepository.findOne(this.aisConsentSpecification.byConsentIdAndInstanceId(consentId, instanceId))).filter(c -> !c.getConsentStatus().isFinalisedStatus());
    }

    private boolean updateConsentStatus(AisConsent consent, ConsentStatus status) {
        if (consent.getConsentStatus().isFinalisedStatus()) {
            log.info("Consent ID: [{}], Consent status: status [{}]. Confirmation of consent failed in updateConsentStatus method, because consent has finalised status", (Object)consent.getExternalId(), (Object)consent.getConsentStatus().getValue());
            return false;
        }
        consent.setLastActionDate(LocalDate.now());
        consent.setConsentStatus(status);
        return this.aisConsentRepository.save(consent) != null;
    }

    private boolean updatePsuData(AisConsentAuthorization authorisation, PsuIdData psuIdData) {
        PsuData newPsuData = this.psuDataMapper.mapToPsuData(psuIdData);
        if (newPsuData == null || StringUtils.isBlank((CharSequence)newPsuData.getPsuId())) {
            log.info("Authorisation ID : [{}]. Update PSU data in consent failed in updatePsuData method, because newPsuData or psuId in newPsuData is empty or null. ", (Object)authorisation.getId());
            return false;
        }
        Optional<PsuData> optionalPsuData = Optional.ofNullable(authorisation.getPsuData());
        if (optionalPsuData.isPresent()) {
            newPsuData.setId(optionalPsuData.get().getId());
        } else {
            log.info("Authorisation ID [{}]. no psu data available in the authorization.", (Object)authorisation.getId());
            List<PsuData> psuDataList = authorisation.getConsent().getPsuDataList();
            Optional<PsuData> psuDataOptional = this.cmsPsuService.definePsuDataForAuthorisation(newPsuData, psuDataList);
            if (psuDataOptional.isPresent()) {
                newPsuData = psuDataOptional.get();
                authorisation.getConsent().setPsuDataList(this.cmsPsuService.enrichPsuData(newPsuData, psuDataList));
            }
        }
        authorisation.setPsuData(newPsuData);
        this.aisConsentAuthorisationRepository.save(authorisation);
        return true;
    }

    private boolean updateScaStatus(@NotNull ScaStatus status, AisConsentAuthorization authorisation) {
        if (authorisation.getScaStatus().isFinalisedStatus()) {
            log.info("Authorisation ID [{}], SCA status [{}]. Update authorisation status failed in updateScaStatus method because authorisation has finalised status.", (Object)authorisation.getId(), (Object)authorisation.getScaStatus().getValue());
            return false;
        }
        authorisation.setScaStatus(status);
        return this.aisConsentAuthorisationRepository.save(authorisation) != null;
    }

    private void updateAuthorisationOnExpiration(AisConsentAuthorization authorisation) {
        authorisation.setScaStatus(ScaStatus.FAILED);
        this.aisConsentAuthorisationRepository.save(authorisation);
    }

    private Optional<CmsAisConsentResponse> createCmsAisConsentResponseFromAisConsent(AisConsent aisConsent, String redirectId) {
        if (aisConsent == null) {
            log.info("Authorisation ID [{}]. Check redirect and get consent failed in createCmsAisConsentResponseFromAisConsent method, because AIS consent is null");
            return Optional.empty();
        }
        AisAccountConsent aisAccountConsent = this.consentMapper.mapToAisAccountConsent(aisConsent);
        Optional<TppInfo> tppInfoOptional = Optional.ofNullable(aisAccountConsent).map(AisAccountConsent::getTppInfo);
        if (!tppInfoOptional.isPresent()) {
            log.info("Authorisation ID [{}]. Check redirect and get consent failed in createCmsAisConsentResponseFromAisConsent method, because TPP info is not present");
            return Optional.empty();
        }
        Optional<TppRedirectUri> tppRedirectUriOptional = tppInfoOptional.map(TppInfo::getTppRedirectUri);
        String tppOkRedirectUri = null;
        String tppNokRedirectUri = null;
        if (tppRedirectUriOptional.isPresent()) {
            TppRedirectUri tppRedirectUri = tppRedirectUriOptional.get();
            tppOkRedirectUri = tppRedirectUri.getUri();
            tppNokRedirectUri = tppRedirectUri.getNokUri();
        }
        return Optional.of(new CmsAisConsentResponse(aisAccountConsent, redirectId, tppOkRedirectUri, tppNokRedirectUri));
    }

    @ConstructorProperties(value={"aisConsentRepository", "consentMapper", "aisConsentAuthorisationRepository", "aisConsentAuthorizationSpecification", "aisConsentSpecification", "aisConsentService", "psuDataMapper", "aisConsentUsageService", "cmsPsuService", "aisConsentRequestTypeService"})
    public CmsPsuAisServiceInternal(AisConsentRepository aisConsentRepository, AisConsentMapper consentMapper, AisConsentAuthorisationRepository aisConsentAuthorisationRepository, AisConsentAuthorizationSpecification aisConsentAuthorizationSpecification, AisConsentSpecification aisConsentSpecification, AisConsentService aisConsentService, PsuDataMapper psuDataMapper, AisConsentUsageService aisConsentUsageService, CmsPsuService cmsPsuService, AisConsentRequestTypeService aisConsentRequestTypeService) {
        this.aisConsentRepository = aisConsentRepository;
        this.consentMapper = consentMapper;
        this.aisConsentAuthorisationRepository = aisConsentAuthorisationRepository;
        this.aisConsentAuthorizationSpecification = aisConsentAuthorizationSpecification;
        this.aisConsentSpecification = aisConsentSpecification;
        this.aisConsentService = aisConsentService;
        this.psuDataMapper = psuDataMapper;
        this.aisConsentUsageService = aisConsentUsageService;
        this.cmsPsuService = cmsPsuService;
        this.aisConsentRequestTypeService = aisConsentRequestTypeService;
    }
}

