/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.mapper;

import de.adorsys.psd2.consent.api.TypeAccess;
import de.adorsys.psd2.consent.api.ais.AisAccountAccess;
import de.adorsys.psd2.consent.api.ais.AisAccountConsent;
import de.adorsys.psd2.consent.api.ais.AisAccountConsentAuthorisation;
import de.adorsys.psd2.consent.api.ais.AisConsentAuthorizationResponse;
import de.adorsys.psd2.consent.domain.account.AisConsent;
import de.adorsys.psd2.consent.domain.account.AisConsentAuthorization;
import de.adorsys.psd2.consent.domain.account.AspspAccountAccess;
import de.adorsys.psd2.consent.domain.account.TppAccountAccess;
import de.adorsys.psd2.consent.service.AisConsentUsageService;
import de.adorsys.psd2.consent.service.mapper.PsuDataMapper;
import de.adorsys.psd2.consent.service.mapper.TppInfoMapper;
import de.adorsys.psd2.xs2a.core.ais.AccountAccessType;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.core.profile.AccountReferenceSelector;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class AisConsentMapper {
    private final PsuDataMapper psuDataMapper;
    private final TppInfoMapper tppInfoMapper;
    private final AisConsentUsageService aisConsentUsageService;

    public AisAccountConsent mapToAisAccountConsent(AisConsent consent) {
        AisAccountAccess aisAccountAccess = consent.getAspspAccountAccesses().isEmpty() ? this.mapToAisAccountAccess(consent) : this.mapToAspspAisAccountAccess(consent);
        Map<String, Integer> usageCounterMap = this.aisConsentUsageService.getUsageCounterMap(consent);
        return new AisAccountConsent(consent.getExternalId(), aisAccountAccess, consent.isRecurringIndicator(), consent.getExpireDate(), consent.getAllowedFrequencyPerDay(), consent.getLastActionDate(), consent.getConsentStatus(), consent.getAccesses().stream().anyMatch(a -> a.getTypeAccess() == TypeAccess.BALANCE), consent.isTppRedirectPreferred(), consent.getAisConsentRequestType(), this.psuDataMapper.mapToPsuIdDataList(consent.getPsuDataList()), this.tppInfoMapper.mapToTppInfo(consent.getTppInfo()), consent.isMultilevelScaRequired(), this.mapToAisAccountConsentAuthorisation(consent.getAuthorizations()), usageCounterMap, consent.getCreationTimestamp(), consent.getStatusChangeTimestamp());
    }

    public AisAccountConsent mapToInitialAisAccountConsent(AisConsent consent) {
        Map<String, Integer> usageCounterMap = this.aisConsentUsageService.getUsageCounterMap(consent);
        return new AisAccountConsent(consent.getExternalId(), this.mapToAisAccountAccess(consent), consent.isRecurringIndicator(), consent.getExpireDate(), consent.getAllowedFrequencyPerDay(), consent.getLastActionDate(), consent.getConsentStatus(), consent.getAccesses().stream().anyMatch(a -> a.getTypeAccess() == TypeAccess.BALANCE), consent.isTppRedirectPreferred(), consent.getAisConsentRequestType(), this.psuDataMapper.mapToPsuIdDataList(consent.getPsuDataList()), this.tppInfoMapper.mapToTppInfo(consent.getTppInfo()), consent.isMultilevelScaRequired(), this.mapToAisAccountConsentAuthorisation(consent.getAuthorizations()), usageCounterMap, consent.getCreationTimestamp(), consent.getStatusChangeTimestamp());
    }

    public AisConsentAuthorizationResponse mapToAisConsentAuthorizationResponse(AisConsentAuthorization aisConsentAuthorization) {
        return Optional.ofNullable(aisConsentAuthorization).map(conAuth -> {
            AisConsentAuthorizationResponse resp = new AisConsentAuthorizationResponse();
            resp.setAuthorizationId(conAuth.getExternalId());
            resp.setPsuIdData(this.psuDataMapper.mapToPsuIdData(conAuth.getPsuData()));
            resp.setConsentId(conAuth.getConsent().getExternalId());
            resp.setScaStatus(conAuth.getScaStatus());
            resp.setAuthenticationMethodId(conAuth.getAuthenticationMethodId());
            resp.setScaAuthenticationData(conAuth.getScaAuthenticationData());
            resp.setChosenScaApproach(conAuth.getScaApproach());
            return resp;
        }).orElse(null);
    }

    public Set<AspspAccountAccess> mapAspspAccountAccesses(AisAccountAccess aisAccountAccess) {
        HashSet<AspspAccountAccess> accesses = new HashSet<AspspAccountAccess>();
        accesses.addAll(this.getAspspAccountAccesses(TypeAccess.ACCOUNT, aisAccountAccess.getAccounts()));
        accesses.addAll(this.getAspspAccountAccesses(TypeAccess.BALANCE, aisAccountAccess.getBalances()));
        accesses.addAll(this.getAspspAccountAccesses(TypeAccess.TRANSACTION, aisAccountAccess.getTransactions()));
        return accesses;
    }

    private AisAccountAccess mapToAisAccountAccess(AisConsent consent) {
        List<TppAccountAccess> accesses = consent.getAccesses();
        return new AisAccountAccess(this.mapToInitialAccountReferences(accesses, TypeAccess.ACCOUNT), this.mapToInitialAccountReferences(accesses, TypeAccess.BALANCE), this.mapToInitialAccountReferences(accesses, TypeAccess.TRANSACTION), this.getAccessType(consent.getAvailableAccounts()), this.getAccessType(consent.getAllPsd2()), this.getAccessType(consent.getAvailableAccountsWithBalances()));
    }

    private List<AccountReference> mapToInitialAccountReferences(List<TppAccountAccess> aisAccounts, TypeAccess typeAccess) {
        return aisAccounts.stream().filter(a -> a.getTypeAccess() == typeAccess).map(access -> new AccountReference(access.getAccountReferenceType(), access.getAccountIdentifier(), access.getCurrency())).collect(Collectors.toList());
    }

    private AisAccountAccess mapToAspspAisAccountAccess(AisConsent consent) {
        List<AspspAccountAccess> accesses = consent.getAspspAccountAccesses();
        return new AisAccountAccess(this.mapToAccountReferences(accesses, TypeAccess.ACCOUNT), this.mapToAccountReferences(accesses, TypeAccess.BALANCE), this.mapToAccountReferences(accesses, TypeAccess.TRANSACTION), this.getAccessType(consent.getAvailableAccounts()), this.getAccessType(consent.getAllPsd2()), this.getAccessType(consent.getAvailableAccountsWithBalances()));
    }

    private List<AccountReference> mapToAccountReferences(List<AspspAccountAccess> aisAccounts, TypeAccess typeAccess) {
        return aisAccounts.stream().filter(a -> a.getTypeAccess() == typeAccess).map(access -> new AccountReference(access.getAccountReferenceType(), access.getAccountIdentifier(), access.getCurrency(), access.getResourceId(), access.getAspspAccountId())).collect(Collectors.toList());
    }

    private Set<AspspAccountAccess> getAspspAccountAccesses(TypeAccess typeAccess, List<AccountReference> accountReferences) {
        return Optional.ofNullable(accountReferences).map(lst -> lst.stream().map(acc -> this.mapToAspspAccountAccess(typeAccess, (AccountReference)acc)).collect(Collectors.toSet())).orElse(Collections.emptySet());
    }

    private AspspAccountAccess mapToAspspAccountAccess(TypeAccess typeAccess, AccountReference accountReference) {
        AccountReferenceSelector selector = accountReference.getUsedAccountReferenceSelector();
        return new AspspAccountAccess(selector.getAccountValue(), typeAccess, selector.getAccountReferenceType(), accountReference.getCurrency(), accountReference.getResourceId(), accountReference.getAspspAccountId());
    }

    private String getAccessType(AccountAccessType type) {
        return Optional.ofNullable(type).map(Enum::name).orElse(null);
    }

    private List<AisAccountConsentAuthorisation> mapToAisAccountConsentAuthorisation(List<AisConsentAuthorization> aisConsentAuthorisations) {
        if (CollectionUtils.isEmpty(aisConsentAuthorisations)) {
            return Collections.emptyList();
        }
        return aisConsentAuthorisations.stream().map(this::mapToAisAccountConsentAuthorisation).collect(Collectors.toList());
    }

    private AisAccountConsentAuthorisation mapToAisAccountConsentAuthorisation(AisConsentAuthorization aisConsentAuthorisation) {
        return Optional.ofNullable(aisConsentAuthorisation).map(auth -> new AisAccountConsentAuthorisation(this.psuDataMapper.mapToPsuIdData(auth.getPsuData()), auth.getScaStatus())).orElse(null);
    }

    @ConstructorProperties(value={"psuDataMapper", "tppInfoMapper", "aisConsentUsageService"})
    public AisConsentMapper(PsuDataMapper psuDataMapper, TppInfoMapper tppInfoMapper, AisConsentUsageService aisConsentUsageService) {
        this.psuDataMapper = psuDataMapper;
        this.tppInfoMapper = tppInfoMapper;
        this.aisConsentUsageService = aisConsentUsageService;
    }
}

