/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.aspsp.profile.service.AspspProfileService;
import de.adorsys.psd2.consent.api.ActionStatus;
import de.adorsys.psd2.consent.api.ais.AisAccountAccessInfo;
import de.adorsys.psd2.consent.api.ais.AisAccountConsent;
import de.adorsys.psd2.consent.api.ais.AisConsentActionRequest;
import de.adorsys.psd2.consent.api.ais.CreateAisConsentRequest;
import de.adorsys.psd2.consent.api.service.AisConsentService;
import de.adorsys.psd2.consent.domain.PsuData;
import de.adorsys.psd2.consent.domain.TppInfoEntity;
import de.adorsys.psd2.consent.domain.account.AisConsent;
import de.adorsys.psd2.consent.domain.account.AisConsentAction;
import de.adorsys.psd2.consent.domain.account.AspspAccountAccessHolder;
import de.adorsys.psd2.consent.domain.account.TppAccountAccessHolder;
import de.adorsys.psd2.consent.repository.AisConsentActionRepository;
import de.adorsys.psd2.consent.repository.AisConsentRepository;
import de.adorsys.psd2.consent.service.AisConsentConfirmationExpirationService;
import de.adorsys.psd2.consent.service.AisConsentRequestTypeService;
import de.adorsys.psd2.consent.service.AisConsentUsageService;
import de.adorsys.psd2.consent.service.mapper.AisConsentMapper;
import de.adorsys.psd2.consent.service.mapper.PsuDataMapper;
import de.adorsys.psd2.consent.service.mapper.TppInfoMapper;
import de.adorsys.psd2.consent.service.psu.CmsPsuService;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class AisConsentServiceInternal
implements AisConsentService {
    private static final Logger log = LoggerFactory.getLogger(AisConsentServiceInternal.class);
    private final AisConsentRepository aisConsentRepository;
    private final AisConsentActionRepository aisConsentActionRepository;
    private final AisConsentMapper consentMapper;
    private final PsuDataMapper psuDataMapper;
    private final AspspProfileService aspspProfileService;
    private final AisConsentConfirmationExpirationService aisConsentConfirmationExpirationService;
    private final TppInfoMapper tppInfoMapper;
    private final CmsPsuService cmsPsuService;
    private final AisConsentUsageService aisConsentUsageService;
    private final AisConsentRequestTypeService aisConsentRequestTypeService;

    @Transactional
    public Optional<String> createConsent(CreateAisConsentRequest request) {
        if (request.getAllowedFrequencyPerDay() == null) {
            log.info("TPP ID: [{}]. Consent cannot be created, because request contains no allowed frequency per day", (Object)request.getTppInfo().getAuthorisationNumber());
            return Optional.empty();
        }
        AisConsent consent = this.createConsentFromRequest(request);
        AisConsent saved = (AisConsent)this.aisConsentRepository.save(consent);
        if (saved.getId() != null) {
            return Optional.of(saved.getExternalId());
        }
        log.info("TPP ID: [{}], External Consent ID: [{}]. Ais consent cannot be created, because when saving to DB got null ID", (Object)request.getTppInfo().getAuthorisationNumber(), (Object)consent.getExternalId());
        return Optional.empty();
    }

    @Transactional
    public Optional<ConsentStatus> getConsentStatusById(String consentId) {
        Optional<AisConsent> optionalConsentStatus = this.aisConsentRepository.findByExternalId(consentId);
        if (optionalConsentStatus.isPresent()) {
            return optionalConsentStatus.map(this.aisConsentConfirmationExpirationService::checkAndUpdateOnConfirmationExpiration).map(this::checkAndUpdateOnExpiration).map(AisConsent::getConsentStatus);
        }
        log.info("Consent ID: [{}]. Get consent failed, because consent is not found", (Object)consentId);
        return Optional.empty();
    }

    @Transactional
    public boolean updateConsentStatusById(String consentId, ConsentStatus status) {
        return this.getActualAisConsent(consentId).map(c -> this.setStatusAndSaveConsent((AisConsent)c, status)).orElseGet(() -> {
            log.info("Consent ID [{}]. Update consent status by id failed, because consent not found", (Object)consentId);
            return false;
        });
    }

    @Transactional
    public Optional<AisAccountConsent> getAisAccountConsentById(String consentId) {
        return this.aisConsentRepository.findByExternalId(consentId).map(this.aisConsentConfirmationExpirationService::checkAndUpdateOnConfirmationExpiration).map(this::checkAndUpdateOnExpiration).map(this.consentMapper::mapToAisAccountConsent);
    }

    @Transactional
    public Optional<AisAccountConsent> getInitialAisAccountConsentById(String consentId) {
        return this.aisConsentRepository.findByExternalId(consentId).map(this::checkAndUpdateOnExpiration).map(this.consentMapper::mapToInitialAisAccountConsent);
    }

    @Transactional
    public boolean findAndTerminateOldConsentsByNewConsentId(String newConsentId) {
        TppInfoEntity tppInfo;
        AisConsent newConsent = this.aisConsentRepository.findByExternalId(newConsentId).orElseThrow(() -> {
            log.info("Consent ID: [{}]. Cannot find consent by id", (Object)newConsentId);
            return new IllegalArgumentException("Wrong consent id: " + newConsentId);
        });
        if (newConsent.isOneAccessType()) {
            log.info("Consent ID: [{}]. Cannot find old consents, because consent is OneAccessType", (Object)newConsentId);
            return false;
        }
        if (newConsent.isWrongConsentData()) {
            log.info("Consent ID: [{}]. Find old consents failed, because consent psu data list is empty or tppInfo is null", (Object)newConsentId);
            throw new IllegalArgumentException("Wrong consent data");
        }
        List<PsuData> psuDataList = newConsent.getPsuDataList();
        Set<String> psuIds = psuDataList.stream().filter(Objects::nonNull).map(PsuData::getPsuId).collect(Collectors.toSet());
        List<AisConsent> oldConsents = this.aisConsentRepository.findOldConsentsByNewConsentParams(psuIds, (tppInfo = newConsent.getTppInfo()).getAuthorisationNumber(), tppInfo.getAuthorityId(), newConsent.getInstanceId(), newConsent.getExternalId(), EnumSet.of(ConsentStatus.RECEIVED, ConsentStatus.PARTIALLY_AUTHORISED, ConsentStatus.VALID));
        List<AisConsent> oldConsentsWithExactPsuDataLists = oldConsents.stream().filter(c -> this.cmsPsuService.isPsuDataListEqual(c.getPsuDataList(), psuDataList)).collect(Collectors.toList());
        if (oldConsentsWithExactPsuDataLists.isEmpty()) {
            log.info("Consent ID: [{}]. Cannot find old consents, because consent hasn't exact psu data lists as old consents", (Object)newConsentId);
            return false;
        }
        oldConsentsWithExactPsuDataLists.forEach(c -> c.setConsentStatus(ConsentStatus.TERMINATED_BY_TPP));
        this.aisConsentRepository.save(oldConsentsWithExactPsuDataLists);
        return true;
    }

    @Transactional
    public void checkConsentAndSaveActionLog(AisConsentActionRequest request) {
        Optional<AisConsent> consentOpt = this.getActualAisConsent(request.getConsentId());
        if (consentOpt.isPresent()) {
            AisConsent consent = consentOpt.get();
            this.aisConsentConfirmationExpirationService.checkAndUpdateOnConfirmationExpiration(consent);
            this.checkAndUpdateOnExpiration(consent);
            this.updateAisConsentUsage(consent, request);
            this.logConsentAction(consent.getExternalId(), this.resolveConsentActionStatus(request, consent), request.getTppId());
        }
    }

    @Transactional
    public Optional<String> updateAspspAccountAccess(String consentId, AisAccountAccessInfo request) {
        return this.getActualAisConsent(consentId).map(consent -> {
            consent.addAspspAccountAccess(new AspspAccountAccessHolder(request).getAccountAccesses());
            return ((AisConsent)this.aisConsentRepository.save(consent)).getExternalId();
        });
    }

    @Transactional
    public Optional<AisAccountConsent> updateAspspAccountAccessWithResponse(String consentId, AisAccountAccessInfo request) {
        return this.getActualAisConsent(consentId).map(consent -> {
            consent.addAspspAccountAccess(new AspspAccountAccessHolder(request).getAccountAccesses());
            return this.consentMapper.mapToAisAccountConsent((AisConsent)this.aisConsentRepository.save(consent));
        });
    }

    public Optional<List<PsuIdData>> getPsuDataByConsentId(String consentId) {
        return this.getActualAisConsent(consentId).map(ac -> this.psuDataMapper.mapToPsuIdDataList(ac.getPsuDataList()));
    }

    @Transactional
    public boolean updateMultilevelScaRequired(String consentId, boolean multilevelScaRequired) {
        Optional<AisConsent> aisConsentOptional = this.aisConsentRepository.findByExternalId(consentId);
        if (!aisConsentOptional.isPresent()) {
            log.info("Consent ID: [{}]. Get update multilevel SCA required status failed, because consent authorisation is not found", (Object)consentId);
            return false;
        }
        AisConsent consent = aisConsentOptional.get();
        consent.setMultilevelScaRequired(multilevelScaRequired);
        this.aisConsentRepository.save(consent);
        return true;
    }

    private AisConsent createConsentFromRequest(CreateAisConsentRequest request) {
        AisConsent consent = new AisConsent();
        consent.setExternalId(UUID.randomUUID().toString());
        consent.setConsentStatus(ConsentStatus.RECEIVED);
        consent.setAllowedFrequencyPerDay(request.getAllowedFrequencyPerDay());
        consent.setTppFrequencyPerDay(request.getRequestedFrequencyPerDay());
        consent.setRequestDateTime(LocalDateTime.now());
        consent.setExpireDate(this.adjustExpireDate(request.getValidUntil()));
        consent.setPsuDataList(this.psuDataMapper.mapToPsuDataList(Collections.singletonList(request.getPsuData())));
        consent.setTppInfo(this.tppInfoMapper.mapToTppInfoEntity(request.getTppInfo()));
        consent.addAccountAccess(new TppAccountAccessHolder(request.getAccess()).getAccountAccesses());
        consent.setRecurringIndicator(request.isRecurringIndicator());
        consent.setTppRedirectPreferred(request.isTppRedirectPreferred());
        consent.setCombinedServiceIndicator(request.isCombinedServiceIndicator());
        consent.setAisConsentRequestType(this.aisConsentRequestTypeService.getRequestTypeFromAccess(request.getAccess()));
        consent.setAvailableAccounts(request.getAccess().getAvailableAccounts());
        consent.setAllPsd2(request.getAccess().getAllPsd2());
        consent.setAvailableAccountsWithBalances(request.getAccess().getAvailableAccountsWithBalances());
        consent.setLastActionDate(LocalDate.now());
        return consent;
    }

    private LocalDate adjustExpireDate(LocalDate validUntil) {
        int lifetime = this.aspspProfileService.getAspspSettings().getConsentLifetime();
        if (lifetime <= 0) {
            return validUntil;
        }
        LocalDate lifeTimeDate = LocalDate.now().plusDays((long)lifetime - 1L);
        return lifeTimeDate.isBefore(validUntil) ? lifeTimeDate : validUntil;
    }

    private ActionStatus resolveConsentActionStatus(AisConsentActionRequest request, AisConsent consent) {
        if (consent == null) {
            log.info("Consent ID: [{}]. Consent action status resolver received null consent", (Object)request.getConsentId());
            return ActionStatus.BAD_PAYLOAD;
        }
        return request.getActionStatus();
    }

    private void logConsentAction(String requestedConsentId, ActionStatus actionStatus, String tppId) {
        AisConsentAction action = new AisConsentAction();
        action.setActionStatus(actionStatus);
        action.setRequestedConsentId(requestedConsentId);
        action.setTppId(tppId);
        action.setRequestDate(LocalDate.now());
        this.aisConsentActionRepository.save(action);
    }

    private Optional<AisConsent> getActualAisConsent(String consentId) {
        return this.aisConsentRepository.findByExternalId(consentId).filter(c -> !c.getConsentStatus().isFinalisedStatus());
    }

    private AisConsent checkAndUpdateOnExpiration(AisConsent consent) {
        if (consent != null && consent.isStatusNotExpired() && (consent.isExpiredByDate() || consent.isNonReccuringAlreadyUsed())) {
            consent.setConsentStatus(ConsentStatus.EXPIRED);
            consent.setExpireDate(LocalDate.now());
            consent.setLastActionDate(LocalDate.now());
            this.aisConsentRepository.save(consent);
        }
        return consent;
    }

    private boolean setStatusAndSaveConsent(AisConsent consent, ConsentStatus status) {
        if (consent.getConsentStatus().isFinalisedStatus()) {
            log.info("Consent ID: [{}], Consent status [{}]. Update consent status by id failed, because consent status is finalised", (Object)consent.getExternalId(), (Object)consent.getConsentStatus());
            return false;
        }
        consent.setLastActionDate(LocalDate.now());
        consent.setConsentStatus(status);
        return Optional.ofNullable(this.aisConsentRepository.save(consent)).isPresent();
    }

    private void updateAisConsentUsage(AisConsent consent, AisConsentActionRequest request) {
        if (!request.isUpdateUsage()) {
            return;
        }
        this.aisConsentUsageService.incrementUsage(consent, request.getRequestUri());
        consent.setLastActionDate(LocalDate.now());
        this.aisConsentRepository.save(consent);
    }

    @ConstructorProperties(value={"aisConsentRepository", "aisConsentActionRepository", "consentMapper", "psuDataMapper", "aspspProfileService", "aisConsentConfirmationExpirationService", "tppInfoMapper", "cmsPsuService", "aisConsentUsageService", "aisConsentRequestTypeService"})
    public AisConsentServiceInternal(AisConsentRepository aisConsentRepository, AisConsentActionRepository aisConsentActionRepository, AisConsentMapper consentMapper, PsuDataMapper psuDataMapper, AspspProfileService aspspProfileService, AisConsentConfirmationExpirationService aisConsentConfirmationExpirationService, TppInfoMapper tppInfoMapper, CmsPsuService cmsPsuService, AisConsentUsageService aisConsentUsageService, AisConsentRequestTypeService aisConsentRequestTypeService) {
        this.aisConsentRepository = aisConsentRepository;
        this.aisConsentActionRepository = aisConsentActionRepository;
        this.consentMapper = consentMapper;
        this.psuDataMapper = psuDataMapper;
        this.aspspProfileService = aspspProfileService;
        this.aisConsentConfirmationExpirationService = aisConsentConfirmationExpirationService;
        this.tppInfoMapper = tppInfoMapper;
        this.cmsPsuService = cmsPsuService;
        this.aisConsentUsageService = aisConsentUsageService;
        this.aisConsentRequestTypeService = aisConsentRequestTypeService;
    }
}

