/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.api.CmsAuthorisationType;
import de.adorsys.psd2.consent.api.CmsScaMethod;
import de.adorsys.psd2.consent.api.pis.CreatePisCommonPaymentResponse;
import de.adorsys.psd2.consent.api.pis.authorisation.CreatePisAuthorisationRequest;
import de.adorsys.psd2.consent.api.pis.authorisation.CreatePisAuthorisationResponse;
import de.adorsys.psd2.consent.api.pis.authorisation.GetPisAuthorisationResponse;
import de.adorsys.psd2.consent.api.pis.authorisation.UpdatePisCommonPaymentPsuDataRequest;
import de.adorsys.psd2.consent.api.pis.authorisation.UpdatePisCommonPaymentPsuDataResponse;
import de.adorsys.psd2.consent.api.pis.proto.PisCommonPaymentRequest;
import de.adorsys.psd2.consent.api.pis.proto.PisCommonPaymentResponse;
import de.adorsys.psd2.consent.api.pis.proto.PisPaymentInfo;
import de.adorsys.psd2.consent.api.service.PisCommonPaymentService;
import de.adorsys.psd2.consent.api.service.PisCommonPaymentServiceEncrypted;
import de.adorsys.psd2.consent.service.security.SecurityDataService;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class PisCommonPaymentServiceInternalEncrypted
implements PisCommonPaymentServiceEncrypted {
    private final SecurityDataService securityDataService;
    private final PisCommonPaymentService pisCommonPaymentService;

    @Transactional
    public Optional<CreatePisCommonPaymentResponse> createCommonPayment(PisPaymentInfo request) {
        return this.pisCommonPaymentService.createCommonPayment(request).map(CreatePisCommonPaymentResponse::getPaymentId).flatMap(this.securityDataService::encryptId).map(CreatePisCommonPaymentResponse::new);
    }

    @Transactional
    public Optional<TransactionStatus> getPisCommonPaymentStatusById(String encryptedPaymentId) {
        return this.securityDataService.decryptId(encryptedPaymentId).flatMap(x$0 -> this.pisCommonPaymentService.getPisCommonPaymentStatusById(x$0));
    }

    @Transactional
    public Optional<PisCommonPaymentResponse> getCommonPaymentById(String encryptedPaymentId) {
        return this.securityDataService.decryptId(encryptedPaymentId).flatMap(x$0 -> this.pisCommonPaymentService.getCommonPaymentById(x$0));
    }

    @Transactional
    public Optional<Boolean> updateCommonPaymentStatusById(String encryptedPaymentId, TransactionStatus status) {
        return this.securityDataService.decryptId(encryptedPaymentId).flatMap(id -> this.pisCommonPaymentService.updateCommonPaymentStatusById(id, status));
    }

    public Optional<String> getDecryptedId(String encryptedId) {
        return this.securityDataService.decryptId(encryptedId);
    }

    @Transactional
    public Optional<CreatePisAuthorisationResponse> createAuthorization(String encryptedPaymentId, CreatePisAuthorisationRequest request) {
        return this.securityDataService.decryptId(encryptedPaymentId).flatMap(id -> this.pisCommonPaymentService.createAuthorization(id, request));
    }

    @Transactional
    public Optional<CreatePisAuthorisationResponse> createAuthorizationCancellation(String encryptedPaymentId, CreatePisAuthorisationRequest request) {
        return this.securityDataService.decryptId(encryptedPaymentId).flatMap(id -> this.pisCommonPaymentService.createAuthorizationCancellation(id, request));
    }

    @Transactional
    public Optional<UpdatePisCommonPaymentPsuDataResponse> updatePisAuthorisation(String authorisationId, UpdatePisCommonPaymentPsuDataRequest request) {
        return this.pisCommonPaymentService.updatePisAuthorisation(authorisationId, request);
    }

    @Transactional
    public Optional<UpdatePisCommonPaymentPsuDataResponse> updatePisCancellationAuthorisation(String authorisationId, UpdatePisCommonPaymentPsuDataRequest request) {
        return this.pisCommonPaymentService.updatePisCancellationAuthorisation(authorisationId, request);
    }

    @Transactional
    public void updateCommonPayment(PisCommonPaymentRequest request, String encryptedPaymentId) {
        this.securityDataService.decryptId(encryptedPaymentId).ifPresent(id -> this.pisCommonPaymentService.updateCommonPayment(request, id));
    }

    public Optional<GetPisAuthorisationResponse> getPisAuthorisationById(String authorisationId) {
        return this.pisCommonPaymentService.getPisAuthorisationById(authorisationId);
    }

    public Optional<GetPisAuthorisationResponse> getPisCancellationAuthorisationById(String cancellationId) {
        return this.pisCommonPaymentService.getPisCancellationAuthorisationById(cancellationId);
    }

    public Optional<List<String>> getAuthorisationsByPaymentId(String encryptedPaymentId, CmsAuthorisationType authorisationType) {
        return this.securityDataService.decryptId(encryptedPaymentId).flatMap(id -> this.pisCommonPaymentService.getAuthorisationsByPaymentId(id, authorisationType));
    }

    @Transactional
    public Optional<ScaStatus> getAuthorisationScaStatus(String encryptedPaymentId, String authorisationId, CmsAuthorisationType authorisationType) {
        return this.securityDataService.decryptId(encryptedPaymentId).flatMap(id -> this.pisCommonPaymentService.getAuthorisationScaStatus(id, authorisationId, authorisationType));
    }

    public Optional<List<PsuIdData>> getPsuDataListByPaymentId(String encryptedPaymentId) {
        return this.securityDataService.decryptId(encryptedPaymentId).flatMap(x$0 -> this.pisCommonPaymentService.getPsuDataListByPaymentId(x$0));
    }

    public boolean isAuthenticationMethodDecoupled(String authorisationId, String authenticationMethodId) {
        return this.pisCommonPaymentService.isAuthenticationMethodDecoupled(authorisationId, authenticationMethodId);
    }

    @Transactional
    public boolean saveAuthenticationMethods(String authorisationId, List<CmsScaMethod> methods) {
        return this.pisCommonPaymentService.saveAuthenticationMethods(authorisationId, methods);
    }

    @Transactional
    public boolean updateScaApproach(String authorisationId, ScaApproach scaApproach) {
        return this.pisCommonPaymentService.updateScaApproach(authorisationId, scaApproach);
    }

    @ConstructorProperties(value={"securityDataService", "pisCommonPaymentService"})
    public PisCommonPaymentServiceInternalEncrypted(SecurityDataService securityDataService, PisCommonPaymentService pisCommonPaymentService) {
        this.securityDataService = securityDataService;
        this.pisCommonPaymentService = pisCommonPaymentService;
    }
}

