/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.aspsp.api.piis.CmsAspspPiisService;
import de.adorsys.psd2.consent.aspsp.api.piis.CreatePiisConsentRequest;
import de.adorsys.psd2.consent.domain.piis.PiisConsentEntity;
import de.adorsys.psd2.consent.repository.PiisConsentRepository;
import de.adorsys.psd2.consent.repository.specification.PiisConsentEntitySpecification;
import de.adorsys.psd2.consent.service.mapper.AccountReferenceMapper;
import de.adorsys.psd2.consent.service.mapper.PiisConsentMapper;
import de.adorsys.psd2.consent.service.mapper.PsuDataMapper;
import de.adorsys.psd2.consent.service.mapper.TppInfoMapper;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.piis.PiisConsent;
import de.adorsys.psd2.xs2a.core.piis.PiisConsentTppAccessType;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CmsAspspPiisServiceInternal
implements CmsAspspPiisService {
    private static final Logger log = LoggerFactory.getLogger(CmsAspspPiisServiceInternal.class);
    private final PiisConsentRepository piisConsentRepository;
    private final PiisConsentEntitySpecification piisConsentEntitySpecification;
    private final PiisConsentMapper piisConsentMapper;
    private final PsuDataMapper psuDataMapper;
    private final TppInfoMapper tppInfoMapper;
    private final AccountReferenceMapper accountReferenceMapper;

    @Transactional
    public Optional<String> createConsent(@NotNull PsuIdData psuIdData, @Nullable TppInfo tppInfo, @NotNull List<AccountReference> accounts, @NotNull LocalDate validUntil, int allowedFrequencyPerDay) {
        CreatePiisConsentRequest request = new CreatePiisConsentRequest();
        request.setTppInfo(tppInfo);
        request.setAccounts(accounts);
        request.setValidUntil(validUntil);
        request.setAllowedFrequencyPerDay(allowedFrequencyPerDay);
        return this.createConsent(psuIdData, request);
    }

    @Transactional
    public Optional<String> createConsent(@NotNull PsuIdData psuIdData, @NotNull CreatePiisConsentRequest request) {
        if (this.isInvalidConsentCreationRequest(psuIdData, request)) {
            log.info("Consent cannot be created, because request contains no allowed tppInfo or empty psuIdData or empty accounts or validUntil or cardExpiryDate in the past");
            return Optional.empty();
        }
        this.closePreviousPiisConsents(psuIdData, request.getTppInfo(), request.getAccount());
        PiisConsentEntity consent = this.buildPiisConsent(psuIdData, request);
        PiisConsentEntity saved = (PiisConsentEntity)this.piisConsentRepository.save(consent);
        if (saved.getId() != null) {
            return Optional.ofNullable(saved.getExternalId());
        }
        log.info("External Consent ID: [{}]. PIIS consent cannot be created, because when saving to DB got null ID", (Object)consent.getExternalId());
        return Optional.empty();
    }

    @NotNull
    public List<PiisConsent> getConsentsForPsu(@NotNull PsuIdData psuIdData, @NotNull String instanceId) {
        if (psuIdData.isEmpty()) {
            return Collections.emptyList();
        }
        return this.piisConsentRepository.findAll(this.piisConsentEntitySpecification.byPsuDataAndInstanceId(psuIdData, instanceId)).stream().map(this.piisConsentMapper::mapToPiisConsent).collect(Collectors.toList());
    }

    @Transactional
    public boolean terminateConsent(@NotNull String consentId, @NotNull String instanceId) {
        Optional<Object> entityOptional = Optional.ofNullable(this.piisConsentRepository.findOne(this.piisConsentEntitySpecification.byConsentIdAndInstanceId(consentId, instanceId)));
        if (!entityOptional.isPresent()) {
            log.info("Consent ID: [{}], Instance ID: [{}]. Consent cannot be terminated, because not found by consentId and instanceId", (Object)consentId, (Object)instanceId);
            return false;
        }
        PiisConsentEntity entity = (PiisConsentEntity)entityOptional.get();
        entity.setLastActionDate(LocalDate.now());
        entity.setConsentStatus(ConsentStatus.TERMINATED_BY_ASPSP);
        this.piisConsentRepository.save(entity);
        return true;
    }

    private void closePreviousPiisConsents(PsuIdData psuIdData, TppInfo tppInfo, AccountReference accountReference) {
        Specification<PiisConsentEntity> specification = this.piisConsentEntitySpecification.byPsuIdDataAndTppInfoAndAccountReference(psuIdData, tppInfo, accountReference);
        List piisConsentEntities = this.piisConsentRepository.findAll(specification);
        piisConsentEntities.forEach(con -> con.setConsentStatus(ConsentStatus.REVOKED_BY_PSU));
        this.piisConsentRepository.save(piisConsentEntities);
    }

    private PiisConsentEntity buildPiisConsent(PsuIdData psuIdData, CreatePiisConsentRequest request) {
        PiisConsentEntity consent = new PiisConsentEntity();
        consent.setExternalId(UUID.randomUUID().toString());
        consent.setConsentStatus(ConsentStatus.VALID);
        consent.setRequestDateTime(OffsetDateTime.now());
        consent.setExpireDate(request.getValidUntil());
        consent.setPsuData(this.psuDataMapper.mapToPsuData(psuIdData));
        consent.setTppInfo(this.tppInfoMapper.mapToTppInfoEntity(request.getTppInfo()));
        consent.setAccount(this.accountReferenceMapper.mapToAccountReferenceEntity(request.getAccount()));
        PiisConsentTppAccessType accessType = request.getTppInfo() != null ? PiisConsentTppAccessType.SINGLE_TPP : PiisConsentTppAccessType.ALL_TPP;
        consent.setTppAccessType(accessType);
        consent.setAllowedFrequencyPerDay(request.getAllowedFrequencyPerDay());
        consent.setCardNumber(request.getCardNumber());
        consent.setCardExpiryDate(request.getCardExpiryDate());
        consent.setCardInformation(request.getCardInformation());
        consent.setRegistrationInformation(request.getRegistrationInformation());
        return consent;
    }

    private boolean isInvalidConsentCreationRequest(@NotNull PsuIdData psuIdData, CreatePiisConsentRequest request) {
        boolean invalidTpp = request.getTppInfo() == null || request.getTppInfo().isNotValid();
        return invalidTpp || psuIdData.isEmpty() || request.getAccount() == null || request.getValidUntil() == null || request.getValidUntil().isBefore(LocalDate.now()) || request.getCardExpiryDate() != null && request.getCardExpiryDate().isBefore(LocalDate.now());
    }

    @ConstructorProperties(value={"piisConsentRepository", "piisConsentEntitySpecification", "piisConsentMapper", "psuDataMapper", "tppInfoMapper", "accountReferenceMapper"})
    public CmsAspspPiisServiceInternal(PiisConsentRepository piisConsentRepository, PiisConsentEntitySpecification piisConsentEntitySpecification, PiisConsentMapper piisConsentMapper, PsuDataMapper psuDataMapper, TppInfoMapper tppInfoMapper, AccountReferenceMapper accountReferenceMapper) {
        this.piisConsentRepository = piisConsentRepository;
        this.piisConsentEntitySpecification = piisConsentEntitySpecification;
        this.piisConsentMapper = piisConsentMapper;
        this.psuDataMapper = psuDataMapper;
        this.tppInfoMapper = tppInfoMapper;
        this.accountReferenceMapper = accountReferenceMapper;
    }
}

