/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.api.CmsScaMethod;
import de.adorsys.psd2.consent.api.ais.AisConsentAuthorizationRequest;
import de.adorsys.psd2.consent.api.ais.AisConsentAuthorizationResponse;
import de.adorsys.psd2.consent.api.ais.CreateAisConsentAuthorizationResponse;
import de.adorsys.psd2.consent.api.service.AisConsentAuthorisationService;
import de.adorsys.psd2.consent.api.service.AisConsentAuthorisationServiceEncrypted;
import de.adorsys.psd2.consent.service.security.SecurityDataService;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class AisAuthorisationServiceInternalEncrypted
implements AisConsentAuthorisationServiceEncrypted {
    private static final Logger log = LoggerFactory.getLogger(AisAuthorisationServiceInternalEncrypted.class);
    private final SecurityDataService securityDataService;
    private final AisConsentAuthorisationService aisConsentAuthorisationService;

    @Transactional
    @Deprecated
    public Optional<String> createAuthorization(String encryptedConsentId, AisConsentAuthorizationRequest request) {
        return this.securityDataService.decryptId(encryptedConsentId).flatMap(id -> this.aisConsentAuthorisationService.createAuthorization(id, request));
    }

    @Transactional
    public Optional<CreateAisConsentAuthorizationResponse> createAuthorizationWithResponse(String encryptedConsentId, AisConsentAuthorizationRequest request) {
        return this.securityDataService.decryptId(encryptedConsentId).flatMap(id -> this.aisConsentAuthorisationService.createAuthorizationWithResponse(id, request));
    }

    public Optional<AisConsentAuthorizationResponse> getAccountConsentAuthorizationById(String authorisationId, String encryptedConsentId) {
        return this.securityDataService.decryptId(encryptedConsentId).flatMap(id -> this.aisConsentAuthorisationService.getAccountConsentAuthorizationById(authorisationId, id));
    }

    @Transactional
    public boolean updateConsentAuthorization(String authorizationId, AisConsentAuthorizationRequest request) {
        return this.aisConsentAuthorisationService.updateConsentAuthorization(authorizationId, request);
    }

    public Optional<List<String>> getAuthorisationsByConsentId(String encryptedConsentId) {
        return this.securityDataService.decryptId(encryptedConsentId).flatMap(x$0 -> this.aisConsentAuthorisationService.getAuthorisationsByConsentId(x$0));
    }

    @Transactional
    public Optional<ScaStatus> getAuthorisationScaStatus(String encryptedConsentId, String authorisationId) {
        return this.securityDataService.decryptId(encryptedConsentId).flatMap(consentId -> this.aisConsentAuthorisationService.getAuthorisationScaStatus(consentId, authorisationId));
    }

    public boolean isAuthenticationMethodDecoupled(String authorisationId, String authenticationMethodId) {
        return this.aisConsentAuthorisationService.isAuthenticationMethodDecoupled(authorisationId, authenticationMethodId);
    }

    @Transactional
    public boolean saveAuthenticationMethods(String authorisationId, List<CmsScaMethod> methods) {
        return this.aisConsentAuthorisationService.saveAuthenticationMethods(authorisationId, methods);
    }

    @Transactional
    public boolean updateScaApproach(String authorisationId, ScaApproach scaApproach) {
        return this.aisConsentAuthorisationService.updateScaApproach(authorisationId, scaApproach);
    }

    @ConstructorProperties(value={"securityDataService", "aisConsentAuthorisationService"})
    public AisAuthorisationServiceInternalEncrypted(SecurityDataService securityDataService, AisConsentAuthorisationService aisConsentAuthorisationService) {
        this.securityDataService = securityDataService;
        this.aisConsentAuthorisationService = aisConsentAuthorisationService;
    }
}

