/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.repository.specification;

import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.jpa.domain.Specification;

public class EntityAttributeSpecificationProvider {
    private EntityAttributeSpecificationProvider() {
    }

    public static <T> Specification<T> provideSpecificationForEntityAttribute(String attribute, String value) {
        return (root, criteriaQuery, criteriaBuilder) -> {
            if (StringUtils.isBlank((CharSequence)value)) {
                return null;
            }
            return criteriaBuilder.and(new Predicate[]{criteriaBuilder.equal((Expression)root.get(attribute), (Object)value)});
        };
    }

    public static <T> Specification<T> provideSpecificationForJoinedEntityAttribute(@NotNull Join<T, ?> join, @NotNull String attribute, @Nullable String value) {
        return (root, criteriaQuery, criteriaBuilder) -> {
            if (StringUtils.isBlank((CharSequence)value)) {
                return null;
            }
            return criteriaBuilder.and(new Predicate[]{criteriaBuilder.equal((Expression)join.get(attribute), (Object)value)});
        };
    }

    public static <T> Specification<T> provideSpecificationForJoinedEntityAttribute(@NotNull Join<T, ?> join, @NotNull String attribute, @NotNull Object value) {
        return (root, criteriaQuery, criteriaBuilder) -> criteriaBuilder.and(new Predicate[]{criteriaBuilder.equal((Expression)join.get(attribute), value)});
    }
}

