/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.scheduler;

import de.adorsys.psd2.consent.domain.TppStopListEntity;
import de.adorsys.psd2.consent.repository.TppStopListRepository;
import de.adorsys.psd2.xs2a.core.tpp.TppStatus;
import java.beans.ConstructorProperties;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class TppStopListScheduleTask {
    private static final Logger log = LoggerFactory.getLogger(TppStopListScheduleTask.class);
    private final TppStopListRepository tppStopListRepository;

    @Scheduled(cron="${stoplist.cron.expression}")
    @Transactional
    public void unblockTppIfBlockingExpired() {
        log.info("Tpp Stop List schedule task is run!");
        List<TppStopListEntity> blockedWithExpirationTpps = this.tppStopListRepository.findAllByStatusAndBlockingExpirationTimestampLessThanEqual(TppStatus.BLOCKED, OffsetDateTime.now());
        List<TppStopListEntity> unblockedTpps = this.unblockTpps(blockedWithExpirationTpps);
        if (!unblockedTpps.isEmpty()) {
            this.tppStopListRepository.save(unblockedTpps);
        }
    }

    private List<TppStopListEntity> unblockTpps(List<TppStopListEntity> blockedWithExpirationTpps) {
        return blockedWithExpirationTpps.stream().map(this::unblockTpp).collect(Collectors.toList());
    }

    private TppStopListEntity unblockTpp(TppStopListEntity tppStopListEntity) {
        tppStopListEntity.unblock();
        return tppStopListEntity;
    }

    @ConstructorProperties(value={"tppStopListRepository"})
    public TppStopListScheduleTask(TppStopListRepository tppStopListRepository) {
        this.tppStopListRepository = tppStopListRepository;
    }
}

