/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.aspsp;

import de.adorsys.psd2.consent.aspsp.api.piis.CmsAspspPiisFundsExportService;
import de.adorsys.psd2.consent.repository.PiisConsentRepository;
import de.adorsys.psd2.consent.repository.specification.PiisConsentEntitySpecification;
import de.adorsys.psd2.consent.service.mapper.PiisConsentMapper;
import de.adorsys.psd2.xs2a.core.piis.PiisConsent;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CmsAspspPiisFundsExportServiceInternal
implements CmsAspspPiisFundsExportService {
    private static final Logger log = LoggerFactory.getLogger(CmsAspspPiisFundsExportServiceInternal.class);
    private static final String DEFAULT_SERVICE_INSTANCE_ID = "UNDEFINED";
    private final PiisConsentRepository piisConsentRepository;
    private final PiisConsentEntitySpecification piisConsentEntitySpecification;
    private final PiisConsentMapper piisConsentMapper;

    public Collection<PiisConsent> exportConsentsByTpp(String tppAuthorisationNumber, @Nullable LocalDate createDateFrom, @Nullable LocalDate createDateTo, @Nullable PsuIdData psuIdData, @Nullable String instanceId) {
        if (StringUtils.isBlank((CharSequence)tppAuthorisationNumber)) {
            log.info("TPP ID: [{}], instanceId: [{}]. Export consents by TPP failed, TPP ID is empty or null.", (Object)tppAuthorisationNumber, (Object)instanceId);
            return Collections.emptyList();
        }
        String actualInstanceId = (String)StringUtils.defaultIfEmpty((CharSequence)instanceId, (CharSequence)DEFAULT_SERVICE_INSTANCE_ID);
        List piisConsentEntities = this.piisConsentRepository.findAll(this.piisConsentEntitySpecification.byTppIdAndCreationPeriodAndPsuIdDataAndInstanceId(tppAuthorisationNumber, createDateFrom, createDateTo, psuIdData, actualInstanceId));
        return this.piisConsentMapper.mapToPiisConsentList(piisConsentEntities);
    }

    public Collection<PiisConsent> exportConsentsByPsu(PsuIdData psuIdData, @Nullable LocalDate createDateFrom, @Nullable LocalDate createDateTo, @Nullable String instanceId) {
        if (psuIdData == null || psuIdData.isEmpty()) {
            log.info("InstanceId: [{}]. Export consents by psu failed, psuIdData is empty or null.", (Object)instanceId);
            return Collections.emptyList();
        }
        String actualInstanceId = (String)StringUtils.defaultIfEmpty((CharSequence)instanceId, (CharSequence)DEFAULT_SERVICE_INSTANCE_ID);
        List piisConsentEntities = this.piisConsentRepository.findAll(this.piisConsentEntitySpecification.byPsuIdDataAndCreationPeriodAndInstanceId(psuIdData, createDateFrom, createDateTo, actualInstanceId));
        return this.piisConsentMapper.mapToPiisConsentList(piisConsentEntities);
    }

    public Collection<PiisConsent> exportConsentsByAccountId(@NotNull String aspspAccountId, @Nullable LocalDate createDateFrom, @Nullable LocalDate createDateTo, @Nullable String instanceId) {
        if (StringUtils.isBlank((CharSequence)aspspAccountId)) {
            log.info("InstanceId: [{}]. Export consents by accountId failed, aspspAccountId is empty or null.", (Object)instanceId);
            return Collections.emptyList();
        }
        String actualInstanceId = (String)StringUtils.defaultIfEmpty((CharSequence)instanceId, (CharSequence)DEFAULT_SERVICE_INSTANCE_ID);
        List piisConsentEntities = this.piisConsentRepository.findAll(this.piisConsentEntitySpecification.byAspspAccountIdAndCreationPeriodAndInstanceId(aspspAccountId, createDateFrom, createDateTo, actualInstanceId));
        return this.piisConsentMapper.mapToPiisConsentList(piisConsentEntities);
    }

    @ConstructorProperties(value={"piisConsentRepository", "piisConsentEntitySpecification", "piisConsentMapper"})
    public CmsAspspPiisFundsExportServiceInternal(PiisConsentRepository piisConsentRepository, PiisConsentEntitySpecification piisConsentEntitySpecification, PiisConsentMapper piisConsentMapper) {
        this.piisConsentRepository = piisConsentRepository;
        this.piisConsentEntitySpecification = piisConsentEntitySpecification;
        this.piisConsentMapper = piisConsentMapper;
    }
}

