/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.domain.account;

import de.adorsys.psd2.consent.api.ConsentType;
import de.adorsys.psd2.consent.domain.InstanceDependableEntity;
import de.adorsys.psd2.consent.domain.PsuData;
import de.adorsys.psd2.consent.domain.TppInfoEntity;
import de.adorsys.psd2.consent.domain.account.AisConsentAuthorization;
import de.adorsys.psd2.consent.domain.account.AisConsentUsage;
import de.adorsys.psd2.consent.domain.account.AspspAccountAccess;
import de.adorsys.psd2.consent.domain.account.TppAccountAccess;
import de.adorsys.psd2.xs2a.core.ais.AccountAccessType;
import de.adorsys.psd2.xs2a.core.consent.AisConsentRequestType;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import org.apache.commons.collections4.CollectionUtils;

@Entity(name="ais_consent")
@ApiModel(description="Ais consent entity", value="AisConsent")
public class AisConsent
extends InstanceDependableEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ais_consent_generator")
    @SequenceGenerator(name="ais_consent_generator", sequenceName="ais_consent_id_seq")
    private Long id;
    @Column(name="external_id", nullable=false)
    @ApiModelProperty(value="An external exposed identification of the created account consent", required=true, example="bf489af6-a2cb-4b75-b71d-d66d58b934d7")
    private String externalId;
    @Column(name="recurring_indicator", nullable=false)
    @ApiModelProperty(value="'true', if the consent is for recurring access to the account data , 'false', if the consent is for single access to the account data", required=true, example="false")
    private boolean recurringIndicator;
    @Column(name="tpp_redirect_preferred", nullable=false)
    @ApiModelProperty(name="tppRedirectPreferred", value="If it equals \u201ctrue\u201d, the TPP prefers a redirect over an embedded SCA approach.", required=true, example="false")
    private boolean tppRedirectPreferred;
    @Column(name="combined_service_indicator", nullable=false)
    @ApiModelProperty(value="'true' if aspsp supports combined sessions, otherwise 'false'.", required=true, example="false")
    private boolean combinedServiceIndicator;
    @Column(name="request_date_time", nullable=false)
    @ApiModelProperty(value="Date of the last request for this consent. The content is the local ASPSP date in ISODate Format", required=true, example="2018-10-25T15:30:35.035Z")
    private LocalDateTime requestDateTime;
    @Column(name="last_action_date")
    @ApiModelProperty(value="Date of the last action for this consent. The content is the local ASPSP date in ISODate Format", required=true, example="2018-05-04")
    private LocalDate lastActionDate;
    @Column(name="expire_date", nullable=false)
    @ApiModelProperty(value="Expiration date for the requested consent. The content is the local ASPSP date in ISODate Format", required=true, example="2018-05-04")
    private LocalDate expireDate;
    @OneToMany(cascade={CascadeType.ALL})
    @JoinTable(name="ais_consent_psu_data", joinColumns={@JoinColumn(name="ais_consent_id")}, inverseJoinColumns={@JoinColumn(name="psu_data_id")})
    private List<PsuData> psuDataList = new ArrayList<PsuData>();
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="tpp_info_id", nullable=false)
    @ApiModelProperty(value="Information about TPP", required=true)
    private TppInfoEntity tppInfo;
    @Column(name="consent_status", nullable=false)
    @Enumerated(value=EnumType.STRING)
    @ApiModelProperty(value="The following code values are permitted 'received', 'valid', 'rejected', 'expired', 'revoked by psu', 'terminated by tpp'. These values might be extended by ASPSP by more values.", required=true, example="VALID")
    private ConsentStatus consentStatus;
    @Column(name="consent_type", nullable=false)
    @Enumerated(value=EnumType.STRING)
    @ApiModelProperty(value="Type of the consent: AIS or PIS.", required=true, example="AIS")
    private ConsentType consentType = ConsentType.AIS;
    @Column(name="expected_frequency_per_day", nullable=false)
    @ApiModelProperty(value="Maximum frequency for an access per day, based on tppFrequencyPerDate and inner calculations. For a once-off access, this attribute is set to 1", required=true, example="4")
    private int allowedFrequencyPerDay;
    @Column(name="tpp_frequency_per_day", nullable=false)
    @ApiModelProperty(value="Requested maximum frequency for an access per day. For a once-off access, this attribute is set to 1", required=true, example="4")
    private int tppFrequencyPerDay;
    @Deprecated
    @Column(name="usage_counter", nullable=false)
    @ApiModelProperty(value="Usage counter for the consent", required=true, example="7")
    private int usageCounter;
    @OneToMany(mappedBy="consent", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<AisConsentUsage> usages = new ArrayList<AisConsentUsage>();
    @ElementCollection
    @CollectionTable(name="ais_account_access", joinColumns={@JoinColumn(name="consent_id")})
    @ApiModelProperty(value="Set of accesses given by psu for this account", required=true)
    private List<TppAccountAccess> accesses = new ArrayList<TppAccountAccess>();
    @ElementCollection
    @CollectionTable(name="ais_aspsp_account_access", joinColumns={@JoinColumn(name="consent_id")})
    @ApiModelProperty(value="Set of aspsp account accesses given by aspsp for this account", required=true)
    private List<AspspAccountAccess> aspspAccountAccesses = new ArrayList<AspspAccountAccess>();
    @OneToMany(mappedBy="consent", cascade={CascadeType.PERSIST}, orphanRemoval=true)
    @ApiModelProperty(value="List of authorizations related to the consent", required=true)
    private List<AisConsentAuthorization> authorizations = new ArrayList<AisConsentAuthorization>();
    @Column(name="ais_consent_request_type", nullable=false)
    @Enumerated(value=EnumType.STRING)
    @ApiModelProperty(value="Type of the consent request: GLOBAL, BANK_OFFERED or DEDICATED_ACCOUNTS.", required=true, example="GLOBAL")
    private AisConsentRequestType aisConsentRequestType;
    @Column(name="creation_timestamp", nullable=false)
    @ApiModelProperty(value="Creation timestamp of the consent.", required=true, example="2018-12-28T00:00:00Z")
    private OffsetDateTime creationTimestamp = OffsetDateTime.now();
    @Column(name="available_accounts")
    @Enumerated(value=EnumType.STRING)
    @ApiModelProperty(value="Type of the available accounts access type: ALL_ACCOUNTS, ALL_ACCOUNTS_WITH_BALANCES.", example="ALL_ACCOUNTS")
    private AccountAccessType availableAccounts;
    @Column(name="all_psd2")
    @Enumerated(value=EnumType.STRING)
    @ApiModelProperty(value="Type of the account access types.", example="ALL_ACCOUNTS")
    private AccountAccessType allPsd2;
    @Column(name="multilevel_sca_required", nullable=false)
    private boolean multilevelScaRequired;

    public List<TppAccountAccess> getAccesses() {
        return new ArrayList<TppAccountAccess>(this.accesses);
    }

    public boolean isExpiredByDate() {
        return LocalDate.now().compareTo(this.expireDate) > 0;
    }

    public boolean isStatusNotExpired() {
        return this.consentStatus != ConsentStatus.EXPIRED;
    }

    public boolean isConfirmationExpired(long expirationPeriodMs) {
        if (this.isNotConfirmed()) {
            return this.creationTimestamp.plus(expirationPeriodMs, ChronoUnit.MILLIS).isBefore(OffsetDateTime.now());
        }
        return false;
    }

    public boolean isNotConfirmed() {
        return this.consentStatus == ConsentStatus.RECEIVED;
    }

    public void addAccountAccess(Set<TppAccountAccess> accountAccesses) {
        this.accesses = new ArrayList<TppAccountAccess>(accountAccesses);
    }

    public void addAspspAccountAccess(Set<AspspAccountAccess> aspspAccesses) {
        this.aspspAccountAccesses = new ArrayList<AspspAccountAccess>(aspspAccesses);
    }

    public boolean isOneAccessType() {
        return !this.recurringIndicator;
    }

    public boolean isWrongConsentData() {
        return CollectionUtils.isEmpty(this.psuDataList) || this.tppInfo == null;
    }

    public void addUsage(AisConsentUsage aisConsentUsage) {
        if (this.usages == null) {
            this.usages = new ArrayList<AisConsentUsage>();
        }
        this.usages.add(aisConsentUsage);
    }

    public Long getId() {
        return this.id;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public boolean isRecurringIndicator() {
        return this.recurringIndicator;
    }

    public boolean isTppRedirectPreferred() {
        return this.tppRedirectPreferred;
    }

    public boolean isCombinedServiceIndicator() {
        return this.combinedServiceIndicator;
    }

    public LocalDateTime getRequestDateTime() {
        return this.requestDateTime;
    }

    public LocalDate getLastActionDate() {
        return this.lastActionDate;
    }

    public LocalDate getExpireDate() {
        return this.expireDate;
    }

    public List<PsuData> getPsuDataList() {
        return this.psuDataList;
    }

    public TppInfoEntity getTppInfo() {
        return this.tppInfo;
    }

    public ConsentStatus getConsentStatus() {
        return this.consentStatus;
    }

    public ConsentType getConsentType() {
        return this.consentType;
    }

    public int getAllowedFrequencyPerDay() {
        return this.allowedFrequencyPerDay;
    }

    public int getTppFrequencyPerDay() {
        return this.tppFrequencyPerDay;
    }

    @Deprecated
    public int getUsageCounter() {
        return this.usageCounter;
    }

    public List<AisConsentUsage> getUsages() {
        return this.usages;
    }

    public List<AspspAccountAccess> getAspspAccountAccesses() {
        return this.aspspAccountAccesses;
    }

    public List<AisConsentAuthorization> getAuthorizations() {
        return this.authorizations;
    }

    public AisConsentRequestType getAisConsentRequestType() {
        return this.aisConsentRequestType;
    }

    public OffsetDateTime getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public AccountAccessType getAvailableAccounts() {
        return this.availableAccounts;
    }

    public AccountAccessType getAllPsd2() {
        return this.allPsd2;
    }

    public boolean isMultilevelScaRequired() {
        return this.multilevelScaRequired;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public void setRecurringIndicator(boolean recurringIndicator) {
        this.recurringIndicator = recurringIndicator;
    }

    public void setTppRedirectPreferred(boolean tppRedirectPreferred) {
        this.tppRedirectPreferred = tppRedirectPreferred;
    }

    public void setCombinedServiceIndicator(boolean combinedServiceIndicator) {
        this.combinedServiceIndicator = combinedServiceIndicator;
    }

    public void setRequestDateTime(LocalDateTime requestDateTime) {
        this.requestDateTime = requestDateTime;
    }

    public void setLastActionDate(LocalDate lastActionDate) {
        this.lastActionDate = lastActionDate;
    }

    public void setExpireDate(LocalDate expireDate) {
        this.expireDate = expireDate;
    }

    public void setPsuDataList(List<PsuData> psuDataList) {
        this.psuDataList = psuDataList;
    }

    public void setTppInfo(TppInfoEntity tppInfo) {
        this.tppInfo = tppInfo;
    }

    public void setConsentStatus(ConsentStatus consentStatus) {
        this.consentStatus = consentStatus;
    }

    public void setConsentType(ConsentType consentType) {
        this.consentType = consentType;
    }

    public void setAllowedFrequencyPerDay(int allowedFrequencyPerDay) {
        this.allowedFrequencyPerDay = allowedFrequencyPerDay;
    }

    public void setTppFrequencyPerDay(int tppFrequencyPerDay) {
        this.tppFrequencyPerDay = tppFrequencyPerDay;
    }

    @Deprecated
    public void setUsageCounter(int usageCounter) {
        this.usageCounter = usageCounter;
    }

    public void setUsages(List<AisConsentUsage> usages) {
        this.usages = usages;
    }

    public void setAccesses(List<TppAccountAccess> accesses) {
        this.accesses = accesses;
    }

    public void setAspspAccountAccesses(List<AspspAccountAccess> aspspAccountAccesses) {
        this.aspspAccountAccesses = aspspAccountAccesses;
    }

    public void setAuthorizations(List<AisConsentAuthorization> authorizations) {
        this.authorizations = authorizations;
    }

    public void setAisConsentRequestType(AisConsentRequestType aisConsentRequestType) {
        this.aisConsentRequestType = aisConsentRequestType;
    }

    public void setCreationTimestamp(OffsetDateTime creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    public void setAvailableAccounts(AccountAccessType availableAccounts) {
        this.availableAccounts = availableAccounts;
    }

    public void setAllPsd2(AccountAccessType allPsd2) {
        this.allPsd2 = allPsd2;
    }

    public void setMultilevelScaRequired(boolean multilevelScaRequired) {
        this.multilevelScaRequired = multilevelScaRequired;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AisConsent)) {
            return false;
        }
        AisConsent other = (AisConsent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$externalId = this.getExternalId();
        String other$externalId = other.getExternalId();
        if (this$externalId == null ? other$externalId != null : !this$externalId.equals(other$externalId)) {
            return false;
        }
        if (this.isRecurringIndicator() != other.isRecurringIndicator()) {
            return false;
        }
        if (this.isTppRedirectPreferred() != other.isTppRedirectPreferred()) {
            return false;
        }
        if (this.isCombinedServiceIndicator() != other.isCombinedServiceIndicator()) {
            return false;
        }
        LocalDateTime this$requestDateTime = this.getRequestDateTime();
        LocalDateTime other$requestDateTime = other.getRequestDateTime();
        if (this$requestDateTime == null ? other$requestDateTime != null : !((Object)this$requestDateTime).equals(other$requestDateTime)) {
            return false;
        }
        LocalDate this$lastActionDate = this.getLastActionDate();
        LocalDate other$lastActionDate = other.getLastActionDate();
        if (this$lastActionDate == null ? other$lastActionDate != null : !((Object)this$lastActionDate).equals(other$lastActionDate)) {
            return false;
        }
        LocalDate this$expireDate = this.getExpireDate();
        LocalDate other$expireDate = other.getExpireDate();
        if (this$expireDate == null ? other$expireDate != null : !((Object)this$expireDate).equals(other$expireDate)) {
            return false;
        }
        List<PsuData> this$psuDataList = this.getPsuDataList();
        List<PsuData> other$psuDataList = other.getPsuDataList();
        if (this$psuDataList == null ? other$psuDataList != null : !((Object)this$psuDataList).equals(other$psuDataList)) {
            return false;
        }
        TppInfoEntity this$tppInfo = this.getTppInfo();
        TppInfoEntity other$tppInfo = other.getTppInfo();
        if (this$tppInfo == null ? other$tppInfo != null : !((Object)this$tppInfo).equals(other$tppInfo)) {
            return false;
        }
        ConsentStatus this$consentStatus = this.getConsentStatus();
        ConsentStatus other$consentStatus = other.getConsentStatus();
        if (this$consentStatus == null ? other$consentStatus != null : !this$consentStatus.equals(other$consentStatus)) {
            return false;
        }
        ConsentType this$consentType = this.getConsentType();
        ConsentType other$consentType = other.getConsentType();
        if (this$consentType == null ? other$consentType != null : !this$consentType.equals(other$consentType)) {
            return false;
        }
        if (this.getAllowedFrequencyPerDay() != other.getAllowedFrequencyPerDay()) {
            return false;
        }
        if (this.getTppFrequencyPerDay() != other.getTppFrequencyPerDay()) {
            return false;
        }
        if (this.getUsageCounter() != other.getUsageCounter()) {
            return false;
        }
        List<AisConsentUsage> this$usages = this.getUsages();
        List<AisConsentUsage> other$usages = other.getUsages();
        if (this$usages == null ? other$usages != null : !((Object)this$usages).equals(other$usages)) {
            return false;
        }
        List<TppAccountAccess> this$accesses = this.getAccesses();
        List<TppAccountAccess> other$accesses = other.getAccesses();
        if (this$accesses == null ? other$accesses != null : !((Object)this$accesses).equals(other$accesses)) {
            return false;
        }
        List<AspspAccountAccess> this$aspspAccountAccesses = this.getAspspAccountAccesses();
        List<AspspAccountAccess> other$aspspAccountAccesses = other.getAspspAccountAccesses();
        if (this$aspspAccountAccesses == null ? other$aspspAccountAccesses != null : !((Object)this$aspspAccountAccesses).equals(other$aspspAccountAccesses)) {
            return false;
        }
        List<AisConsentAuthorization> this$authorizations = this.getAuthorizations();
        List<AisConsentAuthorization> other$authorizations = other.getAuthorizations();
        if (this$authorizations == null ? other$authorizations != null : !((Object)this$authorizations).equals(other$authorizations)) {
            return false;
        }
        AisConsentRequestType this$aisConsentRequestType = this.getAisConsentRequestType();
        AisConsentRequestType other$aisConsentRequestType = other.getAisConsentRequestType();
        if (this$aisConsentRequestType == null ? other$aisConsentRequestType != null : !this$aisConsentRequestType.equals(other$aisConsentRequestType)) {
            return false;
        }
        OffsetDateTime this$creationTimestamp = this.getCreationTimestamp();
        OffsetDateTime other$creationTimestamp = other.getCreationTimestamp();
        if (this$creationTimestamp == null ? other$creationTimestamp != null : !((Object)this$creationTimestamp).equals(other$creationTimestamp)) {
            return false;
        }
        AccountAccessType this$availableAccounts = this.getAvailableAccounts();
        AccountAccessType other$availableAccounts = other.getAvailableAccounts();
        if (this$availableAccounts == null ? other$availableAccounts != null : !this$availableAccounts.equals(other$availableAccounts)) {
            return false;
        }
        AccountAccessType this$allPsd2 = this.getAllPsd2();
        AccountAccessType other$allPsd2 = other.getAllPsd2();
        if (this$allPsd2 == null ? other$allPsd2 != null : !this$allPsd2.equals(other$allPsd2)) {
            return false;
        }
        return this.isMultilevelScaRequired() == other.isMultilevelScaRequired();
    }

    protected boolean canEqual(Object other) {
        return other instanceof AisConsent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : $externalId.hashCode());
        result = result * 59 + (this.isRecurringIndicator() ? 79 : 97);
        result = result * 59 + (this.isTppRedirectPreferred() ? 79 : 97);
        result = result * 59 + (this.isCombinedServiceIndicator() ? 79 : 97);
        LocalDateTime $requestDateTime = this.getRequestDateTime();
        result = result * 59 + ($requestDateTime == null ? 43 : ((Object)$requestDateTime).hashCode());
        LocalDate $lastActionDate = this.getLastActionDate();
        result = result * 59 + ($lastActionDate == null ? 43 : ((Object)$lastActionDate).hashCode());
        LocalDate $expireDate = this.getExpireDate();
        result = result * 59 + ($expireDate == null ? 43 : ((Object)$expireDate).hashCode());
        List<PsuData> $psuDataList = this.getPsuDataList();
        result = result * 59 + ($psuDataList == null ? 43 : ((Object)$psuDataList).hashCode());
        TppInfoEntity $tppInfo = this.getTppInfo();
        result = result * 59 + ($tppInfo == null ? 43 : ((Object)$tppInfo).hashCode());
        ConsentStatus $consentStatus = this.getConsentStatus();
        result = result * 59 + ($consentStatus == null ? 43 : $consentStatus.hashCode());
        ConsentType $consentType = this.getConsentType();
        result = result * 59 + ($consentType == null ? 43 : $consentType.hashCode());
        result = result * 59 + this.getAllowedFrequencyPerDay();
        result = result * 59 + this.getTppFrequencyPerDay();
        result = result * 59 + this.getUsageCounter();
        List<AisConsentUsage> $usages = this.getUsages();
        result = result * 59 + ($usages == null ? 43 : ((Object)$usages).hashCode());
        List<TppAccountAccess> $accesses = this.getAccesses();
        result = result * 59 + ($accesses == null ? 43 : ((Object)$accesses).hashCode());
        List<AspspAccountAccess> $aspspAccountAccesses = this.getAspspAccountAccesses();
        result = result * 59 + ($aspspAccountAccesses == null ? 43 : ((Object)$aspspAccountAccesses).hashCode());
        List<AisConsentAuthorization> $authorizations = this.getAuthorizations();
        result = result * 59 + ($authorizations == null ? 43 : ((Object)$authorizations).hashCode());
        AisConsentRequestType $aisConsentRequestType = this.getAisConsentRequestType();
        result = result * 59 + ($aisConsentRequestType == null ? 43 : $aisConsentRequestType.hashCode());
        OffsetDateTime $creationTimestamp = this.getCreationTimestamp();
        result = result * 59 + ($creationTimestamp == null ? 43 : ((Object)$creationTimestamp).hashCode());
        AccountAccessType $availableAccounts = this.getAvailableAccounts();
        result = result * 59 + ($availableAccounts == null ? 43 : $availableAccounts.hashCode());
        AccountAccessType $allPsd2 = this.getAllPsd2();
        result = result * 59 + ($allPsd2 == null ? 43 : $allPsd2.hashCode());
        result = result * 59 + (this.isMultilevelScaRequired() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "AisConsent(id=" + this.getId() + ", externalId=" + this.getExternalId() + ", recurringIndicator=" + this.isRecurringIndicator() + ", tppRedirectPreferred=" + this.isTppRedirectPreferred() + ", combinedServiceIndicator=" + this.isCombinedServiceIndicator() + ", requestDateTime=" + this.getRequestDateTime() + ", lastActionDate=" + this.getLastActionDate() + ", expireDate=" + this.getExpireDate() + ", psuDataList=" + this.getPsuDataList() + ", tppInfo=" + this.getTppInfo() + ", consentStatus=" + this.getConsentStatus() + ", consentType=" + this.getConsentType() + ", allowedFrequencyPerDay=" + this.getAllowedFrequencyPerDay() + ", tppFrequencyPerDay=" + this.getTppFrequencyPerDay() + ", usageCounter=" + this.getUsageCounter() + ", aspspAccountAccesses=" + this.getAspspAccountAccesses() + ", aisConsentRequestType=" + this.getAisConsentRequestType() + ", creationTimestamp=" + this.getCreationTimestamp() + ", availableAccounts=" + this.getAvailableAccounts() + ", allPsd2=" + this.getAllPsd2() + ", multilevelScaRequired=" + this.isMultilevelScaRequired() + ")";
    }
}

