/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.security.provider;

import de.adorsys.psd2.consent.domain.CryptoAlgorithm;
import de.adorsys.psd2.consent.repository.CryptoAlgorithmRepository;
import de.adorsys.psd2.consent.service.security.provider.AesEcbCryptoProviderImpl;
import de.adorsys.psd2.consent.service.security.provider.CryptoProvider;
import de.adorsys.psd2.consent.service.security.provider.JweCryptoProviderImpl;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CryptoProviderFactory {
    private static final Logger log = LoggerFactory.getLogger(CryptoProviderFactory.class);
    private final CryptoAlgorithmRepository cryptoAlgorithmRepository;
    private CryptoProvider aesEcbCryptoProviderId = new AesEcbCryptoProviderImpl();
    private CryptoProvider jweCryptoProviderConsentData = new JweCryptoProviderImpl();

    public Optional<CryptoProvider> getCryptoProviderByAlgorithmVersion(String algorithmVersion) {
        Optional<CryptoProvider> provider = this.cryptoAlgorithmRepository.findByExternalId(algorithmVersion).map(CryptoAlgorithm::getAlgorithm).flatMap(this::mapCryptoProviderByAlgorithmName);
        if (!provider.isPresent()) {
            log.info("Crypto Algorithm ID: {{}}. Crypto provider can not be identify by id", (Object)algorithmVersion);
        }
        return provider;
    }

    public CryptoProvider actualIdentifierCryptoProvider() {
        return this.aesEcbCryptoProviderId;
    }

    public CryptoProvider actualConsentDataCryptoProvider() {
        return this.jweCryptoProviderConsentData;
    }

    private Optional<CryptoProvider> mapCryptoProviderByAlgorithmName(String algorithm) {
        if (algorithm.equals(this.aesEcbCryptoProviderId.getAlgorithmVersion().getAlgorithmName())) {
            return Optional.of(this.aesEcbCryptoProviderId);
        }
        if (algorithm.equals(this.jweCryptoProviderConsentData.getAlgorithmVersion().getAlgorithmName())) {
            return Optional.of(this.jweCryptoProviderConsentData);
        }
        log.info("Crypto provider can not be identify by algorithm: {}", (Object)algorithm);
        return Optional.empty();
    }

    @ConstructorProperties(value={"cryptoAlgorithmRepository"})
    public CryptoProviderFactory(CryptoAlgorithmRepository cryptoAlgorithmRepository) {
        this.cryptoAlgorithmRepository = cryptoAlgorithmRepository;
    }
}

